/*
 * Decompiled with CFR 0.152.
 */
package com.bsg.dm2.nokia;

import com.bsg.nokia.BSCanvas;
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DiamondMine2Canvas
extends BSCanvas
implements Runnable {
    private Image[][] backBuffers;
    private Image statusImage;
    private Image[] tiles;
    private Image[][] playerImages;
    private Image[][] enemyImages;
    private Image[] teleportImages;
    private Image livesImage;
    private Image diamondImage;
    private Image slashImage;
    private Image optionsImage;
    private Image[] digits;
    private Graphics[][] backSurfaces;
    private Graphics statusGraphics;
    private Thread instance;
    private boolean running;
    private int screenWidth;
    private int halfScreenWidth;
    private int screenHeight;
    private int halfScreenHeight;
    private int statusHeight = 7;
    private int levelWidth;
    private int levelHeight;
    private int levelDiamonds;
    private int xOffSet;
    private int xOffSetAdjust;
    private int xOffSetAdjustValue = 0;
    private int xOffSetCounter;
    private int yOffSet;
    private int yOffSetAdjust;
    private int yOffSetAdjustValue = 13;
    private int yOffSetCounter;
    private int tileWidth;
    private int halfTileWidth;
    private int tileHeight;
    private int halfTileHeight;
    private int[][][] level;
    private int[][] spiders;
    private int currentLevel;
    private int difficulty;
    private int exitX;
    private int exitY;
    private int[][] teleporters;
    private int teleportFrame;
    private int fallingCounter;
    private int backBufferSegmentWidth;
    private int backBufferSegmentHeight;
    private int pXPos;
    private int pYPos;
    private int pDX;
    private int pDY;
    private int pSpeed;
    private int pDiamonds;
    private int pLives;
    private int pMove;
    private int pFrame;
    private int pCurrentTileX;
    private int pCurrentTileY;
    private int pMoveToTileX;
    private int pMoveToTileY;
    private String[] endString;
    private Image endScreen;
    private int endStringCenterX;
    private int endStringTop;
    private int[][] endGems;
    private int[] endBaddy;
    private boolean playerTalking;
    private boolean enemyTalking;
    private Font[] endStringFont;
    private boolean pInTile;
    private Vector fallingObjects;
    private final int[] P_FRAMES = new int[]{2, 2, 2, 2, 1};
    private final int P_UP;
    private final int P_DOWN;
    private final int P_LEFT;
    private final int P_RIGHT;
    private final int P_DEAD;
    private final int[] M_FRAMES = new int[]{2, 2, 2, 2};
    private final int M_UP;
    private final int M_DOWN;
    private final int M_LEFT;
    private final int M_RIGHT;
    private final int M_X;
    private final int M_Y;
    private final int M_DX;
    private final int M_DY;
    private final int M_SPEED;
    private final int M_MOVE_COUNTER;
    private final int M_MOVE;
    private final int M_FRAME;
    private final int DIAMOND_SCORE;
    private final int ENEMY_SCORE;
    private final int MAX_BUFFER_WIDTH;
    private final int MAX_BUFFER_HEIGHT;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;
    private boolean updateStatus;
    private boolean keyPressed;
    private boolean start;
    private boolean levelClear;
    private boolean blankScreen;
    private boolean won;
    private boolean dead;
    private boolean gameover;
    private boolean gamecomplete;
    private Sound[] sounds;
    private final byte[][] soundBytes = new byte[][]{{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 32, 105, 5, 88, 98, 7, 24, -94, 48, 73, -56, 26, 97, 8, 26, 65, 86, 24, -126, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 77, 5, 80, 97, 5, -112, 65, -128, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 32, 86, 0, 0}};
    private final int WON_MELODY;
    private final int DEAD_MELODY;
    private final int BEEP_MED;

    public DiamondMine2Canvas() {
        Image image;
        this.P_UP = 0;
        this.P_DOWN = 1;
        this.P_LEFT = 2;
        this.P_RIGHT = 3;
        this.P_DEAD = 4;
        this.M_UP = 0;
        this.M_DOWN = 1;
        this.M_LEFT = 2;
        this.M_RIGHT = 3;
        this.M_X = 0;
        this.M_Y = 1;
        this.M_DX = 2;
        this.M_DY = 3;
        this.M_SPEED = 4;
        this.M_MOVE_COUNTER = 5;
        this.M_MOVE = 6;
        this.M_FRAME = 7;
        this.DIAMOND_SCORE = 10;
        this.ENEMY_SCORE = 20;
        this.MAX_BUFFER_WIDTH = 160;
        this.MAX_BUFFER_HEIGHT = 160;
        this.WON_MELODY = 0;
        this.DEAD_MELODY = 1;
        this.BEEP_MED = 2;
        this.screenWidth = this.getWidth();
        this.halfScreenWidth = this.screenWidth / 2;
        this.screenHeight = this.getHeight() - this.statusHeight;
        this.halfScreenHeight = this.screenHeight / 2;
        this.statusImage = Image.createImage((int)this.screenWidth, (int)this.statusHeight);
        this.statusGraphics = this.statusImage.getGraphics();
        this.sounds = new Sound[this.soundBytes.length];
        for (int i = 0; i < this.sounds.length; ++i) {
            this.sounds[i] = new Sound(this.soundBytes[i], 1);
            this.sounds[i].init(this.soundBytes[i], 1);
        }
        try {
            int n;
            this.tiles = new Image[50];
            image = Image.createImage((String)"/Tiles.png");
            this.tileWidth = image.getWidth() / 10;
            this.halfTileWidth = this.tileWidth / 2;
            this.tileHeight = image.getHeight() / 5;
            this.halfTileHeight = this.tileHeight / 2;
            for (n = 10; n < 11; ++n) {
                this.tiles[n] = this.getImage(image, this.tileWidth, this.tileHeight, -(n - n / 10 * 10) * this.tileWidth, -(n / 10) * this.tileHeight);
            }
            for (n = 20; n < 25; ++n) {
                this.tiles[n] = this.getImage(image, this.tileWidth, this.tileHeight, -(n - n / 10 * 10) * this.tileWidth, -(n / 10) * this.tileHeight);
            }
            for (n = 29; n < 35; ++n) {
                this.tiles[n] = this.getImage(image, this.tileWidth, this.tileHeight, -(n - n / 10 * 10) * this.tileWidth, -(n / 10) * this.tileHeight);
            }
            for (n = 40; n < 45; ++n) {
                this.tiles[n] = this.getImage(image, this.tileWidth, this.tileHeight, -(n - n / 10 * 10) * this.tileWidth, -(n / 10) * this.tileHeight);
            }
            for (n = 48; n < 50; ++n) {
                this.tiles[n] = this.getImage(image, this.tileWidth, this.tileHeight, -(n - n / 10 * 10) * this.tileWidth, -(n / 10) * this.tileHeight);
            }
            Image image2 = Image.createImage((String)"/PlayerImages.png");
            this.playerImages = new Image[5][];
            for (int i = 0; i < 4; ++i) {
                this.playerImages[i] = new Image[]{this.getImage(image2, this.tileWidth, this.tileHeight, 0, -this.tileHeight * i), this.getImage(image2, this.tileWidth, this.tileHeight, -this.tileWidth, -this.tileHeight * i)};
            }
            this.playerImages[4] = new Image[]{this.getImage(image2, this.tileWidth, this.tileHeight, 0, -this.tileHeight * 4)};
            Image image3 = Image.createImage((String)"/EnemyImages.png");
            this.enemyImages = new Image[4][];
            for (int i = 0; i < 4; ++i) {
                this.enemyImages[i] = new Image[]{this.getImage(image3, this.tileWidth, this.tileHeight, 0, -this.tileHeight * i), this.getImage(image3, this.tileWidth, this.tileHeight, -this.tileWidth, -this.tileHeight * i)};
            }
            Image image4 = Image.createImage((String)"/TeleportImages.png");
            this.teleportImages = new Image[4];
            for (int i = 0; i < 4; ++i) {
                this.teleportImages[i] = this.getImage(image4, this.tileWidth, this.tileHeight, -this.tileWidth * i, 0);
            }
            Image image5 = Image.createImage((String)"/Status.png");
            this.livesImage = this.getImage(image5, 7, 7, -30, 0);
            this.diamondImage = this.getImage(image5, 9, 7, -37, 0);
            this.slashImage = this.getImage(image5, 3, 5, -46, 0);
            this.optionsImage = this.getImage(image5, image5.getWidth() - 49, 7, -49, 0);
            this.digits = new Image[10];
            for (int i = 0; i < this.digits.length; ++i) {
                this.digits[i] = this.getImage(image5, 3, 5, -3 * i, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.endScreen = Image.createImage((int)this.screenWidth, (int)(this.screenHeight + this.statusHeight));
        image = this.endScreen.getGraphics();
        image.setColor(0xFFFFFF);
        image.fillRect(0, 0, this.screenWidth, this.screenHeight + this.statusHeight);
        int n = this.screenWidth / this.tileWidth + 1;
        for (int i = 0; i < n; ++i) {
            image.drawImage(this.tiles[20], i * this.tileWidth, 0, 20);
            image.drawImage(this.tiles[20], i * this.tileWidth, this.screenHeight + this.statusHeight, 36);
        }
        this.pSpeed = (this.tileWidth + this.tileHeight) / 6 + 1;
    }

    private Image getImage(Image image, int n, int n2, int n3, int n4) {
        Image image2 = Image.createImage((int)n, (int)n2);
        Graphics graphics = image2.getGraphics();
        graphics.drawImage(image, n3, n4, 20);
        return image2;
    }

    public void startGame(int n, Gauge gauge) {
        this.difficulty = n;
        this.currentLevel = 0;
        try {
            this.loadLevel(gauge);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pLives = 5;
        this.score = 0;
        gauge.setValue(100);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void nextLevel(Gauge gauge) {
        if (!this.dead) {
            ++this.currentLevel;
        }
        try {
            this.loadLevel(gauge);
        }
        catch (Exception exception) {
            // empty catch block
        }
        gauge.setValue(100);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    private void loadLevel(Gauge gauge) throws Exception {
        int n;
        int n2;
        InputStream inputStream = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/Levels/level").append(this.currentLevel).append(".txt"))));
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        gauge.setValue(10);
        this.pXPos = dataInputStream.readInt() * this.tileWidth;
        this.pYPos = dataInputStream.readInt() * this.tileHeight;
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        this.level = new int[n4][n3][1];
        this.levelWidth = n3 * this.tileWidth;
        this.levelHeight = n4 * this.tileHeight;
        int n5 = this.levelWidth < 160 ? 1 : (n2 = this.levelWidth / 160 + (this.levelWidth % 160 == 0 ? 0 : 1));
        int n6 = this.levelHeight < 160 ? 1 : this.levelHeight / 160 + (this.levelHeight % 160 == 0 ? 0 : 1);
        this.backBufferSegmentWidth = this.levelWidth / n2 + this.tileWidth - this.levelWidth / n2 % this.tileWidth;
        this.backBufferSegmentHeight = this.levelHeight / n6 + this.tileHeight - this.levelHeight / n6 % this.tileHeight;
        this.backBuffers = new Image[n2][n6];
        this.backSurfaces = new Graphics[n2][n6];
        this.levelDiamonds = 0;
        this.fallingObjects = new Vector(10);
        Vector<int[]> vector = new Vector<int[]>(10);
        gauge.setValue(30);
        for (n = 0; n < this.level[0].length; ++n) {
            for (int i = 0; i < this.level.length; ++i) {
                this.level[i][n][0] = dataInputStream.readByte();
                if (this.level[i][n][0] == 0) continue;
                if (this.level[i][n][0] >= 30 && this.level[i][n][0] < 45) {
                    this.level[i][n] = new int[]{this.level[i][n][0], n, i, 0};
                }
                if (this.level[i][n][0] >= 40 && this.level[i][n][0] < 45) {
                    ++this.levelDiamonds;
                }
                if (this.level[i][n][0] == 29) {
                    this.exitX = n;
                    this.exitY = i;
                }
                if (this.level[i][n][0] < 50 || this.level[i][n][0] >= 60) continue;
                vector.addElement(new int[]{n * this.tileWidth, i * this.tileHeight, 0, -(this.pSpeed - (3 - this.difficulty)), this.pSpeed - (3 - this.difficulty), 0, 0, 0});
                this.level[i][n] = new int[]{0};
            }
        }
        this.drawToBackBuffers();
        gauge.setValue(50);
        this.teleporters = new int[dataInputStream.readByte() * 2][];
        for (n = 0; n < this.teleporters.length / 2; ++n) {
            int[] nArray = new int[]{dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()};
            this.teleporters[n * 2] = new int[]{nArray[0], nArray[1], nArray[2], nArray[3]};
            this.teleporters[n * 2 + 1] = new int[]{nArray[2], nArray[3], nArray[0], nArray[1]};
        }
        this.spiders = new int[vector.size()][];
        for (n = 0; n < this.spiders.length; ++n) {
            this.spiders[n] = (int[])vector.elementAt(n);
        }
        dataInputStream.close();
        gauge.setValue(70);
        this.pCurrentTileX = this.pXPos / this.tileWidth;
        this.pCurrentTileY = this.pYPos / this.tileHeight;
        this.pMoveToTileX = this.pXPos / this.tileWidth;
        this.pMoveToTileY = this.pYPos / this.tileHeight;
        this.pDX = 0;
        this.pDY = 0;
        this.pDiamonds = 0;
        this.pMove = 3;
        this.pFrame = 0;
        this.pInTile = true;
        this.xOffSet = this.levelWidth < this.screenWidth ? (this.screenWidth - this.levelWidth) / 2 : 0;
        this.yOffSet = this.levelHeight < this.screenHeight ? (this.screenHeight - this.levelHeight) / 2 : 0;
        this.updateStatus = true;
        this.won = false;
        this.levelClear = false;
        this.dead = false;
        this.gameover = false;
        this.gamecomplete = false;
        this.start = true;
        this.xOffSetCounter = 0;
        this.xOffSetAdjust = -this.xOffSetAdjustValue;
        this.yOffSetCounter = 0;
        this.yOffSetAdjust = 0;
        this.fallingCounter = 0;
    }

    private void blankTile(int n, int n2) {
        int n3 = n / this.backBufferSegmentWidth;
        int n4 = n2 / this.backBufferSegmentHeight;
        this.backSurfaces[n3][n4].fillRect(n - n3 * this.backBufferSegmentWidth, n2 - n4 * this.backBufferSegmentHeight, this.tileWidth, this.tileHeight);
    }

    private void drawToBackBuffers(int n, int n2, int n3) {
        int n4 = n * this.tileWidth / this.backBufferSegmentWidth;
        int n5 = n2 * this.tileHeight / this.backBufferSegmentHeight;
        this.backSurfaces[n4][n5].drawImage(this.tiles[n3], n * this.tileWidth - n4 * this.backBufferSegmentWidth, n2 * this.tileHeight - n5 * this.backBufferSegmentHeight, 20);
    }

    private void drawToBackBuffers() {
        int n = this.backBufferSegmentWidth / this.tileWidth;
        int n2 = this.backBufferSegmentHeight / this.tileHeight;
        for (int i = 0; i < this.backBuffers.length; ++i) {
            int n3 = i * n;
            for (int j = 0; j < this.backBuffers[i].length; ++j) {
                int n4 = j * n2;
                this.backBuffers[i][j] = Image.createImage((int)this.backBufferSegmentWidth, (int)this.backBufferSegmentHeight);
                this.backSurfaces[i][j] = this.backBuffers[i][j].getGraphics();
                this.backSurfaces[i][j].setColor(0xFFFFFF);
                this.backSurfaces[i][j].fillRect(0, 0, this.backBufferSegmentWidth, this.backBufferSegmentHeight);
                for (int k = 0; k < n; ++k) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (n3 + k >= this.level[0].length || n4 + i2 >= this.level.length || this.level[n4 + i2][n3 + k][0] == 0) continue;
                        this.backSurfaces[i][j].drawImage(this.tiles[this.level[n4 + i2][n3 + k][0]], k * this.tileWidth, i2 * this.tileHeight, 20);
                    }
                }
            }
        }
    }

    public void loadGame(byte[] byArray, Gauge gauge) throws Exception {
        int n;
        int n2;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        this.currentLevel = dataInputStream.readByte();
        this.difficulty = dataInputStream.readByte();
        this.loadLevel(gauge);
        this.pXPos = dataInputStream.readInt();
        this.pYPos = dataInputStream.readInt();
        this.pDX = dataInputStream.readByte();
        this.pDY = dataInputStream.readByte();
        this.pSpeed = dataInputStream.readByte();
        this.pDiamonds = dataInputStream.readByte();
        this.pLives = dataInputStream.readByte();
        this.pMove = dataInputStream.readByte();
        this.pFrame = dataInputStream.readByte();
        this.pCurrentTileX = dataInputStream.readByte();
        this.pCurrentTileY = dataInputStream.readByte();
        this.pMoveToTileX = dataInputStream.readByte();
        this.pMoveToTileY = dataInputStream.readByte();
        gauge.setValue(80);
        for (n2 = 0; n2 < this.level[0].length; ++n2) {
            for (n = 0; n < this.level.length; ++n) {
                byte by = dataInputStream.readByte();
                this.level[n][n2] = by >= 30 && by < 45 ? new int[]{by, dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()} : new int[]{by};
            }
        }
        this.drawToBackBuffers();
        gauge.setValue(90);
        n2 = dataInputStream.readByte();
        this.fallingObjects = new Vector(n2);
        for (n = 0; n < n2; ++n) {
            this.fallingObjects.addElement(this.level[dataInputStream.readByte()][dataInputStream.readByte()]);
        }
        for (n = 0; n < this.spiders.length; ++n) {
            if (dataInputStream.readByte() == -1) {
                this.spiders[n] = null;
                continue;
            }
            this.spiders[n][0] = dataInputStream.readInt();
            this.spiders[n][1] = dataInputStream.readInt();
            this.spiders[n][2] = dataInputStream.readByte();
            this.spiders[n][3] = dataInputStream.readByte();
            this.spiders[n][4] = dataInputStream.readByte();
            this.spiders[n][5] = dataInputStream.readByte();
            this.spiders[n][6] = dataInputStream.readByte();
            this.spiders[n][7] = dataInputStream.readByte();
        }
        dataInputStream.close();
        gauge.setValue(100);
    }

    public byte[] saveGame(Gauge gauge) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            gauge.setValue(10);
            dataOutputStream.writeByte(this.currentLevel);
            dataOutputStream.writeByte(this.difficulty);
            dataOutputStream.writeInt(this.pXPos);
            dataOutputStream.writeInt(this.pYPos);
            dataOutputStream.writeByte(this.pDX);
            dataOutputStream.writeByte(this.pDY);
            dataOutputStream.writeByte(this.pSpeed);
            dataOutputStream.writeByte(this.pDiamonds);
            dataOutputStream.writeByte(this.pLives);
            dataOutputStream.writeByte(this.pMove);
            dataOutputStream.writeByte(this.pFrame);
            dataOutputStream.writeByte(this.pCurrentTileX);
            dataOutputStream.writeByte(this.pCurrentTileY);
            dataOutputStream.writeByte(this.pMoveToTileX);
            dataOutputStream.writeByte(this.pMoveToTileY);
            gauge.setValue(20);
            for (n = 0; n < this.level[0].length; ++n) {
                for (int i = 0; i < this.level.length; ++i) {
                    dataOutputStream.writeByte(this.level[i][n][0]);
                    if (this.level[i][n][0] < 30 || this.level[i][n][0] >= 45) continue;
                    dataOutputStream.writeByte(this.level[i][n][1]);
                    dataOutputStream.writeByte(this.level[i][n][2]);
                    dataOutputStream.writeByte(this.level[i][n][3]);
                }
            }
            gauge.setValue(50);
            dataOutputStream.writeByte(this.fallingObjects.size());
            for (n = 0; n < this.fallingObjects.size(); ++n) {
                int[] nArray = (int[])this.fallingObjects.elementAt(n);
                dataOutputStream.writeByte(nArray[2]);
                dataOutputStream.writeByte(nArray[1]);
            }
            gauge.setValue(70);
            for (n = 0; n < this.spiders.length; ++n) {
                if (this.spiders[n] == null) {
                    dataOutputStream.writeByte(-1);
                    continue;
                }
                dataOutputStream.writeByte(0);
                dataOutputStream.writeInt(this.spiders[n][0]);
                dataOutputStream.writeInt(this.spiders[n][1]);
                dataOutputStream.writeByte(this.spiders[n][2]);
                dataOutputStream.writeByte(this.spiders[n][3]);
                dataOutputStream.writeByte(this.spiders[n][4]);
                dataOutputStream.writeByte(this.spiders[n][5]);
                dataOutputStream.writeByte(this.spiders[n][6]);
                dataOutputStream.writeByte(this.spiders[n][7]);
            }
            gauge.setValue(80);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println("Saveing");
            byte[] byArray = null;
            return byArray;
        }
    }

    protected void paint(Graphics graphics) {
        if (!this.gamecomplete) {
            int n;
            int n2;
            if (this.updateStatus) {
                this.statusGraphics.setColor(0xFFFFFF);
                this.statusGraphics.fillRect(0, 0, this.screenWidth, this.statusHeight);
                this.statusGraphics.drawImage(this.optionsImage, this.screenWidth, this.statusHeight, 40);
                n2 = 0;
                n = 10000;
                for (int i = 5; i > 0; --i) {
                    this.statusGraphics.drawImage(this.digits[this.score / n % 10], n2, 1, 20);
                    n /= 10;
                    n2 += this.digits[0].getWidth() + 1;
                }
                this.statusGraphics.drawImage(this.livesImage, n2, 0, 20);
                this.statusGraphics.drawImage(this.digits[this.pLives / 10 % 10], n2 += this.livesImage.getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.digits[this.pLives % 10], n2 += this.digits[0].getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.diamondImage, n2 += this.digits[0].getWidth() + 1, 0, 20);
                this.statusGraphics.drawImage(this.digits[this.pDiamonds / 10 % 10], n2 += this.diamondImage.getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.digits[this.pDiamonds % 10], n2 += this.digits[0].getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.slashImage, n2 += this.digits[0].getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.digits[this.levelDiamonds / 10 % 10], n2 += this.slashImage.getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.digits[this.levelDiamonds % 10], n2 += this.digits[0].getWidth() + 1, 1, 20);
                this.updateStatus = false;
            }
            if (this.pXPos + this.halfTileWidth > this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter && this.levelWidth + this.xOffSet > this.screenWidth || this.pXPos + this.halfTileWidth < this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter - this.xOffSet && this.xOffSet < 0) {
                this.xOffSet = this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter - (this.pXPos + this.halfTileWidth);
                if (this.levelWidth + this.xOffSet < this.screenWidth) {
                    this.xOffSet = -(this.levelWidth - this.screenWidth);
                } else if (this.xOffSet > 0) {
                    this.xOffSet = 0;
                }
            }
            if (!this.won && !this.dead) {
                if (this.xOffSetCounter > 0) {
                    this.xOffSetCounter -= this.xOffSetCounter / 5 + 1;
                } else if (this.xOffSetCounter < 0) {
                    this.xOffSetCounter += -this.xOffSetCounter / 5 + 1;
                }
            }
            if (this.pYPos + this.halfTileHeight > this.halfScreenHeight + this.yOffSetAdjust - this.yOffSetCounter && this.levelHeight + this.yOffSet > this.screenHeight || this.pYPos + this.halfTileHeight < this.halfScreenHeight + this.yOffSetAdjust - this.yOffSetCounter - this.yOffSet && this.yOffSet < 0) {
                this.yOffSet = this.halfScreenHeight + this.yOffSetAdjust - this.yOffSetCounter - (this.pYPos + this.halfTileHeight);
                if (this.levelHeight + this.yOffSet < this.screenHeight) {
                    this.yOffSet = -(this.levelHeight - this.screenHeight);
                } else if (this.yOffSet > 0) {
                    this.yOffSet = 0;
                }
            }
            if (!this.won && !this.dead) {
                if (this.yOffSetCounter > 0) {
                    this.yOffSetCounter -= this.yOffSetCounter / 5 + 1;
                } else if (this.yOffSetCounter < 0) {
                    this.yOffSetCounter += -this.yOffSetCounter / 5 + 1;
                }
            }
            for (n2 = 0; n2 < this.backBuffers.length; ++n2) {
                for (n = 0; n < this.backBuffers[n2].length; ++n) {
                    graphics.drawImage(this.backBuffers[n2][n], this.xOffSet + this.backBufferSegmentWidth * n2, this.yOffSet + this.backBufferSegmentHeight * n, 20);
                }
            }
            for (n2 = 0; n2 < this.teleporters.length; ++n2) {
                graphics.drawImage(this.teleportImages[this.teleportFrame], this.xOffSet + this.teleporters[n2][0] * this.tileWidth, this.yOffSet + this.teleporters[n2][1] * this.tileHeight, 20);
            }
            for (n2 = 0; n2 < this.spiders.length; ++n2) {
                if (this.spiders[n2] == null) continue;
                graphics.drawImage(this.enemyImages[this.spiders[n2][6]][this.spiders[n2][7]], this.xOffSet + this.spiders[n2][0], this.yOffSet + this.spiders[n2][1], 20);
            }
            graphics.drawImage(this.playerImages[this.pMove][this.pFrame], this.xOffSet + this.pXPos, this.yOffSet + this.pYPos, 20);
            for (n2 = 0; n2 < this.fallingObjects.size(); ++n2) {
                int[] nArray = (int[])this.fallingObjects.elementAt(n2);
                graphics.drawImage(this.tiles[nArray[0]], this.xOffSet + nArray[1] * this.tileWidth, this.yOffSet + nArray[2] * this.tileHeight, 20);
            }
            graphics.drawImage(this.statusImage, 0, this.screenHeight, 20);
            if (this.levelClear) {
                this.drawText(graphics, this.parseString(this.langT[0]), this.getFont(this.langA[0]), true, this.halfScreenWidth, this.halfScreenHeight);
            } else if (this.gameover) {
                this.drawText(graphics, this.parseString(this.langT[1]), this.getFont(this.langA[1]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
            if (this.start) {
                this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[2]))).append(this.currentLevel + 1)))), this.getFont(this.langA[2]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
            if (this.paused) {
                this.drawText(graphics, this.parseString(this.langT[3]), this.getFont(this.langA[3]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
        } else {
            graphics.drawImage(this.endScreen, 0, 0, 20);
            for (int i = 0; i < this.endGems.length; ++i) {
                graphics.drawImage(this.tiles[this.endGems[i][0]], this.endGems[i][1], this.endGems[i][2], 20);
            }
            graphics.drawImage(this.playerImages[this.pMove][this.pFrame], this.pXPos, this.pYPos, 20);
            graphics.drawImage(this.enemyImages[this.endBaddy[0]][this.endBaddy[1]], this.endBaddy[2], this.endBaddy[3], 20);
            if (this.playerTalking) {
                graphics.drawLine(this.pXPos + this.halfTileWidth, this.pYPos - this.halfTileHeight, this.pXPos + this.tileWidth, this.pYPos - this.halfTileHeight - this.tileHeight);
            }
            if (this.enemyTalking) {
                graphics.drawLine(this.endBaddy[2] + this.halfTileWidth, this.endBaddy[3] - this.halfTileHeight, this.endBaddy[2], this.endBaddy[3] - this.halfTileHeight - this.tileHeight);
            }
            if (this.endString != null) {
                this.drawText(graphics, this.endString, this.endStringFont, true, this.endStringCenterX, this.endStringTop);
            }
        }
        if (this.blankScreen) {
            graphics.setColor(0xFFFFFF);
            graphics.setClip(0, 0, this.screenWidth, this.screenHeight + this.statusHeight);
            graphics.fillRect(0, 0, this.screenWidth, this.screenHeight + this.statusHeight);
            this.blankScreen = false;
        }
    }

    public void start() {
        if (this.instance == null || !this.running && !this.paused && !this.instance.isAlive()) {
            this.instance = new Thread(this);
            this.running = true;
            this.instance.start();
        } else if (this.instance.isAlive()) {
            this.running = true;
        }
    }

    public void stop() {
        this.running = false;
        this.keyPressed = false;
    }

    public void hideNotify() {
        this.stop();
    }

    public void showNotify() {
        this.start();
    }

    public void restartLevel() {
        BSCanvas.playSound(this.sounds[1]);
        BSCanvas.vibrate(50, 500);
        this.pMove = 4;
        this.pFrame = 0;
        this.dead = true;
        this.keyPressed = true;
    }

    private void moveSpiders() {
        for (int i = 0; i < this.spiders.length; ++i) {
            if (this.spiders[i] == null) continue;
            this.spiders[i][0] = this.spiders[i][0] + this.spiders[i][2];
            this.spiders[i][1] = this.spiders[i][1] + this.spiders[i][3];
            int n = 0;
            int n2 = 0;
            switch (this.spiders[i][6]) {
                case 0: {
                    n = (this.spiders[i][0] + this.halfTileWidth) / this.tileWidth;
                    n2 = this.spiders[i][1] / this.tileHeight;
                    break;
                }
                case 1: {
                    n = (this.spiders[i][0] + this.halfTileWidth) / this.tileWidth;
                    n2 = (this.spiders[i][1] + this.tileHeight) / this.tileHeight;
                    break;
                }
                case 2: {
                    n = this.spiders[i][0] / this.tileWidth;
                    n2 = (this.spiders[i][1] + this.halfTileHeight) / this.tileHeight;
                    break;
                }
                case 3: {
                    n = (this.spiders[i][0] + this.tileWidth) / this.tileWidth;
                    n2 = (this.spiders[i][1] + this.halfTileHeight) / this.tileHeight;
                }
            }
            if (this.level[n2][n][0] >= 10) {
                switch (this.spiders[i][6]) {
                    case 0: {
                        this.spiders[i][1] = n2 * this.tileHeight + this.tileHeight;
                        break;
                    }
                    case 1: {
                        this.spiders[i][1] = n2 * this.tileHeight - this.tileHeight;
                        break;
                    }
                    case 2: {
                        this.spiders[i][0] = n * this.tileWidth + this.tileWidth;
                        break;
                    }
                    case 3: {
                        this.spiders[i][0] = n * this.tileWidth - this.tileWidth;
                    }
                }
                this.spiders[i][6] = BSCanvas.getRandom(4);
                switch (this.spiders[i][6]) {
                    case 0: {
                        this.spiders[i][2] = 0;
                        this.spiders[i][3] = -this.spiders[i][4];
                        break;
                    }
                    case 1: {
                        this.spiders[i][2] = 0;
                        this.spiders[i][3] = this.spiders[i][4];
                        break;
                    }
                    case 2: {
                        this.spiders[i][2] = -this.spiders[i][4];
                        this.spiders[i][3] = 0;
                        break;
                    }
                    case 3: {
                        this.spiders[i][2] = this.spiders[i][4];
                        this.spiders[i][3] = 0;
                    }
                }
            }
            if (this.pXPos + this.halfTileWidth < this.spiders[i][0] || this.pXPos + this.halfTileWidth > this.spiders[i][0] + this.tileWidth || this.pYPos + this.halfTileHeight < this.spiders[i][1] || this.pYPos + this.halfTileHeight > this.spiders[i][1] + this.tileHeight) continue;
            this.restartLevel();
        }
    }

    public void run() {
        while (this.running) {
            try {
                int n;
                int n2;
                int n3;
                if (this.start) {
                    this.repaint();
                    Thread.sleep(2000L);
                    this.start = false;
                    this.repaint();
                }
                if (this.levelClear || this.gameover || !this.keyPressed) continue;
                ++this.teleportFrame;
                if (this.teleportFrame == this.teleportImages.length) {
                    this.teleportFrame = 0;
                }
                if (this.pInTile) {
                    if (this.up) {
                        this.pMoveToTileX = this.pCurrentTileX;
                        this.pMoveToTileY = this.pCurrentTileY - 1;
                        if (this.pMove != 0) {
                            this.pMove = 0;
                            this.yOffSetCounter = this.yOffSetAdjustValue - this.yOffSetAdjust + this.yOffSetCounter;
                            this.yOffSetAdjust = this.yOffSetAdjustValue;
                            this.xOffSetCounter = -this.xOffSetAdjust + this.xOffSetCounter;
                            this.xOffSetAdjust = 0;
                        }
                    } else if (this.down) {
                        this.pMoveToTileX = this.pCurrentTileX;
                        this.pMoveToTileY = this.pCurrentTileY + 1;
                        if (this.pMove != 1) {
                            this.pMove = 1;
                            this.yOffSetCounter = -this.yOffSetAdjustValue - this.yOffSetAdjust + this.yOffSetCounter;
                            this.yOffSetAdjust = -this.yOffSetAdjustValue;
                            this.xOffSetCounter = -this.xOffSetAdjust + this.xOffSetCounter;
                            this.xOffSetAdjust = 0;
                        }
                    } else if (this.left) {
                        this.pMoveToTileX = this.pCurrentTileX - 1;
                        this.pMoveToTileY = this.pCurrentTileY;
                        if (this.pMove != 2) {
                            this.pMove = 2;
                            this.xOffSetCounter = this.xOffSetAdjustValue - this.xOffSetAdjust + this.xOffSetCounter;
                            this.xOffSetAdjust = this.xOffSetAdjustValue;
                            this.yOffSetCounter = -this.yOffSetAdjust + this.yOffSetCounter;
                            this.yOffSetAdjust = 0;
                        }
                    } else if (this.right) {
                        this.pMoveToTileX = this.pCurrentTileX + 1;
                        this.pMoveToTileY = this.pCurrentTileY;
                        if (this.pMove != 3) {
                            this.pMove = 3;
                            this.xOffSetCounter = -this.xOffSetAdjustValue - this.xOffSetAdjust + this.xOffSetCounter;
                            this.xOffSetAdjust = -this.xOffSetAdjustValue;
                            this.yOffSetCounter = -this.yOffSetAdjust + this.yOffSetCounter;
                            this.yOffSetAdjust = 0;
                        }
                    }
                }
                int n4 = 0;
                int n5 = 0;
                if (this.level[this.pMoveToTileY][this.pMoveToTileX][0] < 20 || this.level[this.pMoveToTileY][this.pMoveToTileX][0] >= 40) {
                    n4 = this.pMoveToTileX * this.tileWidth - this.pXPos;
                    n5 = this.pMoveToTileY * this.tileHeight - this.pYPos;
                } else if (this.pCurrentTileY == this.pMoveToTileY && this.level[this.pMoveToTileY][this.pMoveToTileX][0] >= 30 && this.level[this.pMoveToTileY][this.pMoveToTileX][0] < 40) {
                    n3 = this.pMoveToTileX;
                    n3 = this.pMoveToTileX - this.pCurrentTileX > 0 ? ++n3 : --n3;
                    if (this.level[this.pMoveToTileY][n3][0] < 10) {
                        n2 = 0;
                        for (n = 0; n < this.spiders.length; ++n) {
                            if (this.spiders[n] == null || (this.spiders[n][0] + this.halfTileWidth) / this.tileWidth != n3 || (this.spiders[n][1] + this.halfTileHeight) / this.tileHeight != this.pMoveToTileY) continue;
                            n2 = 1;
                        }
                        if (n2 == 0) {
                            this.blankTile(this.pMoveToTileX * this.tileWidth, this.pMoveToTileY * this.tileWidth);
                            this.level[this.pMoveToTileY][n3] = this.level[this.pMoveToTileY][this.pMoveToTileX];
                            this.level[this.pMoveToTileY][this.pMoveToTileX] = new int[]{0};
                            this.level[this.pMoveToTileY][n3][1] = n3;
                            if (this.level[this.pMoveToTileY + 1][n3][0] < 10 || this.level[this.pMoveToTileY + 1][n3][0] >= 30 && this.level[this.pMoveToTileY + 1][n3][0] <= 45 && this.level[this.pMoveToTileY + 1][n3][3] == 1) {
                                this.fallingObjects.addElement(this.level[this.pMoveToTileY][n3]);
                                this.level[this.pMoveToTileY][n3][3] = 1;
                            } else if (this.level[this.pMoveToTileY][n3][3] == 0) {
                                this.drawToBackBuffers(n3, this.pMoveToTileY, this.level[this.pMoveToTileY][n3][0]);
                            }
                            n4 = this.pMoveToTileX * this.tileWidth - this.pXPos;
                            n5 = this.pMoveToTileY * this.tileHeight - this.pYPos;
                        } else {
                            this.pMoveToTileX = this.pCurrentTileX;
                            this.pMoveToTileY = this.pCurrentTileY;
                        }
                    } else {
                        this.pMoveToTileX = this.pCurrentTileX;
                        this.pMoveToTileY = this.pCurrentTileY;
                    }
                } else {
                    this.pMoveToTileX = this.pCurrentTileX;
                    this.pMoveToTileY = this.pCurrentTileY;
                }
                n3 = 0;
                if (n4 > 0) {
                    this.pDX = this.pSpeed;
                    if (this.pDX > n4) {
                        if (this.right && (this.level[this.pMoveToTileY][this.pMoveToTileX + 1][0] < 20 || this.level[this.pMoveToTileY][this.pMoveToTileX + 1][0] >= 40)) {
                            n3 = this.pDX - n4;
                        }
                        this.pDX = n4;
                    }
                } else if (n4 < 0) {
                    this.pDX = -this.pSpeed;
                    if (this.pDX < n4) {
                        if (this.left && (this.level[this.pMoveToTileY][this.pMoveToTileX - 1][0] < 20 || this.level[this.pMoveToTileY][this.pMoveToTileX - 1][0] >= 40)) {
                            n3 = this.pDX - n4;
                        }
                        this.pDX = n4;
                    }
                } else {
                    this.pDX = 0;
                }
                n2 = 0;
                if (n5 > 0) {
                    this.pDY = this.pSpeed;
                    if (this.pDY > n5) {
                        if (this.down && (this.level[this.pMoveToTileY + 1][this.pMoveToTileX][0] < 20 || this.level[this.pMoveToTileY + 1][this.pMoveToTileX][0] >= 40)) {
                            n2 = this.pDY - n5;
                        }
                        this.pDY = n5;
                    }
                } else if (n5 < 0) {
                    this.pDY = -this.pSpeed;
                    if (this.pDY < n5) {
                        if (this.up && (this.level[this.pMoveToTileY - 1][this.pMoveToTileX][0] < 20 || this.level[this.pMoveToTileY - 1][this.pMoveToTileX][0] >= 40)) {
                            n2 = this.pDY - n5;
                        }
                        this.pDY = n5;
                    }
                } else {
                    this.pDY = 0;
                }
                this.pXPos += this.pDX;
                this.pYPos += this.pDY;
                ++this.pFrame;
                if (this.pFrame == this.P_FRAMES[this.pMove]) {
                    this.pFrame = 0;
                }
                if (!this.pInTile && this.pXPos % this.tileWidth == 0 && this.pYPos % this.tileHeight == 0) {
                    if (this.level[this.pMoveToTileY][this.pMoveToTileX][0] >= 10 && this.level[this.pMoveToTileY][this.pMoveToTileX][0] < 20) {
                        this.level[this.pMoveToTileY][this.pMoveToTileX] = new int[]{0};
                        this.blankTile(this.pMoveToTileX * this.tileWidth, this.pMoveToTileY * this.tileHeight);
                    } else if (this.level[this.pMoveToTileY][this.pMoveToTileX][0] >= 40) {
                        if (this.level[this.pMoveToTileY][this.pMoveToTileX][0] < 45 && this.level[this.pMoveToTileY][this.pMoveToTileX][3] != 0) {
                            this.fallingObjects.removeElement(this.level[this.pMoveToTileY][this.pMoveToTileX]);
                        }
                        this.collect(this.pMoveToTileX, this.pMoveToTileY, this.level[this.pMoveToTileY][this.pMoveToTileX][0]);
                    }
                    if (this.pMoveToTileY - 1 >= 0 && this.level[this.pMoveToTileY - 1][this.pMoveToTileX][0] >= 40 && this.level[this.pMoveToTileY - 1][this.pMoveToTileX][0] < 45 && this.level[this.pMoveToTileY - 1][this.pMoveToTileX][3] == 0) {
                        for (n = this.pMoveToTileY - 1; n > 0 && this.level[n][this.pMoveToTileX][0] >= 30 && this.level[n][this.pMoveToTileX][0] < 45 && this.level[n][this.pMoveToTileX][3] == 0; --n) {
                            this.fallingObjects.addElement(this.level[n][this.pMoveToTileX]);
                            this.blankTile(this.pMoveToTileX * this.tileWidth, n * this.tileHeight);
                            this.level[n][this.pMoveToTileX][3] = 1;
                        }
                    }
                    for (n = this.pCurrentTileY - 1; n > 0 && this.level[n][this.pCurrentTileX][0] >= 30 && this.level[n][this.pCurrentTileX][0] < 45 && this.level[n][this.pCurrentTileX][3] == 0; --n) {
                        this.fallingObjects.addElement(this.level[n][this.pCurrentTileX]);
                        this.blankTile(this.pCurrentTileX * this.tileWidth, n * this.tileHeight);
                        this.level[n][this.pCurrentTileX][3] = 1;
                    }
                    this.pCurrentTileX = this.pXPos / this.tileWidth;
                    this.pCurrentTileY = this.pYPos / this.tileHeight;
                    this.pInTile = true;
                } else if (this.pInTile && (this.pXPos % this.tileWidth != 0 || this.pYPos % this.tileHeight != 0)) {
                    this.pInTile = false;
                }
                this.pXPos += n3;
                this.pYPos += n2;
                this.moveSpiders();
                for (n = 0; n < this.spiders.length; ++n) {
                    if (this.spiders[n] == null) continue;
                    int[] nArray = this.spiders[n];
                    nArray[7] = nArray[7] + 1;
                    if (this.spiders[n][7] != this.M_FRAMES[this.spiders[n][6]]) continue;
                    this.spiders[n][7] = 0;
                }
                ++this.fallingCounter;
                if (this.fallingCounter == 2) {
                    this.fallingCounter = 0;
                    this.checkDrop();
                }
                this.repaint();
                this.serviceRepaints();
                Thread.sleep(66L);
                if (this.won) {
                    this.stop();
                    BSCanvas.playSound(this.sounds[0]);
                    this.repaint();
                    Thread.sleep(1000L);
                    this.levelClear = true;
                    this.repaint();
                    Thread.sleep(3000L);
                    if (this.currentLevel == 11) {
                        this.runEndSequence();
                        continue;
                    }
                    this.blankScreen = true;
                    this.repaint();
                    this.serviceRepaints();
                    this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
                    continue;
                }
                if (!this.dead) continue;
                this.stop();
                --this.pLives;
                this.updateStatus = true;
                this.repaint();
                Thread.sleep(1000L);
                if (this.pLives == 0) {
                    this.gameover = true;
                    this.repaint();
                    Thread.sleep(3000L);
                    this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
                    continue;
                }
                this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void runEndSequence() {
        try {
            int n;
            this.gamecomplete = true;
            this.playerTalking = false;
            this.enemyTalking = false;
            this.endGems = new int[5][5];
            for (n = 0; n < this.endGems.length; ++n) {
                this.endGems[n][0] = 40 + n;
                this.endGems[n][1] = this.halfScreenWidth - this.halfTileWidth;
                this.endGems[n][2] = this.screenHeight + this.statusHeight - this.tileHeight * 2;
                this.endGems[n][3] = -2 + n;
                this.endGems[n][4] = -6;
            }
            this.endBaddy = new int[]{2, 0, this.screenWidth, this.screenHeight + this.statusHeight - this.tileHeight * 2, -6, 0};
            this.endString = null;
            this.pXPos = 0;
            this.pYPos = this.screenHeight + this.statusHeight - this.tileHeight * 2;
            this.pMove = 3;
            while (this.pXPos + this.halfTileWidth < this.halfScreenWidth) {
                this.repaint();
                Thread.sleep(66L);
                this.pXPos += 3;
                ++this.pFrame;
                if (this.pFrame != this.P_FRAMES[this.pMove]) continue;
                this.pFrame = 0;
            }
            this.endString = this.parseString(this.langT[5]);
            this.endStringFont = new Font[]{this.getFont(this.langA[5]), this.getFont(this.langA[6]), this.getFont(this.langA[7]), this.getFont(this.langA[8])};
            this.endStringCenterX = this.halfScreenWidth;
            this.endStringTop = this.pYPos - this.halfTileHeight - this.tileHeight - this.endStringFont[0].getHeight() * 3;
            this.playerTalking = true;
            this.pFrame = 1;
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[6]);
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[7]);
            this.repaint();
            Thread.sleep(3000L);
            this.endString = null;
            this.playerTalking = false;
            while (this.pXPos + this.tileWidth < this.endBaddy[2]) {
                this.endBaddy[2] = this.endBaddy[2] + this.endBaddy[4];
                this.endBaddy[1] = this.endBaddy[1] + 1;
                if (this.endBaddy[1] == this.enemyImages[this.endBaddy[0]].length) {
                    this.endBaddy[1] = 0;
                }
                this.repaint();
                Thread.sleep(66L);
            }
            this.endString = this.parseString(this.langT[8]);
            this.endStringTop = this.pYPos - this.halfTileHeight - this.tileHeight - this.endStringFont[0].getHeight();
            this.playerTalking = true;
            this.pMove = 1;
            this.pDX = -3;
            this.pDY = -6;
            do {
                this.endStringCenterX += this.pDX;
                this.endStringTop += this.pDY;
                this.pXPos += this.pDX;
                this.pYPos += this.pDY;
                ++this.pDY;
                ++this.pFrame;
                if (this.pFrame == this.P_FRAMES[this.pMove]) {
                    this.pFrame = 0;
                }
                for (n = 0; n < this.endGems.length; ++n) {
                    int[] nArray = this.endGems[n];
                    nArray[1] = nArray[1] + this.endGems[n][3];
                    int[] nArray2 = this.endGems[n];
                    nArray2[2] = nArray2[2] + this.endGems[n][4];
                    int[] nArray3 = this.endGems[n];
                    nArray3[4] = nArray3[4] + 1;
                }
                this.repaint();
                Thread.sleep(66L);
            } while (this.pYPos + this.tileHeight * 2 < this.screenHeight + this.statusHeight);
            this.endString = null;
            this.playerTalking = false;
            while (this.endBaddy[2] > this.endGems[0][1]) {
                this.endBaddy[2] = this.endBaddy[2] + this.endBaddy[4];
                this.endBaddy[1] = this.endBaddy[1] + 1;
                if (this.endBaddy[1] == this.enemyImages[this.endBaddy[0]].length) {
                    this.endBaddy[1] = 0;
                }
                this.repaint();
                Thread.sleep(66L);
            }
            this.endBaddy[0] = 3;
            this.endBaddy[4] = -this.endBaddy[4];
            while (this.endBaddy[2] < this.endGems[4][1]) {
                this.endBaddy[2] = this.endBaddy[2] + this.endBaddy[4];
                this.endBaddy[1] = this.endBaddy[1] + 1;
                if (this.endBaddy[1] == this.enemyImages[this.endBaddy[0]].length) {
                    this.endBaddy[1] = 0;
                }
                for (n = 0; n < this.endGems.length; ++n) {
                    if (this.endBaddy[2] <= this.endGems[n][1]) continue;
                    this.endGems[n][2] = -this.tileHeight;
                }
                this.repaint();
                Thread.sleep(66L);
            }
            this.endBaddy[0] = 2;
            this.endBaddy[1] = 1;
            this.endString = this.parseString(this.langT[9]);
            this.endStringCenterX = this.halfScreenWidth;
            this.endStringTop = this.endBaddy[3] - this.halfTileHeight - this.tileHeight - this.endStringFont[0].getHeight() * 3;
            this.enemyTalking = true;
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[10]);
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[11]);
            this.repaint();
            Thread.sleep(3000L);
            this.pMove = 3;
            this.pDX = 6;
            this.endString = this.parseString(this.langT[12]);
            this.playerTalking = true;
            this.enemyTalking = false;
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[13]);
            this.repaint();
            Thread.sleep(3000L);
            this.endString = this.parseString(this.langT[14]);
            this.endStringCenterX = this.pXPos + this.endStringFont[0].stringWidth(this.endString[0]) / 2;
            this.endBaddy[0] = 3;
            while (this.endStringCenterX - 10 - this.endStringFont[0].stringWidth(this.endString[0]) / 2 < this.screenWidth) {
                this.endStringCenterX += this.pDX;
                this.pXPos += this.pDX;
                ++this.pFrame;
                if (this.pFrame == this.P_FRAMES[this.pMove]) {
                    this.pFrame = 0;
                }
                this.endBaddy[2] = this.endBaddy[2] + this.endBaddy[4];
                this.endBaddy[1] = this.endBaddy[1] + 1;
                if (this.endBaddy[1] == this.enemyImages[this.endBaddy[0]].length) {
                    this.endBaddy[1] = 0;
                }
                this.repaint();
                Thread.sleep(66L);
            }
            Thread.sleep(1000L);
            this.endString = this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[15]))).append(",").append(this.langT[16]))));
            this.endStringFont = new Font[]{this.getFont(this.langA[15]), this.getFont(this.langA[16])};
            this.endStringCenterX = this.halfScreenWidth;
            this.endStringTop = this.halfScreenHeight - this.getFont(this.langA[15]).getHeight();
            this.repaint();
            Thread.sleep(3000L);
            this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void collect(int n, int n2, int n3) {
        if (n3 == 48) {
            for (int i = 0; i < this.teleporters.length; ++i) {
                if (n != this.teleporters[i][0] || n2 != this.teleporters[i][1]) continue;
                try {
                    int n4;
                    for (n4 = 0; n4 < 7; ++n4) {
                        switch (n4 % 4) {
                            case 0: {
                                this.pMove = 0;
                                break;
                            }
                            case 1: {
                                this.pMove = 3;
                                break;
                            }
                            case 2: {
                                this.pMove = 1;
                                break;
                            }
                            case 3: {
                                this.pMove = 2;
                            }
                        }
                        this.repaint();
                        Thread.sleep(100L);
                    }
                    this.pXPos = this.teleporters[i][2] * this.tileWidth;
                    this.pYPos = this.teleporters[i][3] * this.tileWidth;
                    this.pMoveToTileX = this.teleporters[i][2];
                    this.pMoveToTileY = this.teleporters[i][3];
                    for (n4 = 0; n4 < 7; ++n4) {
                        switch (n4 % 4) {
                            case 0: {
                                this.pMove = 0;
                                break;
                            }
                            case 1: {
                                this.pMove = 3;
                                break;
                            }
                            case 2: {
                                this.pMove = 1;
                                break;
                            }
                            case 3: {
                                this.pMove = 2;
                            }
                        }
                        this.repaint();
                        Thread.sleep(100L);
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        } else {
            this.blankTile(n * this.tileWidth, n2 * this.tileHeight);
            this.level[n2][n] = new int[]{0};
            if (n3 >= 40 && n3 < 45) {
                BSCanvas.playSound(this.sounds[2]);
                ++this.pDiamonds;
                this.score += 10 * (this.difficulty + 1);
                this.updateStatus = true;
                if (this.pDiamonds >= this.levelDiamonds) {
                    this.level[this.exitY][this.exitX] = new int[]{49};
                    this.drawToBackBuffers(this.exitX, this.exitY, 49);
                }
            } else if (n3 == 49) {
                this.won = true;
            }
        }
    }

    private void checkDrop() {
        if (this.fallingObjects.size() > 0) {
            int n = (this.pXPos + this.halfTileWidth) / this.tileWidth;
            int n2 = (this.pYPos + this.halfTileHeight) / this.tileHeight;
            for (int i = 0; i < this.fallingObjects.size(); ++i) {
                int n3;
                int[] nArray = (int[])this.fallingObjects.elementAt(i);
                boolean bl = false;
                boolean bl2 = false;
                for (n3 = 0; n3 < this.spiders.length; ++n3) {
                    if (this.spiders[n3] == null) continue;
                    int n4 = (this.spiders[n3][0] + this.halfTileWidth) / this.tileWidth;
                    int n5 = (this.spiders[n3][1] + this.halfTileHeight) / this.tileHeight;
                    if (n4 == nArray[1] - 1 && n5 == nArray[2]) {
                        bl = true;
                        continue;
                    }
                    if (n4 != nArray[1] + 1 || n5 != nArray[2]) continue;
                    bl2 = true;
                }
                if (this.level[nArray[2] + 1][nArray[1]][0] < 10) {
                    if (nArray[1] == n && nArray[2] == n2 || nArray[1] == n && nArray[2] + 1 == n2) {
                        this.fallingObjects.removeElementAt(i--);
                        if (nArray[0] >= 40) {
                            this.collect(nArray[1], nArray[2], nArray[0]);
                            continue;
                        }
                        this.level[nArray[2]][nArray[1]][3] = 0;
                        this.drawToBackBuffers(nArray[1], nArray[2], this.level[nArray[2]][nArray[1]][0]);
                        this.restartLevel();
                        continue;
                    }
                    for (n3 = 0; n3 < this.spiders.length; ++n3) {
                        if (this.spiders[n3] == null || nArray[1] != (this.spiders[n3][0] + this.halfTileWidth) / this.tileWidth || nArray[2] + 1 != (this.spiders[n3][1] + this.halfTileHeight) / this.tileHeight) continue;
                        this.spiders[n3] = null;
                        this.score += 20 * (this.difficulty + 1);
                        this.updateStatus = true;
                        break;
                    }
                    this.level[nArray[2] + 1][nArray[1]] = this.level[nArray[2]][nArray[1]];
                    this.level[nArray[2]][nArray[1]] = new int[]{0};
                    nArray[2] = nArray[2] + 1;
                    continue;
                }
                if (!(this.level[nArray[2] + 1][nArray[1]][0] < 30 || this.level[nArray[2] + 1][nArray[1]][0] >= 45 || this.level[nArray[2] + 1][nArray[1]][3] != 0 || n == nArray[1] + 1 && n2 == nArray[2] || this.level[nArray[2]][nArray[1] + 1][0] >= 10 || this.level[nArray[2] + 1][nArray[1] + 1][0] >= 10 || bl2)) {
                    this.level[nArray[2]][nArray[1] + 1] = this.level[nArray[2]][nArray[1]];
                    this.level[nArray[2]][nArray[1]] = new int[]{0};
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                if (!(this.level[nArray[2] + 1][nArray[1]][0] < 30 || this.level[nArray[2] + 1][nArray[1]][0] >= 45 || this.level[nArray[2] + 1][nArray[1]][3] != 0 || n == nArray[1] - 1 && n2 == nArray[2] || this.level[nArray[2]][nArray[1] - 1][0] >= 10 || this.level[nArray[2] + 1][nArray[1] - 1][0] >= 10 || bl)) {
                    this.level[nArray[2]][nArray[1] - 1] = this.level[nArray[2]][nArray[1]];
                    this.level[nArray[2]][nArray[1]] = new int[]{0};
                    nArray[1] = nArray[1] - 1;
                    continue;
                }
                if (this.level[nArray[2] + 1][nArray[1]][0] >= 30 && this.level[nArray[2] + 1][nArray[1]][0] < 45 && this.level[nArray[2] + 1][nArray[1]][3] != 0) continue;
                BSCanvas.vibrate(50, 100);
                this.fallingObjects.removeElementAt(i--);
                this.level[nArray[2]][nArray[1]][3] = 0;
                this.drawToBackBuffers(nArray[1], nArray[2], this.level[nArray[2]][nArray[1]][0]);
            }
        }
    }

    public void keyPressed(int n) {
        if (!(this.won || this.dead || this.start)) {
            this.keyPressed = true;
            int n2 = this.getGameAction(n);
            if (n == -7) {
                this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
            } else {
                block0 : switch (n2) {
                    case 1: {
                        this.up = true;
                        break;
                    }
                    case 6: {
                        this.down = true;
                        break;
                    }
                    case 2: {
                        this.left = true;
                        break;
                    }
                    case 5: {
                        this.right = true;
                        break;
                    }
                    default: {
                        switch (n) {
                            case 50: {
                                this.up = true;
                                break block0;
                            }
                            case 56: {
                                this.down = true;
                                break block0;
                            }
                            case 52: {
                                this.left = true;
                                break block0;
                            }
                            case 54: {
                                this.right = true;
                            }
                        }
                    }
                }
            }
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 1: {
                this.up = false;
                break;
            }
            case 6: {
                this.down = false;
                break;
            }
            case 2: {
                this.left = false;
                break;
            }
            case 5: {
                this.right = false;
                break;
            }
            default: {
                switch (n) {
                    case 50: {
                        this.up = false;
                        break block0;
                    }
                    case 56: {
                        this.down = false;
                        break block0;
                    }
                    case 52: {
                        this.left = false;
                        break block0;
                    }
                    case 54: {
                        this.right = false;
                    }
                }
            }
        }
    }

    public String[] parseString(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') continue;
            ++n;
        }
        String[] stringArray = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string.substring(0, string.indexOf(44));
            string = string.substring(string.indexOf(44) + 1);
        }
        stringArray[n] = string;
        return stringArray;
    }

    public void drawText(Graphics graphics, String[] stringArray, Font font, boolean bl, int n, int n2) {
        Font[] fontArray = new Font[stringArray.length];
        for (int i = 0; i < fontArray.length; ++i) {
            fontArray[i] = font;
        }
        this.drawText(graphics, stringArray, fontArray, bl, n, n2);
    }

    private void drawText(Graphics graphics, String[] stringArray, Font[] fontArray, boolean bl, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n5 = Math.max(fontArray[n3].stringWidth(stringArray[n3]), n5);
            n7 += fontArray[n3].getHeight();
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n - n5 / 2 - 2, n2 - 2, n5 + 2, n7 + 2);
        graphics.setColor(0);
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n4 = fontArray[n3].stringWidth(stringArray[n3]);
            graphics.setFont(fontArray[n3]);
            graphics.drawString(stringArray[n3], n, n2 + n6, 17);
            n6 += fontArray[n3].getHeight();
        }
        if (bl) {
            graphics.drawRect(n - n5 / 2 - 2, n2 - 2, n5 + 2, n7 + 2);
        }
    }
}

