/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ACCanvas
extends Canvas
implements CommandListener {
    ACLogo oACLogo;
    ACBoard oACBoard;
    ACView oACView;
    private int[][] board;
    Calendar c;
    int minutes;
    int seconds;
    int hours;
    int stMin;
    int stSec;
    int stHour;
    int endMin;
    int endSec;
    int endHour;
    Command cmdBack;
    Command cmdReset;
    public int w;
    public int h;
    public int chSize;
    public int chRemain;
    public int maxGate;
    public int gameIndex;
    public int gameKind;
    public int left;
    public int top;
    public int markedX;
    public int markedY;
    public int pX;
    public int pY;
    Image backImg;
    Image[] chessImg;

    public ACCanvas(ACLogo aCLogo) {
        this.oACLogo = aCLogo;
        this.oACBoard = new ACBoard();
        this.initSelf();
    }

    private void initSelf() {
        this.board = new int[7][7];
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.chSize = 15;
        this.gameIndex = 0;
        this.gameKind = -1;
        this.left = 10;
        this.top = 15;
        this.minutes = 0;
        this.seconds = 0;
        this.pX = 0;
        this.pY = 0;
        this.cmdBack = new Command("\u9000\u51fa", 2, 1);
        this.cmdReset = new Command("\u91cd\u6765", 4, 0);
        this.addCommand(this.cmdReset);
        this.addCommand(this.cmdBack);
        this.setCommandListener(this);
        try {
            this.backImg = Image.createImage((String)"/back.png");
            this.chessImg = new Image[2];
            int n = 0;
            while (n < this.chessImg.length) {
                this.chessImg[n] = Image.createImage((String)("/chess" + n + ".png"));
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("load canvasImage error");
        }
    }

    public void start(int n) {
        switch (n) {
            case 0: {
                this.maxGate = 6;
                this.gameIndex = 1;
                this.gameKind = 0;
                break;
            }
            case 1: {
                this.maxGate = 5;
                this.gameIndex = 7;
                this.gameKind = 1;
                break;
            }
            case 2: {
                this.maxGate = 4;
                this.gameIndex = 12;
                this.gameKind = 2;
            }
        }
        --this.maxGate;
        this.play(this.gameIndex);
        this.oACLogo.display.setCurrent((Displayable)this);
        this.initStartTime();
    }

    private void play(int n) {
        this.board = this.oACBoard.loadBoard(n);
        this.chRemain = this.getRemain();
        this.markedX = -1;
        this.markedY = -1;
        this.repaint();
    }

    private int getRemain() {
        int n = 0;
        int n2 = 0;
        while (n2 < 7) {
            int n3 = 0;
            while (n3 < 7) {
                if (this.board[n2][n3] == 1) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public void initStartTime() {
        this.c = Calendar.getInstance();
        this.stHour = this.c.get(11);
        this.stMin = this.c.get(12);
        this.stSec = this.c.get(13);
    }

    public void getAllTime() {
        this.c = Calendar.getInstance();
        this.endHour = this.c.get(11);
        this.endMin = this.c.get(12);
        this.endSec = this.c.get(13);
        this.seconds = this.endSec - this.stSec;
        if (this.seconds < 0) {
            this.seconds += 60;
            --this.minutes;
        }
        this.minutes = this.endMin - this.stMin;
        if (this.minutes < 0) {
            this.minutes += 60;
            --this.endHour;
        }
        this.hours = this.endHour - this.stHour;
        if (this.hours < 0) {
            this.hours += 24;
        }
    }

    public void paint(Graphics graphics) {
        if (this.chRemain == 1) {
            if (this.maxGate - 1 < 0) {
                this.getAllTime();
                if (this.oACView != null) {
                    this.oACView = null;
                }
                this.oACView = new ACView(this.oACLogo, this.hours, this.minutes, this.seconds, this.gameKind);
                this.oACView.start();
            } else {
                --this.maxGate;
                ++this.gameIndex;
                this.play(this.gameIndex);
            }
        }
        this.drawBack(graphics);
        this.drawBoard(graphics);
        this.drawPoint(graphics);
    }

    private void drawPoint(Graphics graphics) {
        graphics.setColor(0, 255, 100);
        graphics.drawRect(this.left + this.pX * this.chSize, this.top + this.pY * this.chSize, this.chSize, this.chSize);
    }

    private void drawBack(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.w, this.h);
        graphics.setColor(0);
        graphics.drawImage(this.backImg, 0, 0, 20);
        graphics.fillRoundRect(12, 244, 87, 32, 5, 5);
        graphics.fillRoundRect(128, 244, 87, 32, 5, 5);
        graphics.setColor(0xFFFFFF);
        graphics.fillRoundRect(16, 248, 78, 25, 5, 5);
        graphics.fillRoundRect(132, 248, 78, 25, 5, 5);
    }

    private void drawBoard(Graphics graphics) {
        graphics.setColor(0);
        int n = 0;
        while (n < 7) {
            int n2 = 0;
            while (n2 < 7) {
                if (this.board[n][n2] == 1) {
                    graphics.drawImage(this.chessImg[0], n * this.chSize + this.left + 2, n2 * this.chSize + this.top + 2, 20);
                } else if (this.board[n][n2] == 0) {
                    graphics.setColor(255, 255, 255);
                    graphics.drawArc(n * this.chSize + this.left, n2 * this.chSize + this.top, this.chSize, this.chSize, 0, 720);
                } else if (this.board[n][n2] == 2) {
                    graphics.drawImage(this.chessImg[1], n * this.chSize + this.left + 2, n2 * this.chSize + this.top + 2, 20);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void keyPressed(int n) {
        switch (this.getGameAction(n)) {
            default: {
                break;
            }
            case 1: {
                if (--this.pY < 0) {
                    this.pY = 6;
                }
                this.repaint();
                break;
            }
            case 6: {
                if (++this.pY > 6) {
                    this.pY = 0;
                }
                this.repaint();
                break;
            }
            case 5: {
                if (++this.pX > 6) {
                    this.pX = 0;
                }
                this.repaint();
                break;
            }
            case 2: {
                if (--this.pX < 0) {
                    this.pX = 6;
                }
                this.repaint();
                break;
            }
            case 8: {
                this.doClick(this.pX, this.pY);
            }
        }
    }

    private void doClick(int n, int n2) {
        if (n == 0 && (n2 == 0 || n2 == 1 || n2 == 5 || n2 == 6) || n == 1 && (n2 == 0 || n2 == 6) || n == 5 && (n2 == 0 || n2 == 6) || n == 6 && (n2 == 0 || n2 == 1 || n2 == 5 || n2 == 6)) {
            System.out.println("undo");
        } else {
            switch (this.board[n][n2]) {
                default: {
                    break;
                }
                case 0: {
                    if (this.markedX == -1 || this.markedY == -1 || this.move(n, n2)) break;
                    this.undo(this.markedX, this.markedY);
                    break;
                }
                case 1: {
                    if (this.markedX != -1 && this.markedY != -1) {
                        this.undo(this.markedX, this.markedY);
                        break;
                    }
                    if (this.board[n][n2] != 1) break;
                    this.board[n][n2] = 2;
                    this.markedX = n;
                    this.markedY = n2;
                    this.repaint(n * this.chSize + this.left, n2 * this.chSize + this.top, this.chSize, this.chSize);
                    this.serviceRepaints();
                    break;
                }
                case 2: {
                    if (this.markedX == -1 || this.markedY == -1) break;
                    this.undo(this.markedX, this.markedY);
                }
            }
        }
    }

    private boolean move(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 3 * this.chSize;
        int n6 = 3 * this.chSize;
        int n7 = -1;
        int n8 = -1;
        if (n == this.markedX) {
            if (Math.abs(n2 - this.markedY) == 2 && this.board[n7 = n][n8 = (n2 + this.markedY) / 2] == 1) {
                bl = true;
            }
        } else if (n2 == this.markedY && Math.abs(n - this.markedX) == 2 && this.board[n7 = (n + this.markedX) / 2][n8 = n2] == 1) {
            bl = true;
        }
        if (bl) {
            if (n < this.markedX) {
                n3 = n;
                n4 = n2;
                n6 = this.chSize;
            } else if (n == this.markedX) {
                n3 = n;
                n5 = this.chSize;
                n4 = n2 <= this.markedY ? n2 : this.markedY;
            } else if (n > this.markedX) {
                n3 = this.markedX;
                n4 = n2;
                n6 = this.chSize;
            }
            this.board[n7][n8] = 0;
            this.board[this.markedX][this.markedY] = 0;
            this.board[n][n2] = 1;
            this.markedX = -1;
            this.markedY = -1;
            --this.chRemain;
            this.repaint(n3 * this.chSize + this.left, n4 * this.chSize + this.top, n5, n6);
            this.serviceRepaints();
        }
        return bl;
    }

    private void undo(int n, int n2) {
        if (this.board[n][n2] == 2) {
            this.board[n][n2] = 1;
            this.markedX = -1;
            this.markedY = -1;
        }
        this.repaint(n * this.chSize + this.left, n2 * this.chSize + this.top, this.chSize, this.chSize);
        this.serviceRepaints();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdBack) {
            AloneChess.singletone.startApp();
            this.oACLogo.start(this, 0);
        } else if (command == this.cmdReset) {
            this.board = this.oACBoard.loadBoard(this.gameIndex);
            this.chRemain = this.getRemain();
            this.markedX = -1;
            this.markedY = -1;
            this.repaint();
            this.serviceRepaints();
        }
    }
}

