/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class ACRms {
    private String rmsName;
    private int orderBy;
    private int nameIndex;
    private int scoreIndex;
    private int maxLength;
    private int insertIndex;
    public int maxRecords;
    public String[] names;
    public String[] scores;
    public RecordStore rs;
    public RecordEnumeration re;

    public ACRms() {
        this("default", 5, 0);
    }

    public ACRms(String string) {
        this(string, 5, 0);
    }

    public ACRms(String string, int n) {
        this(string, n, 0);
    }

    public ACRms(String string, int n, int n2) {
        this.rmsName = string;
        this.maxRecords = n;
        this.orderBy = n2;
        try {
            this.rs = null;
            this.rs = RecordStore.openRecordStore((String)this.rmsName, (boolean)true);
            this.names = new String[this.maxRecords];
            this.scores = new String[this.maxRecords];
            if (this.rs.getNumRecords() > 0) {
                this.getRecordList();
            } else {
                this.setRecordList();
            }
            this.rs.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("Rms create error: " + exception.getMessage());
        }
    }

    private void setRecordList() {
        switch (this.orderBy) {
            case 0: {
                this.initLow();
                break;
            }
            case 1: {
                this.initHigh();
            }
        }
    }

    private void initLow() {
        int n = 0;
        while (n < this.maxRecords) {
            this.names[n] = "\u65e0\u540d\u82f1\u96c4";
            this.scores[n] = "0";
            this.saveScore(this.names[n], this.scores[n]);
            ++n;
        }
    }

    private void initHigh() {
        int n = 0;
        while (n < this.maxRecords) {
            this.names[n] = "\u65e0\u540d\u82f1\u96c4";
            this.scores[n] = "6000";
            this.saveScore(this.names[n], this.scores[n]);
            ++n;
        }
    }

    private void saveScore(String string, String string2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeUTF(string2);
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.rs.addRecord(byArray, 0, byArray.length);
            byteArrayOutputStream.reset();
        }
        catch (Exception exception) {
            System.out.println("saveScore error: " + exception.getMessage());
        }
    }

    private void getRecordList() {
        int n = 0;
        if (this.rs != null) {
            try {
                n = 0;
                while (n < this.maxRecords) {
                    byte[] byArray = this.rs.getRecord(n + 1);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    this.names[n] = dataInputStream.readUTF();
                    this.scores[n] = dataInputStream.readUTF();
                    System.out.println("score integer = " + Integer.parseInt(this.scores[n]));
                    ++n;
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public boolean isHighScore(int n) {
        try {
            int n2 = 0;
            while (n2 < this.maxRecords) {
                if (n > Integer.parseInt(this.scores[n2])) {
                    this.insertIndex = n2;
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("isHighScore error: orderBy " + this.orderBy + " score " + n);
        }
        return false;
    }

    public boolean isLowScore(int n) {
        System.out.println("test is loe score now !");
        System.out.println("load score " + n);
        try {
            int n2 = 0;
            while (n2 < this.maxRecords) {
                System.out.println("test is low score record score = " + Integer.parseInt(this.scores[n2]));
                if (n <= Integer.parseInt(this.scores[n2])) {
                    this.insertIndex = n2;
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("isLowScore error: orderBy " + this.orderBy + " score " + n);
        }
        return false;
    }

    public void addHighScore(String string, String string2) {
        try {
            if (this.insertIndex != -1) {
                int n = this.maxRecords - 1;
                while (n > this.insertIndex) {
                    this.names[n] = this.names[n - 1];
                    this.scores[n] = this.scores[n - 1];
                    --n;
                }
                this.names[this.insertIndex] = string;
                this.scores[this.insertIndex] = string2;
                this.saveScoreList();
            }
        }
        catch (Exception exception) {
            System.out.println("addHightScore error: " + exception.getMessage());
        }
    }

    public void addLowScore(String string, String string2) {
        this.addHighScore(string, string2);
    }

    private void saveScoreList() {
        try {
            RecordStore.deleteRecordStore((String)this.rmsName);
            this.rs = RecordStore.openRecordStore((String)this.rmsName, (boolean)true);
            int n = 0;
            while (n < 5) {
                this.saveScore(this.names[n], this.scores[n]);
                ++n;
            }
            this.rs.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("saveScore= " + exception.getMessage());
        }
    }

    private void deleteScoreList() {
        try {
            int n = 1;
            while (n < this.rs.getNumRecords()) {
                this.rs.deleteRecord(n);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("deleteScore error" + exception.getMessage());
        }
    }
}

