/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.gambling.bigsmallcard;

import com.ixisoft.games.gambling.bigsmallcard.BigSmallCard;
import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardData;
import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardMainCanvas;
import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardModel;
import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardTitleCanvas;
import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardView;
import com.ixisoft.games.util.GameController;
import com.ixisoft.games.util.GameView;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;

public class BigSmallCardController
extends GameController
implements CommandListener {
    private Command exitCommand;
    private Command newCommand;
    private Command helpCommand;
    private Command contCommand;
    private Command startCommand;
    private Command helpReturnCommand;
    private Command aboutReturnCommand;
    private Command mainReturnCommand;
    private Command aboutCommand;
    private Command nextCommand;
    private Command prevCommand;
    private BigSmallCardView hcView = null;
    private BigSmallCardModel hcModel = new BigSmallCardModel();
    public static final int BIG_PRESSED = 0;
    public static final int SMALL_PRESSED = 1;
    public static final int NEXT_PRESSED = 2;

    public BigSmallCardController() {
        this.exitCommand = new Command("Quit", 1, 2);
        this.helpCommand = new Command("Help", 1, 4);
        this.startCommand = new Command("Start", 1, 1);
        this.newCommand = new Command("New Game", 1, 3);
        this.contCommand = new Command("Continue", 1, 1);
        this.aboutCommand = new Command("About", 1, 5);
        this.helpReturnCommand = new Command("Return", 1, 4);
        this.aboutReturnCommand = new Command("Return", 1, 4);
        this.mainReturnCommand = new Command("Return", 1, 1);
        this.nextCommand = new Command("Next", 1, 2);
        this.prevCommand = new Command("Prev", 1, 3);
    }

    public void addObserver(GameView hcview) {
        this.hcView = (BigSmallCardView)hcview;
        this.hcModel.addObserver(this.hcView);
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.helpReturnCommand || c == this.aboutReturnCommand) {
            this.hcModel.helpReturnPressed();
            return;
        }
        if (c == this.nextCommand) {
            this.hcView.nextPressed(s);
            return;
        }
        if (c == this.prevCommand) {
            this.hcView.prevPressed(s);
            return;
        }
        if (c == this.mainReturnCommand) {
            this.hcModel.mainReturnPressed();
            return;
        }
        if (c == this.exitCommand) {
            this.hcModel.saveScore();
            BigSmallCard.getInstance().destroyApp(false);
            BigSmallCard.getInstance().notifyDestroyed();
        } else if (c == this.helpCommand) {
            this.hcModel.helpPressed();
        } else if (c == this.newCommand || c == this.startCommand) {
            this.hcModel.reset();
            if (c == this.startCommand) {
                this.hcView.getTitleScreen().removeCommand(this.startCommand);
                this.hcView.getTitleScreen().addCommand(this.contCommand);
                this.hcView.getTitleScreen().addCommand(this.newCommand);
            }
            this.hcModel.startGame();
        } else if (c == this.aboutCommand) {
            this.hcModel.aboutPressed();
        } else if (c == this.contCommand) {
            this.hcModel.startGame();
        }
    }

    public void pressedReceived(int command) {
        if (command == 2) {
            this.hcModel.newGame();
            return;
        }
        if (command == 0) {
            this.hcModel.nextCard(BigSmallCardData.UP);
        } else if (command == 1) {
            this.hcModel.nextCard(BigSmallCardData.DOWN);
        }
    }

    public void setAboutScreenCommands(Form screen, int idx) {
        if (idx < this.hcView.getMaxAboutPages() - 1) {
            screen.addCommand(this.nextCommand);
        }
        if (idx > 0) {
            screen.addCommand(this.prevCommand);
        }
        screen.addCommand(this.aboutReturnCommand);
        screen.setCommandListener((CommandListener)this);
    }

    public void setHelpScreenCommands(Form screen, int idx) {
        if (idx < this.hcView.getMaxHelpPages() - 1) {
            screen.addCommand(this.nextCommand);
        }
        if (idx > 0) {
            screen.addCommand(this.prevCommand);
        }
        screen.addCommand(this.helpReturnCommand);
        screen.setCommandListener((CommandListener)this);
    }

    public void setMainScreenCommands(BigSmallCardMainCanvas screen) {
        screen.addCommand(this.mainReturnCommand);
        screen.addCommand(this.exitCommand);
        screen.addCommand(this.helpCommand);
        screen.addCommand(this.aboutCommand);
        screen.setCommandListener(this);
    }

    public void setTitleScreenCommands(BigSmallCardTitleCanvas screen) {
        if (!this.hcModel.isNewCreate()) {
            screen.addCommand(this.contCommand);
            screen.addCommand(this.newCommand);
        } else {
            screen.addCommand(this.startCommand);
        }
        screen.addCommand(this.exitCommand);
        screen.addCommand(this.helpCommand);
        screen.addCommand(this.aboutCommand);
        screen.setCommandListener(this);
    }
}

