/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.gambling.bigsmallcard;

import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardController;
import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardData;
import com.ixisoft.games.gambling.card.Card;
import com.ixisoft.games.gambling.card.CardGraphics;
import com.ixisoft.games.util.GameModel;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BigSmallCardMainCanvas
extends Canvas {
    private Font smallFont = Font.getFont((int)64, (int)0, (int)8);
    private Font bigFont = Font.getFont((int)64, (int)0, (int)0);
    private static final int TITLE_Y_OFFSET = 0;
    private static final int TITLE_X_OFFSET = 3;
    private static final int CARDSCREEN_X_OFFSET = 4;
    private static final int CARDSCREEN_Y_OFFSET = 28;
    private static final int CARD_SPACE_PIXEL = 7;
    private static final int CARD_WIDTH = 20;
    private static final int CARD_HEIGHT = 31;
    private static final int TOP_SCORE_TITLE_Y_OFFSET = 26;
    private static final int TOP_SCORE_TITLE_X_OFFSET = 143;
    private static final int TOP_SCORE_TITLE_ANCHOR = 20;
    private static final int TOP_SCORE_Y_OFFSET = 51;
    private static final int TOP_SCORE_ANCHOR = 24;
    private static final int SCORE_TITLE_Y_OFFSET = 76;
    private static final int SCORE_TITLE_X_OFFSET = 143;
    private static final int SCORE_TITLE_ANCHOR = 20;
    private static final int SCORE_Y_OFFSET = 101;
    private static final int SCORE_ANCHOR = 24;
    private static final int RESULT_STRING_TITLE_Y_OFFSET = 126;
    private static final int RESULT_STRING_TITLE_X_OFFSET = 143;
    private static final int RESULT_STRING_TITLE_ANCHOR = 20;
    private static final int RESULT_STRING_Y_OFFSET = 151;
    private static final int RESULT_STRING_X_OFFSET = 143;
    private static final int RESULT_STRING_ANCHOR = 20;
    private static final int NEXT_RECT_X = 40;
    private static final int NEXT_RECT_Y = 181;
    private static final int NEXT_RECT_WIDTH = 160;
    private static final int NEXT_RECT_HEIGHT = 50;
    private static final int BIG_RECT_X = 20;
    private static final int BIG_RECT_Y = 181;
    private static final int BIG_RECT_WIDTH = 90;
    private static final int BIG_RECT_HEIGHT = 50;
    private static final int SMALL_RECT_X = 130;
    private static final int SMALL_RECT_Y = 181;
    private static final int SMALL_RECT_WIDTH = 90;
    private static final int SMALL_RECT_HEIGHT = 50;
    int width;
    int height;
    BigSmallCardData hcData = null;
    BigSmallCardController hcControl = null;
    Image offImage = null;

    public BigSmallCardMainCanvas(BigSmallCardController c) {
        CardGraphics.loadCardImages();
        this.hcControl = c;
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    void clearGraphics(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.width + 1, this.height + 1);
    }

    private void drawBackGround(Graphics g) {
        int oldColor = g.getColor();
        g.setColor(0, 0, 0);
        g.drawLine(0, 25, this.getWidth(), 25);
        g.drawLine(141, 25, 141, 175);
        g.drawLine(141, 75, this.getWidth(), 75);
        g.drawLine(141, 125, this.getWidth(), 125);
        g.drawLine(0, 175, this.getWidth(), 175);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        g.setColor(oldColor);
    }

    private void drawButtonScreen(Graphics g) {
        if (this.hcData == null) {
            return;
        }
        int temp = g.getColor();
        Font oldFont = g.getFont();
        g.setFont(this.smallFont);
        if (this.hcData.isFinish()) {
            g.setColor(0, 0, 0);
            g.drawRect(40, 181, 160, 50);
            if (this.hcData.isStart()) {
                g.drawString("New Hand", 120, 216, 65);
            } else {
                g.drawString("Next Hand", 120, 216, 65);
            }
        } else {
            g.setColor(0, 0, 0);
            g.drawRect(20, 181, 90, 50);
            g.drawString("BIG", 65, 216, 65);
            g.drawRect(130, 181, 90, 50);
            g.drawString("SMALL", 175, 216, 65);
        }
        g.setColor(temp);
        g.setFont(oldFont);
    }

    private void drawCard(Graphics g, int i, Card aCard) {
        if (aCard == null) {
            g.drawImage(CardGraphics.getBlank25x31Image(), this.getCardXLoc(i), this.getCardYLoc(i), 20);
            return;
        }
        g.drawImage(CardGraphics.getOutline25x31Image(), this.getCardXLoc(i), this.getCardYLoc(i), 20);
        g.drawImage(CardGraphics.getKindImage(aCard.getKind()), this.getCardXLoc(i) + 5, this.getCardYLoc(i) + 14, 20);
        g.drawImage(CardGraphics.getNumberImage(aCard.getNumber()), this.getCardXLoc(i) + 2, this.getCardYLoc(i) + 2, 20);
    }

    private void drawCardPointer(Graphics g) {
        int oldColor = g.getColor();
        g.setColor(0, 0, 0);
        int currentCardNo = this.hcData.getCurrentCardNo();
        g.fillArc(this.getCardXLoc(currentCardNo) + 10 - 2, this.getCardYLoc(currentCardNo) + 31 + 5, 6, 6, 0, 360);
        g.setColor(oldColor);
    }

    private void drawCardScreen(Graphics g) {
        Card currentCard;
        if (this.hcData == null) {
            return;
        }
        int currentCardNo = this.hcData.getCurrentCardNo();
        if (currentCardNo < 1) {
            this.drawCard(g, 1, null);
        } else {
            this.drawCard(g, 1, this.hcData.getCard(1));
        }
        int i = 2;
        while (i < currentCardNo) {
            currentCard = this.hcData.getCard(i);
            this.drawCard(g, i, currentCard);
            ++i;
        }
        if (this.hcData.isFinish()) {
            currentCard = this.hcData.getCard(currentCardNo);
            this.drawCard(g, currentCardNo, currentCard);
        } else {
            this.drawCard(g, currentCardNo, null);
        }
        int i2 = currentCardNo + 1;
        while (i2 <= BigSmallCardData.MAX_CARD_NO) {
            this.drawCard(g, i2, null);
            ++i2;
        }
    }

    private void drawResult(Graphics g) {
        int temp = g.getColor();
        g.setColor(0, 0, 0);
        Font oldFont = g.getFont();
        g.setFont(this.smallFont);
        if (this.hcData.isShuffling()) {
            g.drawString("Shuffling !!", this.getResultTitleXLoc(), this.getResultTitleYLoc(), this.getResultAnchor());
            return;
        }
        int currentCardNo = this.hcData.getCurrentCardNo();
        if (!this.hcData.isFinish()) {
            if (currentCardNo > 2) {
                if (currentCardNo == 6) {
                    g.drawString("Level 2 !!", this.getResultTitleXLoc(), this.getResultTitleYLoc(), this.getResultTitleAnchor());
                } else if (currentCardNo == 10) {
                    g.drawString("Level 3 !!", this.getResultTitleXLoc(), this.getResultTitleYLoc(), this.getResultTitleAnchor());
                } else {
                    g.drawString("Correct !!", this.getResultTitleXLoc(), this.getResultTitleYLoc(), this.getResultTitleAnchor());
                }
                StringBuffer currentPoint = new StringBuffer("pts: ");
                currentPoint.append(this.hcData.getCurrentPoint());
                g.drawString(currentPoint.toString(), this.getResultXLoc(), this.getResultYLoc(), this.getResultAnchor());
            } else {
                g.drawString("Good Luck!!", this.getResultTitleXLoc(), this.getResultTitleYLoc(), this.getResultTitleAnchor());
            }
        } else if (this.hcData.getCurrentCardNo() != 1) {
            if (this.hcData.isPlayerWin()) {
                g.drawString("Clear all !!", this.getResultTitleXLoc(), this.getResultTitleYLoc(), this.getResultTitleAnchor());
                StringBuffer currentPoint = new StringBuffer("pts: ");
                currentPoint.append(this.hcData.getCurrentPoint());
                g.drawString(currentPoint.toString(), this.getResultXLoc(), this.getResultYLoc(), this.getResultAnchor());
            } else {
                g.drawString("You Lose!!", this.getResultTitleXLoc(), this.getResultTitleYLoc(), this.getResultTitleAnchor());
                StringBuffer currentPoint = new StringBuffer("pts: ");
                currentPoint.append(this.hcData.getCurrentPoint());
                g.drawString(currentPoint.toString(), this.getResultXLoc(), this.getResultYLoc(), this.getResultAnchor());
            }
        }
        g.setFont(oldFont);
        g.setColor(temp);
    }

    private void drawScore(Graphics g) {
        if (this.hcData == null) {
            return;
        }
        int oldColor = g.getColor();
        g.setColor(0, 0, 0);
        Font oldFont = g.getFont();
        g.setFont(this.smallFont);
        StringBuffer score = new StringBuffer();
        score.append(this.hcData.getScore());
        g.drawString("Your points:", this.getScoreTitleXLoc(), this.getScoreTitleYLoc(), this.getScoreTitleAnchor());
        g.drawString(score.toString(), this.getScoreXLoc(), this.getScoreYLoc(), this.getScoreAnchor());
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    private void drawTitle(Graphics g) {
        Font oldFont = g.getFont();
        int oldColor = g.getColor();
        g.setColor(0, 0, 0);
        g.setFont(this.bigFont);
        g.drawString("Big Small Card", this.getTitleXLoc(), this.getTitleYLoc(), 20);
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    private void drawTopScore(Graphics g) {
        if (this.hcData == null) {
            return;
        }
        int oldColor = g.getColor();
        g.setColor(0, 0, 0);
        Font oldFont = g.getFont();
        g.setFont(this.smallFont);
        StringBuffer topScore = new StringBuffer();
        topScore.append(this.hcData.getTopScore());
        g.drawString("Top points:", this.getTopScoreTitleXLoc(), this.getTopScoreTitleYLoc(), this.getTopScoreTitleAnchor());
        g.drawString(topScore.toString(), this.getTopScoreXLoc(), this.getTopScoreYLoc(), this.getTopScoreAnchor());
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    int getCardXLoc(int i) {
        int currentCardNo = this.hcData.getCurrentCardNo();
        int level2StartCardNo = currentCardNo >= 6 ? 5 : 6;
        int level3StartCardNo = currentCardNo >= 10 ? 9 : 10;
        if (i < level2StartCardNo) {
            return (i - 1) * 27 + 4;
        }
        if (i < level3StartCardNo) {
            return (i -= 5) * 27 + 4;
        }
        return (i -= 9) * 27 + 4;
    }

    int getCardYLoc(int i) {
        int currentCardNo = this.hcData.getCurrentCardNo();
        int level2StartCardNo = currentCardNo >= 6 ? 5 : 6;
        int level3StartCardNo = currentCardNo >= 10 ? 9 : 10;
        if (i < level2StartCardNo) {
            return 128;
        }
        if (i < level3StartCardNo) {
            return 78;
        }
        return 28;
    }

    int getResultAnchor() {
        return 20;
    }

    int getResultTitleAnchor() {
        return 20;
    }

    int getResultTitleXLoc() {
        return 143;
    }

    int getResultTitleYLoc() {
        return 126;
    }

    int getResultXLoc() {
        return 143;
    }

    int getResultYLoc() {
        return 151;
    }

    int getScoreAnchor() {
        return 24;
    }

    int getScoreTitleAnchor() {
        return 20;
    }

    int getScoreTitleXLoc() {
        return 143;
    }

    int getScoreTitleYLoc() {
        return 76;
    }

    int getScoreXLoc() {
        return this.getWidth() - 1;
    }

    int getScoreYLoc() {
        return 101;
    }

    int getTitleXLoc() {
        return 3;
    }

    int getTitleYLoc() {
        return 0;
    }

    int getTopScoreAnchor() {
        return 24;
    }

    int getTopScoreTitleAnchor() {
        return 20;
    }

    int getTopScoreTitleXLoc() {
        return 143;
    }

    int getTopScoreTitleYLoc() {
        return 26;
    }

    int getTopScoreXLoc() {
        return this.getWidth() - 1;
    }

    int getTopScoreYLoc() {
        return 51;
    }

    private boolean inBigRect(int x, int y) {
        return x >= 20 && x <= 110 && y >= 181 && y <= 231;
    }

    private boolean inNextRect(int x, int y) {
        return x >= 40 && x <= 200 && y >= 181 && y <= 231;
    }

    private boolean inSmallRect(int x, int y) {
        return x >= 130 && x <= 220 && y >= 181 && y <= 231;
    }

    protected void paint(Graphics g) {
        if (this.offImage == null) {
            this.offImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        }
        Graphics og = this.offImage.getGraphics();
        this.clearGraphics(og);
        if (this.hcData == null) {
            return;
        }
        this.drawTitle(og);
        this.drawBackGround(og);
        this.drawTopScore(og);
        this.drawResult(og);
        this.drawButtonScreen(og);
        this.drawScore(og);
        this.drawCardScreen(og);
        this.drawCardPointer(og);
        g.drawImage(this.offImage, 0, 0, 20);
    }

    protected void pointerPressed(int x, int y) {
        if (this.hcData == null) {
            return;
        }
        if (this.hcData.isFinish()) {
            if (this.inNextRect(x, y)) {
                this.hcControl.pressedReceived(2);
            }
        } else if (this.inBigRect(x, y)) {
            this.hcControl.pressedReceived(0);
        } else if (this.inSmallRect(x, y)) {
            this.hcControl.pressedReceived(1);
        }
    }

    public void update(GameModel model, Object obj) {
        this.hcData = (BigSmallCardData)obj;
        this.repaint();
        this.serviceRepaints();
    }
}

