/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.gambling.bigsmallcard;

import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardData;
import com.ixisoft.games.gambling.card.Card;
import com.ixisoft.games.gambling.card.Deck;
import com.ixisoft.games.gambling.rms.GamblingRecord;
import com.ixisoft.games.util.GameModel;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStore;

public class BigSmallCardModel
extends GameModel
implements RecordListener {
    private static int CORRECT = 0;
    private static int WRONG = 1;
    private static int BET_POINT = 200;
    Deck deck = new Deck();
    BigSmallCardData hcData = new BigSmallCardData();
    GamblingRecord gameRecord = new GamblingRecord();
    int previousState = 1;
    boolean hasError = false;
    int errorCode = -1;

    public BigSmallCardModel() {
        this.loadScore();
    }

    public void aboutPressed() {
        this.hcData.setState(4);
        this.setChanged();
        this.notifyObservers(this.hcData);
    }

    int checkResult(int pCardNo, int cCardNo, int direction) {
        if (direction == BigSmallCardData.UP && cCardNo >= pCardNo) {
            return CORRECT;
        }
        if (direction == BigSmallCardData.DOWN && cCardNo <= pCardNo) {
            return CORRECT;
        }
        return WRONG;
    }

    public void clearError() {
        this.hasError = false;
    }

    public int getLastErrorCode() {
        return this.errorCode;
    }

    public int getWinPoint(int cardNo) {
        int correctCardNo = cardNo - 1;
        if (correctCardNo == 4) {
            return 140;
        }
        if (correctCardNo == 8) {
            return 280;
        }
        if (correctCardNo == 12) {
            return 520;
        }
        return correctCardNo * 10;
    }

    public boolean gotError() {
        return this.hasError;
    }

    public void helpPressed() {
        this.hcData.setState(3);
        this.setChanged();
        this.notifyObservers(this.hcData);
    }

    public void helpReturnPressed() {
        this.hcData.setState(this.previousState);
        this.setChanged();
        this.notifyObservers(this.hcData);
    }

    public boolean isFinish() {
        return this.hcData.isFinish();
    }

    public boolean isNewCreate() {
        return this.gameRecord.isNewCreate();
    }

    private void loadScore() {
        this.hcData.setTopScore(this.gameRecord.getTopScore());
        this.hcData.setScore(this.gameRecord.getScore());
    }

    public void mainReturnPressed() {
        this.previousState = 1;
        this.hcData.setState(1);
        this.setChanged();
        this.notifyObservers(this.hcData);
    }

    public void newGame() {
        this.hcData.clearStart();
        this.hcData.setShuffling();
        int i = 1;
        while (i <= BigSmallCardData.MAX_CARD_NO) {
            this.hcData.setCard(i, null);
            ++i;
        }
        this.hcData.setCurrentCardNo(1);
        this.setChanged();
        this.notifyObservers(this.hcData);
        this.deck.shuffle();
        this.hcData.clearShuffling();
        int i2 = 1;
        while (i2 <= BigSmallCardData.MAX_CARD_NO) {
            this.hcData.setCard(i2, this.deck.nextCard());
            ++i2;
        }
        this.hcData.setCurrentCardNo(2);
        this.hcData.setCurrentPoint(0);
        this.hcData.setScore(this.hcData.getScore() - BET_POINT);
        this.hcData.clearFinish();
        this.setChanged();
        this.notifyObservers(this.hcData);
    }

    public void nextCard(int direction) {
        if (this.hcData.isFinish()) {
            return;
        }
        int currentCardNo = this.hcData.getCurrentCardNo();
        int currentArrowNo = currentCardNo - 1;
        Card previousCard = this.hcData.getCard(currentArrowNo);
        Card currentCard = this.hcData.getCard(currentCardNo);
        if (this.checkResult(previousCard.getNumber(), currentCard.getNumber(), direction) == CORRECT) {
            int pointReceived = this.getWinPoint(currentCardNo);
            this.hcData.setLastWinPoint(pointReceived);
            this.hcData.setCurrentPoint(this.hcData.getCurrentPoint() + pointReceived);
            if (currentCardNo == BigSmallCardData.MAX_CARD_NO) {
                this.hcData.setWin();
                this.hcData.setScore(this.hcData.getScore() + this.hcData.getCurrentPoint());
                if (this.hcData.getScore() > this.hcData.getTopScore()) {
                    this.hcData.setTopScore(this.hcData.getScore());
                }
                this.hcData.setFinish();
                this.setChanged();
                this.notifyObservers(this.hcData);
            } else {
                this.hcData.setCurrentCardNo(++currentCardNo);
                this.setChanged();
                this.notifyObservers(this.hcData);
            }
            if (this.hcData.getScore() > this.hcData.getTopScore()) {
                this.hcData.setTopScore(this.hcData.getScore());
            }
        } else {
            this.hcData.setLose();
            this.hcData.setScore(this.hcData.getScore() + this.hcData.getCurrentPoint());
            if (this.hcData.getScore() > this.hcData.getTopScore()) {
                this.hcData.setTopScore(this.hcData.getScore());
            }
            this.hcData.setFinish();
            this.setChanged();
            this.notifyObservers(this.hcData);
        }
    }

    public void recordAdded(RecordStore recordStore, int recordId) {
    }

    public void recordChanged(RecordStore recordStore, int recordId) {
    }

    public void recordDeleted(RecordStore recordStore, int recordId) {
    }

    public void reset() {
        this.gameRecord.reset();
        this.hcData.setScore(this.gameRecord.getScore());
        this.hcData.setTopScore(this.gameRecord.getTopScore());
    }

    public void saveScore() {
        this.gameRecord.updateRecord(this.hcData.getTopScore(), this.hcData.getScore());
    }

    public void setLastErrorCode(int code) {
        this.errorCode = code;
        this.hasError = true;
    }

    public void startGame() {
        this.previousState = 2;
        this.hcData.setState(2);
        int i = 1;
        while (i <= BigSmallCardData.MAX_CARD_NO) {
            this.hcData.setCard(i, null);
            ++i;
        }
        this.hcData.setCurrentCardNo(1);
        if (this.gameRecord.isNewCreate()) {
            this.hcData.setStart();
        } else {
            this.hcData.clearStart();
        }
        this.hcData.setFinish();
        this.setChanged();
        this.notifyObservers(this.hcData);
    }
}

