/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.gambling.bigsmallcard;

import com.ixisoft.games.gambling.bigsmallcard.BigSmallCard;
import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardController;
import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardData;
import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardMainCanvas;
import com.ixisoft.games.gambling.bigsmallcard.BigSmallCardTitleCanvas;
import com.ixisoft.games.util.GameController;
import com.ixisoft.games.util.GameModel;
import com.ixisoft.games.util.GameView;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

public class BigSmallCardView
extends GameView {
    private final int MAX_HELP_PAGE_NO;
    private final int MAX_ABOUT_PAGE_NO;
    BigSmallCard hc = null;
    BigSmallCardData hcData = null;
    BigSmallCardController hcControl = null;
    BigSmallCardMainCanvas mainScreen = null;
    BigSmallCardTitleCanvas titleScreen = null;
    Vector helpScreens = new Vector();
    Vector aboutScreens = new Vector();
    int lastState = 0;

    public BigSmallCardView(BigSmallCard m, BigSmallCardController c) {
        this.MAX_HELP_PAGE_NO = 6;
        this.MAX_ABOUT_PAGE_NO = 2;
        this.hc = m;
        this.hcControl = c;
    }

    public int getMaxAboutPages() {
        return 2;
    }

    public int getMaxHelpPages() {
        return 6;
    }

    public Canvas getTitleScreen() {
        this.prepareTitleScreen();
        return this.titleScreen;
    }

    public void nextPressed(Displayable d) {
        int idx = this.helpScreens.indexOf(d);
        if (idx >= 0) {
            this.prepareHelpScreen(idx + 1);
            this.hc.getDisplay().setCurrent((Displayable)this.helpScreens.elementAt(idx + 1));
        } else {
            idx = this.aboutScreens.indexOf(d);
            if (idx >= 0) {
                this.prepareAboutScreen(idx + 1);
                this.hc.getDisplay().setCurrent((Displayable)this.aboutScreens.elementAt(idx + 1));
            }
        }
    }

    public void prepareAboutScreen(int idx) {
        Vector vector = this.aboutScreens;
        synchronized (vector) {
            if (this.aboutScreens.size() > idx) {
                return;
            }
            Form screen = new Form("About Page " + (idx + 1) + "/" + 2);
            switch (idx) {
                case 0: {
                    screen.append((Item)new StringItem("Family:", "ixiTainment"));
                    screen.append((Item)new StringItem("Product:", "Big Small Card"));
                    screen.append((Item)new StringItem("Version:", "v1.0-XA (Build " + this.hc.getAppProperty("MIDlet-Version") + ")"));
                    screen.append((Item)new StringItem("Created by:", "ixisoft Ltd."));
                    break;
                }
                case 1: {
                    screen.append((Item)new StringItem("Email:", "enq1@ixisoft.com"));
                    screen.append((Item)new StringItem("URL:", "www.ixisoft.com/ixiTainment/BigSmallCard"));
                    screen.append((Item)new StringItem("URL:", "www.ixisoft.com"));
                    break;
                }
            }
            this.hcControl.setAboutScreenCommands(screen, idx);
            this.aboutScreens.addElement(screen);
        }
    }

    public void prepareHelpScreen(int idx) {
        Vector vector = this.helpScreens;
        synchronized (vector) {
            if (this.helpScreens.size() > idx) {
                return;
            }
            Form screen = new Form("Help Page " + (idx + 1) + "/" + 6);
            switch (idx) {
                case 0: {
                    screen.append((Item)new StringItem("Instruction:", "You bet whether next card is bigger or smaller than the current one.  You will be rewarded for every card bet correctly, but will lose the hand if you are wrong."));
                    break;
                }
                case 1: {
                    screen.append((Item)new StringItem("Instruction:", "There are three row levels.  Advancing to next level or clearing all levels will score extra pts as reward.In the title screen, choose Continue to load your prev. pts;choose New Game to reset your pts."));
                    break;
                }
                case 2: {
                    screen.append((Item)new StringItem("Control:", "(1) Click New Hand/Next Hand to start a new hand.\n(2) Click Big/Small to guess the next card."));
                    break;
                }
                case 3: {
                    screen.append((Item)new StringItem("Score:", "A new game starts with 2000 points, but 200 points are deducted for each hand.\n(a) you will get 10 points x the number of cards correctly guessed in the hand."));
                    break;
                }
                case 4: {
                    screen.append((Item)new StringItem("Score:", "(b) you will get:\n- 100 extra points for advancing to row level two\n- 200 extra points for advancing to row level three\n- 400 extra points for clearing all cards."));
                    break;
                }
                case 5: {
                    screen.append((Item)new StringItem("Remark:", "(a) Ace, J, Q, K are treated as one, eleven, twelve and thirteen respectively.\n(b) Your guess is treated as correct even the card is equal to the previous one."));
                    break;
                }
            }
            this.hcControl.setHelpScreenCommands(screen, idx);
            this.helpScreens.addElement(screen);
        }
    }

    public void prepareMainScreen() {
        if (this.mainScreen != null) {
            return;
        }
        this.mainScreen = new BigSmallCardMainCanvas(this.hcControl);
        this.hcControl.setMainScreenCommands(this.mainScreen);
    }

    public void prepareTitleScreen() {
        if (this.titleScreen != null) {
            return;
        }
        this.titleScreen = new BigSmallCardTitleCanvas();
        this.hcControl.setTitleScreenCommands(this.titleScreen);
    }

    public void prevPressed(Displayable d) {
        int idx = this.helpScreens.indexOf(d);
        if (idx >= 0) {
            this.hc.getDisplay().setCurrent((Displayable)this.helpScreens.elementAt(idx - 1));
        } else {
            idx = this.aboutScreens.indexOf(d);
            if (idx >= 0) {
                this.hc.getDisplay().setCurrent((Displayable)this.aboutScreens.elementAt(idx - 1));
            }
        }
    }

    public void setController(GameController control) {
    }

    public void update(GameModel model, Object obj) {
        this.hcData = (BigSmallCardData)obj;
        int currentState = this.hcData.getState();
        if (currentState == 1) {
            this.prepareTitleScreen();
            if (this.lastState != 1) {
                this.hc.getDisplay().setCurrent((Displayable)this.titleScreen);
            }
            this.lastState = 1;
        } else if (currentState == 2) {
            this.prepareMainScreen();
            this.mainScreen.update(model, obj);
            if (this.lastState != 2) {
                this.hc.getDisplay().setCurrent((Displayable)this.mainScreen);
            }
            this.lastState = 2;
        } else if (currentState == 3) {
            this.prepareHelpScreen(0);
            if (this.lastState != 3) {
                this.hc.getDisplay().setCurrent((Displayable)this.helpScreens.firstElement());
            }
            this.lastState = 3;
        } else {
            this.prepareAboutScreen(0);
            if (this.lastState != 4) {
                this.hc.getDisplay().setCurrent((Displayable)this.aboutScreens.firstElement());
            }
            this.lastState = 4;
        }
    }
}

