/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.gambling.card;

import java.io.IOException;
import javax.microedition.lcdui.Image;

public class CardGraphics {
    private static Image[] kindImage = new Image[4];
    private static Image[] numberImage = new Image[13];
    private static Image blank40x50Image = null;
    private static Image outline40x50Image = null;
    private static Image blank25x31Image = null;
    private static Image outline25x31Image = null;
    public static int SMALL_CARD_WIDTH = 25;
    public static int SMALL_CARD_HEIGHT = 31;
    public static int BIG_CARD_WIDTH = 40;
    public static int BIG_CARD_HEIGHT = 50;
    private static boolean titleImagesLoaded = false;
    private static boolean cardImagesLoaded = false;

    static {
        try {
            int i = 0;
            while (i < 4) {
                CardGraphics.kindImage[i] = Image.createImage((String)("/images/cards/common/kind" + String.valueOf(i) + ".png"));
                ++i;
            }
            i = 0;
            while (i < 13) {
                CardGraphics.numberImage[i] = Image.createImage((String)("/images/cards/common/number" + String.valueOf(i + 1) + ".png"));
                ++i;
            }
        }
        catch (IOException err) {
            err.printStackTrace();
        }
    }

    public static Image getBlank25x31Image() {
        CardGraphics.loadTitleImages();
        return blank25x31Image;
    }

    public static Image getBlank40x50Image() {
        CardGraphics.loadTitleImages();
        return blank40x50Image;
    }

    public static Image getKindImage(int kind) {
        CardGraphics.loadCardImages();
        return kindImage[kind];
    }

    public static Image getNumberImage(int no) {
        CardGraphics.loadCardImages();
        return numberImage[no - 1];
    }

    public static Image getOutline25x31Image() {
        CardGraphics.loadTitleImages();
        return outline25x31Image;
    }

    public static Image getOutline40x50Image() {
        CardGraphics.loadTitleImages();
        return outline40x50Image;
    }

    public static void loadCardImages() {
        if (cardImagesLoaded) {
            return;
        }
        try {
            int i = 0;
            while (i < 4) {
                CardGraphics.kindImage[i] = Image.createImage((String)("/images/cards/common/kind" + String.valueOf(i) + ".png"));
                ++i;
            }
            i = 0;
            while (i < 13) {
                CardGraphics.numberImage[i] = Image.createImage((String)("/images/cards/common/number" + String.valueOf(i + 1) + ".png"));
                ++i;
            }
            cardImagesLoaded = true;
        }
        catch (IOException err) {
            err.printStackTrace();
        }
    }

    public static void loadTitleImages() {
        if (titleImagesLoaded) {
            return;
        }
        try {
            blank25x31Image = Image.createImage((String)"/images/cards/25x31/blank25x31.png");
            outline25x31Image = Image.createImage((String)"/images/cards/25x31/outline25x31.png");
            blank40x50Image = Image.createImage((String)"/images/cards/40x50/blank40x50.png");
            outline40x50Image = Image.createImage((String)"/images/cards/40x50/outline40x50.png");
            titleImagesLoaded = true;
        }
        catch (IOException err) {
            err.printStackTrace();
        }
    }
}

