/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.gambling.rms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GamblingRecord {
    public static final int RMS_ERROR_CODE = 100;
    private static final int INIT_TOP_SCORE = 0;
    private static final int INIT_SCORE = 2000;
    private RecordStore recordStore = null;
    int errorCode = 0;
    boolean hasError = false;
    int topScore = 0;
    int score = 2000;
    boolean newCreate = true;
    private int regId;

    public GamblingRecord() {
        try {
            this.recordStore = RecordStore.openRecordStore((String)"gambling", (boolean)true);
        }
        catch (Exception exception) {
            this.setErrorCode(100);
        }
        this.topScore = 0;
        this.score = 2000;
        this.load();
    }

    protected void clearError() {
        this.hasError = false;
    }

    public int getLastErrorCode() {
        return this.errorCode;
    }

    public int getScore() {
        return this.score;
    }

    public int getTopScore() {
        return this.topScore;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public boolean isNewCreate() {
        return this.newCreate;
    }

    public void load() {
        byte[] data = null;
        if (this.recordStore == null) {
            this.setErrorCode(100);
            return;
        }
        try {
            if (this.recordStore.getNumRecords() == 0) {
                this.newCreate = true;
                this.topScore = 0;
                this.score = 2000;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                try {
                    das.writeInt(this.topScore);
                    das.writeInt(this.score);
                }
                catch (IOException iOException) {
                    this.setErrorCode(100);
                    return;
                }
                byte[] b = baos.toByteArray();
                this.regId = this.recordStore.addRecord(b, 0, b.length);
            } else {
                this.regId = this.recordStore.getNextRecordID();
                this.newCreate = false;
                if (this.regId > 0) {
                    --this.regId;
                }
                if ((data = this.recordStore.getRecord(this.regId)) != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    DataInputStream dis = new DataInputStream(bais);
                    this.topScore = dis.readInt();
                    this.score = dis.readInt();
                } else {
                    this.topScore = 0;
                    this.score = 2000;
                }
            }
            this.clearError();
        }
        catch (Exception exception) {
            this.setErrorCode(100);
        }
    }

    public void reset() {
        this.score = 2000;
        this.save();
    }

    public void save() {
        if (this.recordStore == null) {
            this.setErrorCode(100);
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream das = new DataOutputStream(baos);
        try {
            das.writeInt(this.topScore);
            das.writeInt(this.score);
        }
        catch (IOException iOException) {
            this.setErrorCode(100);
            return;
        }
        byte[] b = baos.toByteArray();
        try {
            this.recordStore.setRecord(this.regId, b, 0, b.length);
            this.clearError();
        }
        catch (RecordStoreException recordStoreException) {
            this.setErrorCode(100);
        }
    }

    protected void setErrorCode(int e) {
        this.errorCode = e;
        this.hasError = true;
    }

    public void updateRecord(int ts, int s) {
        if (ts != this.topScore || s != this.score) {
            this.topScore = ts;
            this.score = s;
            this.save();
        }
    }
}

