/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.util;

import com.ixisoft.games.util.GameView;
import java.util.Enumeration;
import java.util.Vector;

public abstract class GameModel {
    private boolean changed = false;
    private Vector obs = new Vector();

    public synchronized void addObserver(GameView o) {
        if (!this.obs.contains(o)) {
            this.obs.addElement(o);
        }
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public void notifyObservers(Object arg) {
        Object[] arrLocal = new Object[this.obs.size()];
        GameModel gameModel = this;
        synchronized (gameModel) {
            if (!this.changed) {
                return;
            }
            int i = 0;
            Enumeration e = this.obs.elements();
            while (e.hasMoreElements()) {
                arrLocal[i] = e.nextElement();
                ++i;
            }
            this.clearChanged();
        }
        int i = arrLocal.length - 1;
        while (i >= 0) {
            ((GameView)arrLocal[i]).update(this, arg);
            --i;
        }
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    public abstract void startGame();
}

