/*
 * Decompiled with CFR 0.152.
 */
package com.mot.j2me.midlets.jbombman;

import com.mot.j2me.midlets.jbombman.Board;
import com.mot.j2me.midlets.jbombman.Enemy;
import com.mot.j2me.midlets.jbombman.Img;
import com.mot.j2me.midlets.jbombman.Player;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BoardView
extends Canvas {
    private Board oBoard;
    private Player oPlayer;
    private Enemy oEnemy;
    private final int BackgroundColor;
    private final int iCellSize;
    private final int iLeft;
    private final int iTop;

    public BoardView(Board board) {
        this.BackgroundColor = 0xFFFFFF;
        this.iCellSize = 20;
        this.iLeft = 10;
        this.iTop = 10;
        this.oBoard = board;
    }

    public void setPlayer(Player player) {
        this.oPlayer = player;
    }

    public void setEnemy(Enemy enemy) {
        this.oEnemy = enemy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics;
        synchronized (graphics2) {
            if (this.oBoard.isGameOver) {
                this.paintGameOver(graphics);
            } else if (this.oBoard.isWin) {
                this.paintWin(graphics);
            } else {
                this.paintBoard(graphics);
            }
        }
    }

    void paintGameOver(Graphics graphics) {
        try {
            Image image = Image.createImage((String)"/Gameover.png");
            graphics.drawImage(image, 60, 100, 20);
        }
        catch (Exception exception) {}
    }

    void paintWin(Graphics graphics) {
        try {
            Image image = Image.createImage((String)"/Cong.png");
            graphics.drawImage(image, 60, 100, 20);
        }
        catch (Exception exception) {}
    }

    private void paintFrame(Graphics graphics) {
        graphics.drawRect(0, 0, 239, 239);
        graphics.drawRect(1, 1, 237, 237);
        graphics.drawRect(2, 2, 235, 235);
        graphics.drawRect(3, 3, 233, 233);
        graphics.drawRect(7, 7, 225, 225);
        graphics.drawRect(8, 8, 223, 223);
    }

    private void paintBoard(Graphics graphics) {
        if (graphics.getClipX() == 0) {
            this.paintFrame(graphics);
        }
        int n = (graphics.getClipX() - 10) / 20;
        int n2 = (graphics.getClipY() - 10) / 20;
        int n3 = graphics.getClipWidth() / 20;
        int n4 = graphics.getClipHeight() / 20;
        if (n4 > this.oBoard.iRows) {
            n4 = this.oBoard.iRows;
        }
        if (n3 > this.oBoard.iCols) {
            n3 = this.oBoard.iCols;
        }
        System.out.println("paint: x=" + n + ", y=" + n2 + ", w=" + n3 + ", h=" + n4);
        int n5 = n;
        while (n5 < n + n3) {
            int n6 = n2;
            while (n6 < n2 + n4) {
                switch (this.oBoard.chBoard[n5][n6]) {
                    case 'N': {
                        graphics.setColor(0xFFFFFF);
                        graphics.fillRect(10 + n5 * 20, 10 + n6 * 20, 20, 20);
                        break;
                    }
                    case 'W': {
                        graphics.drawImage(Img.imgWall, 10 + n5 * 20, 10 + n6 * 20, 20);
                        break;
                    }
                    case 'L': {
                        graphics.drawImage(Img.imgPillar, 10 + n5 * 20, 10 + n6 * 20, 20);
                        break;
                    }
                    case 'P': 
                    case 'U': {
                        graphics.drawImage(Img.imgPlayer, 10 + n5 * 20, 10 + n6 * 20, 20);
                        break;
                    }
                    case 'E': {
                        graphics.drawImage(Img.imgEnemy, 10 + n5 * 20, 10 + n6 * 20, 20);
                        break;
                    }
                    case 'B': {
                        graphics.drawImage(Img.imgBomb, 10 + n5 * 20, 10 + n6 * 20, 20);
                        break;
                    }
                    case 'X': {
                        graphics.drawImage(Img.imgExploding, 10 + n5 * 20, 10 + n6 * 20, 20);
                    }
                }
                ++n6;
            }
            ++n5;
        }
    }

    public void keyPressed(int n) {
        if (this.oBoard.isGameOver || this.oBoard.isWin) {
            this.keyForInit(this.getGameAction(n));
        } else {
            this.keyForPlay(this.getGameAction(n));
        }
    }

    private void keyForInit(int n) {
        if (n != 8) {
            return;
        }
        this.oBoard.init();
        this.oEnemy.init();
        this.oPlayer.init();
        this.repaint();
    }

    private void keyForPlay(int n) {
        switch (n) {
            case 8: {
                this.oPlayer.fire();
                break;
            }
            case 2: {
                this.oPlayer.left();
                break;
            }
            case 5: {
                this.oPlayer.right();
                break;
            }
            case 1: {
                this.oPlayer.up();
                break;
            }
            case 6: {
                this.oPlayer.down();
            }
        }
    }

    public void repaintCells(int n, int n2, int n3, int n4) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.oBoard.iCols) {
            n = this.oBoard.iCols - 1;
        }
        if (n + n3 > this.oBoard.iCols) {
            n3 = this.oBoard.iCols - n;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.oBoard.iRows) {
            n2 = this.oBoard.iRows - 1;
        }
        if (n2 + n4 > this.oBoard.iRows) {
            n4 = this.oBoard.iRows - n2;
        }
        this.repaint(10 + n * 20, 10 + n2 * 20, n3 * 20, n4 * 20);
    }
}

