/*
 * Decompiled with CFR 0.152.
 */
package com.mot.j2me.midlets.jbombman;

import com.mot.j2me.midlets.jbombman.Board;
import com.mot.j2me.midlets.jbombman.BoardView;
import com.mot.j2me.midlets.jbombman.Player;
import java.util.Random;

public class Enemy
extends Thread {
    private Board oBoard;
    private BoardView oBoardView;
    public Player oPlayer;
    private final int iMoveTime;
    private Random random;
    private int iNumbers;
    private int[][] arrPositions;
    private volatile boolean stopThread = false;

    public Enemy(Board board, BoardView boardView, Player player, int n) {
        this.iMoveTime = 500;
        this.oBoard = board;
        this.oBoardView = boardView;
        this.oPlayer = player;
        this.iNumbers = n;
        this.arrPositions = new int[this.iNumbers][2];
        this.random = new Random();
        this.init();
    }

    public void init() {
        int n = 0;
        while (n < this.iNumbers) {
            int n2;
            int n3 = Math.abs(this.random.nextInt()) % this.oBoard.iCols;
            if (this.oBoard.chBoard[n3][n2 = Math.abs(this.random.nextInt()) % this.oBoard.iRows] != 'N') continue;
            this.oBoard.chBoard[n3][n2] = 69;
            this.arrPositions[n][0] = n3;
            this.arrPositions[n][1] = n2;
            ++n;
        }
    }

    public void stopThread() {
        this.stopThread = true;
    }

    public void run() {
        if (this.stopThread) {
            return;
        }
        do {
            try {
                Thread.sleep(500L);
                int n = 0;
                while (n < this.iNumbers) {
                    if (this.arrPositions[n][0] != -1) {
                        this.move(n);
                    }
                    ++n;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.stopThread);
    }

    private void move(int n) {
        switch (this.random.nextInt() % 4) {
            default: {
                break;
            }
            case 0: {
                int n2 = this.arrPositions[n][0] - 1;
                int n3 = this.arrPositions[n][1];
                if (!this.canGo(n2, n3)) break;
                System.out.println("Enemy " + n + " Left: x=" + n2 + ", y=" + n3);
                this.oBoard.chBoard[n2 + 1][n3] = 78;
                this.oBoard.chBoard[n2][n3] = 69;
                this.arrPositions[n][0] = n2;
                this.oBoardView.repaintCells(n2, n3, 2, 1);
                break;
            }
            case 1: {
                int n4 = this.arrPositions[n][0] + 1;
                int n5 = this.arrPositions[n][1];
                if (!this.canGo(n4, n5)) break;
                System.out.println("Enemy " + n + " Right: x=" + n4 + ", y=" + n5);
                this.oBoard.chBoard[n4 - 1][n5] = 78;
                this.oBoard.chBoard[n4][n5] = 69;
                this.arrPositions[n][0] = n4;
                this.oBoardView.repaintCells(n4 - 1, n5, 2, 1);
                break;
            }
            case 2: {
                int n6 = this.arrPositions[n][0];
                int n7 = this.arrPositions[n][1] - 1;
                if (!this.canGo(n6, n7)) break;
                System.out.println("Enemy " + n + " Down: x=" + n6 + ", y=" + n7);
                this.oBoard.chBoard[n6][n7 + 1] = 78;
                this.oBoard.chBoard[n6][n7] = 69;
                this.arrPositions[n][1] = n7;
                this.oBoardView.repaintCells(n6, n7, 1, 2);
                break;
            }
            case 3: {
                int n8 = this.arrPositions[n][0];
                int n9 = this.arrPositions[n][1] + 1;
                if (!this.canGo(n8, n9)) break;
                System.out.println("Enemy " + n + " Up: x=" + n8 + ", y=" + n9);
                this.oBoard.chBoard[n8][n9 - 1] = 78;
                this.oBoard.chBoard[n8][n9] = 69;
                this.arrPositions[n][1] = n9;
                this.oBoardView.repaintCells(n8, n9 - 1, 1, 2);
            }
        }
    }

    private boolean canGo(int n, int n2) {
        if (this.oBoard.isElement('N', n, n2)) {
            return true;
        }
        if (this.oBoard.isElement('P', n, n2)) {
            this.oPlayer.die();
        }
        return false;
    }

    public void die(int n, int n2) {
        System.out.println("Bomb die: x=" + n + ", y=" + n2);
        int n3 = 0;
        while (n3 < this.iNumbers) {
            if (this.arrPositions[n3][0] == n && this.arrPositions[n3][1] == n2) {
                this.arrPositions[n3][0] = -1;
                break;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.iNumbers) {
            if (this.arrPositions[n4][0] != -1) break;
            ++n4;
        }
        if (n4 == this.iNumbers) {
            this.oBoard.isWin = true;
            this.oBoardView.repaint();
        }
    }

    public void dieAll() {
        int n = 0;
        while (n < this.iNumbers) {
            this.arrPositions[n][0] = -1;
            ++n;
        }
    }
}

