/*
 * Decompiled with CFR 0.152.
 */
package com.mot.j2me.midlets.jbombman;

import com.mot.j2me.midlets.jbombman.Board;
import com.mot.j2me.midlets.jbombman.BoardView;
import com.mot.j2me.midlets.jbombman.Bomb;
import com.mot.j2me.midlets.jbombman.Enemy;
import java.util.Random;

public class Player {
    private Board oBoard;
    private BoardView oBoardView;
    private Enemy oEnemy;
    private Bomb oBomb;
    private Random random;
    private int iX;
    private int iY;

    public Player(Board board, BoardView boardView) {
        this.oBoard = board;
        this.oBoardView = boardView;
        this.random = new Random();
        this.init();
    }

    public void init() {
        do {
            this.iX = Math.abs(this.random.nextInt()) % this.oBoard.iCols;
            this.iY = Math.abs(this.random.nextInt()) % this.oBoard.iRows;
        } while (this.oBoard.chBoard[this.iX][this.iY] != 'N' || this.oBoard.near('E', this.iX, this.iY) || !this.oBoard.near2('N', this.iX, this.iY));
        this.oBoard.chBoard[this.iX][this.iY] = 80;
    }

    public void setEnemy(Enemy enemy) {
        this.oEnemy = enemy;
    }

    public void clearBomb() {
        this.oBomb = null;
        System.out.println("delete Bomb");
    }

    private boolean canGo(int n, int n2) {
        if (this.oBoard.isElement('N', n, n2)) {
            return true;
        }
        if (this.oBoard.isElement('E', n, n2)) {
            this.die();
        }
        return false;
    }

    public void fire() {
        this.oBomb = new Bomb(this.oBoard, this.oBoardView, this, this.oEnemy, this.iX, this.iY);
        this.oBomb.start();
        System.out.println("new Bomb: x=" + this.iX + ", y=" + this.iY);
    }

    public void left() {
        if (!this.canGo(this.iX - 1, this.iY)) {
            return;
        }
        this.oBoard.chBoard[this.iX][this.iY] = this.oBoard.chBoard[this.iX][this.iY] == 'U' ? 66 : 78;
        --this.iX;
        this.oBoard.chBoard[this.iX][this.iY] = 80;
        this.oBoardView.repaintCells(this.iX, this.iY, 2, 1);
    }

    public void right() {
        if (!this.canGo(this.iX + 1, this.iY)) {
            return;
        }
        this.oBoard.chBoard[this.iX][this.iY] = this.oBoard.chBoard[this.iX][this.iY] == 'U' ? 66 : 78;
        ++this.iX;
        this.oBoard.chBoard[this.iX][this.iY] = 80;
        this.oBoardView.repaintCells(this.iX - 1, this.iY, 2, 1);
    }

    public void up() {
        if (!this.canGo(this.iX, this.iY - 1)) {
            return;
        }
        this.oBoard.chBoard[this.iX][this.iY] = this.oBoard.chBoard[this.iX][this.iY] == 'U' ? 66 : 78;
        --this.iY;
        this.oBoard.chBoard[this.iX][this.iY] = 80;
        this.oBoardView.repaintCells(this.iX, this.iY, 1, 2);
    }

    public void down() {
        if (!this.canGo(this.iX, this.iY + 1)) {
            return;
        }
        this.oBoard.chBoard[this.iX][this.iY] = this.oBoard.chBoard[this.iX][this.iY] == 'U' ? 66 : 78;
        ++this.iY;
        this.oBoard.chBoard[this.iX][this.iY] = 80;
        this.oBoardView.repaintCells(this.iX, this.iY - 1, 1, 2);
    }

    public void die() {
        System.out.println("Player die: x=" + this.iX + ", y=" + this.iY);
        this.oEnemy.dieAll();
        this.oBoard.isGameOver = true;
        this.oBoardView.repaint();
    }
}

