/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.cf;

import com.ixisoft.games.cf.CrisisMIDlet;
import com.ixisoft.games.cf.GameModel;
import com.ixisoft.games.cf.GunRegion;
import com.ixisoft.games.cf.LifeRegion;
import com.ixisoft.games.cf.PeopleRegion;
import com.ixisoft.midlet.region.BorderRegion;
import com.ixisoft.midlet.region.ImageRegion;
import com.ixisoft.midlet.region.StringRegion;
import com.ixisoft.midlet.util.ContainerCanvas;
import com.ixisoft.midlet.util.MIDletContext;
import com.ixisoft.midlet.util.MIDletUtils;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class CrisisCanvas
extends ContainerCanvas
implements CommandListener {
    private static final Command CMD_END = new Command("End", 6, 101);
    private static final Command CMD_NEW_GAME = new Command("New", 4, 5);
    private static boolean classImagesLoaded = false;
    private static final int THIEF_NO = 10;
    private Timer devil = new Timer();
    private Timer timer = new Timer();
    private GameModel model = new GameModel();
    private int[] thiefArrRateVar = new int[]{2000, 10000, 10000, 20000, 10000, 3000, 5000, 10000, 10000, 10000};
    private int[] thiefArrRateMin = new int[]{10000, 3000, 6000, 9000, 2000, 3000, 7000, 9000, 4000, 95000};
    private int[] thiefShootRateVar = new int[]{20000, 20000, 20000, 20000, 20000, 30000, 10000, 30000, 15000, 20000};
    private int[] thiefShootRateMin = new int[]{3000, 3000, 3000, 4000, 5000, 3000, 3000, 3000, 3000, 3000};
    private int[] thiefs_X = new int[]{20, 20, 90, 170, 163, 52, 52, 122, 202, 195};
    private int[] thiefs_Y = new int[]{9, 95, 56, 101, 3, 4, 100, 51, 96, 8};
    private int[] thiefs_W = new int[]{30, 30, 30, 30, 30, 30, 30, 30, 30, 30};
    private int[] thiefs_H = new int[]{30, 35, 30, 30, 35, 35, 30, 35, 35, 30};
    private GunRegion gunRegion;
    private BorderRegion statusBorderRegion = new BorderRegion(3);
    private ImageRegion scoreTextRegion = new ImageRegion(null);
    private ImageRegion lifeTextRegion = new ImageRegion(null);
    private ImageRegion bulletTextRegion = new ImageRegion(null);
    private BorderRegion reloadBorderRegion = new BorderRegion(3);
    private ImageRegion reloadRegion = new ImageRegion(null);
    private LifeRegion lifeRegion;
    private StringRegion scoreRegion = new StringRegion();
    private ImageRegion endRegion = new ImageRegion(null);
    private ImageRegion beingHitRegion = new ImageRegion(null);
    private PeopleRegion[] thiefs = new PeopleRegion[10];
    private ImageRegion background = new ImageRegion(null);
    private static final int STATUS_X = 3;
    private static final int STATUS_Y = 180;
    private static final int STATUS_W = 234;
    private static final int STATUS_H = 55;
    private static final int RELOAD_X = 80;
    private static final int RELOAD_Y = 185;
    private static final int RELOAD_W = 50;
    private static final int RELOAD_H = 46;
    private static final int BULLET_TEXT_X = 5;
    private static final int BULLET_TEXT_Y = 185;
    private static final int BULLET_TEXT_W = 65;
    private static final int BULLET_TEXT_H = 15;
    private static final int GUN_X = 5;
    private static final int GUN_Y = 200;
    private static final int GUN_W = 65;
    private static final int GUN_H = 30;
    private static final int SCORE_TEXT_X = 140;
    private static final int SCORE_TEXT_Y = 185;
    private static final int SCORE_TEXT_W = 40;
    private static final int SCORE_TEXT_H = 20;
    private static final int SCORE_X = 185;
    private static final int SCORE_Y = 185;
    private static final int SCORE_W = 50;
    private static final int SCORE_H = 20;
    private static final int LIFE_TEXT_X = 140;
    private static final int LIFE_TEXT_Y = 210;
    private static final int LIFE_TEXT_W = 40;
    private static final int LIFE_TEXT_H = 20;
    private static final int LIFE_X = 185;
    private static final int LIFE_Y = 210;
    private static final int LIFE_W = 50;
    private static final int LIFE_H = 20;
    private boolean enableGameInput = false;
    private final Object notifier = new Object();
    boolean playing = false;
    Image[] thiefImg = new Image[3];
    Image lifeImg = null;
    Image bulletImg = null;
    Image emptyImg = null;
    Image offImage;
    CommandListener listener = null;
    boolean shooting = false;

    public CrisisCanvas() throws IOException {
        CrisisCanvas.loadClassImages();
        this.model.setCrisisListener(this);
        super.setCommandListener((CommandListener)this);
        this.background.setVisible(true);
        this.background.setImageLocator("/cf/cf-bg.png");
        this.statusBorderRegion.setVisible(true);
        this.endRegion.setImageLocator("/cf/end.png");
        this.endRegion.setVerticalCentered(true);
        this.endRegion.setHorizontalCentered(true);
        this.endRegion.setVisible(false);
        this.reloadRegion.setVisible(true);
        this.reloadRegion.setVerticalCentered(true);
        this.reloadRegion.setHorizontalCentered(true);
        this.reloadRegion.setImageLocator("/cf/reload.png");
        this.scoreTextRegion.setVisible(true);
        this.scoreTextRegion.setVerticalCentered(true);
        this.scoreTextRegion.setHorizontalCentered(true);
        this.scoreTextRegion.setImageLocator("/cf/score.png");
        this.bulletTextRegion.setVisible(true);
        this.bulletTextRegion.setVerticalCentered(true);
        this.bulletTextRegion.setHorizontalCentered(true);
        this.bulletTextRegion.setImageLocator("/cf/bullettext.png");
        this.lifeTextRegion.setVisible(true);
        this.lifeTextRegion.setVerticalCentered(true);
        this.lifeTextRegion.setHorizontalCentered(true);
        this.lifeTextRegion.setImageLocator("/cf/lifetext.png");
        this.beingHitRegion.setVisible(false);
        this.beingHitRegion.setImageLocator("/cf/beingHit.png");
        this.background.prefetchImage();
        this.beingHitRegion.prefetchImage();
        this.thiefImg[0] = Image.createImage((String)"/cf/arrive.png");
        this.thiefImg[1] = Image.createImage((String)"/cf/ready.png");
        this.thiefImg[2] = Image.createImage((String)"/cf/shoot.png");
        this.lifeImg = Image.createImage((String)"/cf/life.png");
        this.bulletImg = Image.createImage((String)"/cf/bullet.png");
        this.emptyImg = Image.createImage((String)"/cf/empty.png");
        this.lifeRegion = new LifeRegion(this.lifeImg, this.model);
        this.gunRegion = new GunRegion(this.emptyImg, this.bulletImg, this.model);
        this.scoreRegion.setFont(CrisisMIDlet.SMALL_FONT);
        this.scoreRegion.setVisible(true);
        this.addRegion(this.background, 0, 0, 240, 180);
        this.addRegion(this.statusBorderRegion, 1, 178, 238, 59);
        this.addRegion(this.gunRegion, 5, 200, 65, 30);
        this.addRegion(this.reloadRegion, 80, 185, 50, 46);
        this.addRegion(this.reloadBorderRegion, 80, 185, 50, 46);
        this.addRegion(this.lifeTextRegion, 140, 210, 40, 20);
        this.addRegion(this.scoreTextRegion, 140, 185, 40, 20);
        this.addRegion(this.bulletTextRegion, 5, 185, 65, 15);
        this.addRegion(this.lifeRegion, 185, 210, 50, 20);
        this.addRegion(this.scoreRegion, 185, 185, 50, 20);
        int i = 0;
        while (i < 10) {
            this.thiefs[i] = new PeopleRegion(this.thiefImg, this.thiefArrRateVar[i], this.thiefArrRateMin[i], this.thiefShootRateVar[i], this.thiefShootRateMin[i]);
            this.addRegion(this.thiefs[i], this.thiefs_X[i], this.thiefs_Y[i], this.thiefs_W[i], this.thiefs_H[i]);
            ++i;
        }
        this.addRegion(this.endRegion, 80, 60, 80, 30);
        this.addRegion(this.beingHitRegion, 80, 40, 80, 80);
    }

    void animateHitting() {
        if (this.playing) {
            this.enableGameInput = false;
            this.beingHitRegion.setVisible(true);
            this.beingHitRegion.repaintRegion();
            AlertType.ERROR.playSound(Display.getDisplay((MIDlet)this.getMIDletContext().getMIDlet()));
            this.serviceRepaints();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
            this.beingHitRegion.setVisible(false);
            this.beingHitRegion.repaintRegion();
            this.serviceRepaints();
        }
    }

    public synchronized void commandAction(Command c, Displayable d) {
        if (c == CMD_END) {
            this.quitGame();
        } else if (c == CMD_NEW_GAME) {
            this.serviceRepaints();
            this.resetGame();
        } else if (this.listener != null) {
            this.listener.commandAction(c, d);
        }
    }

    public void destroy() {
        super.destroy();
        this.timer.cancel();
        this.devil.cancel();
    }

    private void endGame() {
        this.playing = false;
        this.enableGameInput = false;
        this.removeCommand(CMD_END);
        this.removeCommand(CMD_NEW_GAME);
        this.repaint();
        CrisisMIDlet mid = (CrisisMIDlet)this.getMIDletContext().getMIDlet();
        Display.getDisplay((MIDlet)mid).setCurrent((Displayable)mid.openScreen);
    }

    public void gameOver() {
        if (!this.playing) {
            return;
        }
        this.playing = false;
        this.enableGameInput = false;
        this.endRegion.setVisible(true);
        this.endRegion.repaintRegion();
        this.addCommand(CrisisMIDlet.CMD_PLAY);
        this.repaint();
    }

    public void init(MIDletContext context) {
        this.setMIDletContext(context);
    }

    private boolean insideReload(int x, int y) {
        return MIDletUtils.rectangleContains(80, 185, 50, 46, x, y);
    }

    private boolean isGameFinished() {
        return this.model.isFinished();
    }

    private boolean isGameOver() {
        return this.model.isFinished();
    }

    private static synchronized void loadClassImages() throws IOException {
        if (classImagesLoaded) {
            return;
        }
        classImagesLoaded = true;
    }

    public void paint(Graphics g) {
        if (this.offImage == null) {
            this.offImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        }
        Graphics og = this.offImage.getGraphics();
        og.setClip(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        super.paint(og);
        g.drawImage(this.offImage, 0, 0, 20);
    }

    protected void pointerPressed(int x, int y) {
        if (!this.enableGameInput) {
            return;
        }
        if (this.shooting) {
            return;
        }
        Object object = this.notifier;
        synchronized (object) {
            if (!this.enableGameInput) {
                this.shooting = false;
                this.notifier.notifyAll();
                return;
            }
            if (this.shooting) {
                this.notifier.notifyAll();
                return;
            }
            this.shooting = true;
            this.enableGameInput = false;
            if (this.insideReload(x, y)) {
                this.model.reloadBullet();
            } else if (y < 180 && this.model.getRemainBulletNo() > 0) {
                this.model.fireBullet();
                int i = 0;
                while (i < 10) {
                    if (this.thiefs[i].getState() != 0 && this.thiefs[i].isHit(x, y)) {
                        this.thiefs[i].setState(0);
                        this.thiefs[i].setSkipState();
                        this.model.addScore(10);
                        this.thiefs[i].repaintRegion();
                        this.scoreRegion.setValue("" + this.model.getScore());
                        this.scoreRegion.repaintRegion();
                        break;
                    }
                    ++i;
                }
            }
            this.gunRegion.repaintRegion();
            this.serviceRepaints();
            this.enableGameInput = true;
            this.shooting = false;
            this.notifier.notifyAll();
        }
    }

    public void quitGame() {
        this.endGame();
    }

    public void removeCommandListener() {
        this.listener = null;
    }

    private void resetGame() {
        this.playing = true;
        this.enableGameInput = true;
        this.model.reset();
        this.endRegion.setVisible(false);
        this.endRegion.repaintRegion();
        this.scoreRegion.setValue("" + this.model.getScore());
        this.scoreRegion.repaintRegion();
        int i = 0;
        while (i < 10) {
            this.thiefs[i].setState(0);
            this.thiefs[i].setArrMinRate(this.thiefArrRateMin[i]);
            this.thiefs[i].setArrVarRate(this.thiefArrRateVar[i]);
            this.thiefs[i].setShootMinRate(this.thiefShootRateMin[i]);
            this.thiefs[i].setShootVarRate(this.thiefShootRateVar[i]);
            this.thiefs[i].repaintRegion();
            ++i;
        }
        this.removeCommand(CMD_NEW_GAME);
        this.removeCommand(CMD_END);
        this.addCommand(CrisisMIDlet.CMD_PLAY);
        this.addCommand(CrisisMIDlet.CMD_RETURN);
        this.repaint();
    }

    private void scheduleThiefAction(final int thief_id) {
        int rate = this.thiefs[thief_id].getState() == 0 ? MIDletUtils.getRandomInt(this.thiefs[thief_id].getArrVarRate()) + this.thiefs[thief_id].getArrMinRate() : MIDletUtils.getRandomInt(this.thiefs[thief_id].getShootVarRate()) + this.thiefs[thief_id].getShootMinRate();
        this.devil.schedule(new TimerTask(){

            public void run() {
                this.thiefAction(thief_id);
            }
        }, rate);
    }

    public void setCommandListener(CommandListener l) {
        this.listener = l;
    }

    public void startGame() {
        this.resetGame();
        this.addCommand(CMD_END);
        this.removeCommand(CMD_NEW_GAME);
        this.removeCommand(CrisisMIDlet.CMD_PLAY);
        this.removeCommand(CrisisMIDlet.CMD_RETURN);
        this.statusBorderRegion.setVisible(true);
        this.repaint();
        this.serviceRepaints();
        int i = 0;
        while (i < 10) {
            this.scheduleThiefAction(i);
            ++i;
        }
    }

    void thiefAction(int thief_id) {
        Object object = this.notifier;
        synchronized (object) {
            if (this.playing) {
                while (this.shooting) {
                    try {
                        this.notifier.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                MIDletUtils util = MIDletUtils.getInstance();
                this.thiefs[thief_id].changeState();
                this.thiefs[thief_id].repaintRegion();
                this.serviceRepaints();
                if (this.thiefs[thief_id].getState() >= 3) {
                    this.enableGameInput = false;
                    this.model.reduceLife();
                    this.lifeRegion.repaintRegion();
                    this.animateHitting();
                    int i = 0;
                    while (i < 10) {
                        this.thiefs[i].setSkipState();
                        ++i;
                    }
                    this.thiefs[thief_id].setState(0);
                    this.thiefs[thief_id].repaintRegion();
                    this.enableGameInput = true;
                }
                this.serviceRepaints();
            }
            if (this.isGameOver()) {
                this.gameOver();
            }
            this.notifier.notifyAll();
        }
        if (!this.isGameOver()) {
            this.scheduleThiefAction(thief_id);
        }
    }
}

