/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.cf;

import com.ixisoft.games.cf.CrisisCanvas;
import com.ixisoft.midlet.region.BorderRegion;
import com.ixisoft.midlet.region.ImageRegion;
import com.ixisoft.midlet.region.StringRegion;
import com.ixisoft.midlet.util.ContainerCanvas;
import com.ixisoft.midlet.util.MIDletContext;
import com.ixisoft.midlet.util.MIDletContextImpl;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class CrisisMIDlet
extends MIDlet
implements CommandListener {
    Display display = Display.getDisplay((MIDlet)this);
    private final MIDletContext context = new MIDletContextImpl(this);
    private boolean justCreated = true;
    ContainerCanvas openScreen;
    StringRegion status = new StringRegion();
    private static final int HELP_PAGES = 2;
    private static final int ABOUT_PAGES = 2;
    private Vector helpScreens = new Vector();
    private Vector aboutScreens = new Vector();
    private CrisisCanvas gameScreen;
    private static Command CMD_GAME = new Command("Start", 4, 0);
    private static Command CMD_QUIT = new Command("Quit", 6, 1);
    private static Command CMD_HELP = new Command("Help", 5, 2);
    private static Command CMD_ABOUT = new Command("About", 5, 3);
    private static Command CMD_NEXT = new Command("Next", 4, 101);
    private static Command CMD_MAIN = new Command("Home", 6, 102);
    private static Command CMD_PREV = new Command("Prev", 2, 103);
    static Command CMD_RETURN = new Command("Return", 2, 20);
    static Command CMD_PLAY = new Command("Play", 4, 10);
    static final Font SMALL_FONT = Font.getFont((int)64, (int)0, (int)8);
    public static final boolean DEBUG = false;

    public CrisisMIDlet() {
        this.status.setFont(SMALL_FONT);
        this.status.setHorizontalAlignment(1);
    }

    private void commandAboutAction(Command c, int aboutIndex) throws IOException {
        if (c == CMD_MAIN) {
            this.display.setCurrent((Displayable)this.openScreen);
        } else if (c == CMD_NEXT) {
            this.prepareAboutScreen(aboutIndex + 1);
            this.display.setCurrent((Displayable)this.aboutScreens.elementAt(aboutIndex + 1));
        } else if (c == CMD_PREV) {
            this.display.setCurrent((Displayable)this.aboutScreens.elementAt(aboutIndex - 1));
        }
    }

    public void commandAction(Command c, Displayable d) {
        try {
            int idx = this.helpScreens.indexOf(d);
            if (idx >= 0) {
                this.commandHelpAction(c, idx);
            } else {
                idx = this.aboutScreens.indexOf(d);
                if (idx >= 0) {
                    this.commandAboutAction(c, idx);
                } else if (c == CMD_QUIT) {
                    this.notifyDestroyed();
                } else if (c == CMD_ABOUT) {
                    this.prepareAboutScreen(0);
                    this.display.setCurrent((Displayable)this.aboutScreens.firstElement());
                } else if (c == CMD_HELP) {
                    this.prepareHelpScreen(0);
                    this.display.setCurrent((Displayable)this.helpScreens.firstElement());
                } else if (c == CMD_GAME) {
                    this.prepareGameScreen();
                    this.display.setCurrent((Displayable)this.gameScreen);
                    this.gameScreen.repaint();
                } else if (c == CMD_RETURN) {
                    this.display.setCurrent((Displayable)this.openScreen);
                } else if (c == CMD_PLAY) {
                    this.gameScreen.startGame();
                }
            }
        }
        catch (IOException e) {
            this.showError(e);
        }
    }

    private void commandHelpAction(Command c, int helpIndex) throws IOException {
        if (c == CMD_MAIN) {
            this.display.setCurrent((Displayable)this.openScreen);
        } else if (c == CMD_NEXT) {
            this.prepareHelpScreen(helpIndex + 1);
            this.display.setCurrent((Displayable)this.helpScreens.elementAt(helpIndex + 1));
        } else if (c == CMD_PREV) {
            this.display.setCurrent((Displayable)this.helpScreens.elementAt(helpIndex - 1));
        }
    }

    protected void destroyApp(boolean unconditional) {
        if (this.gameScreen != null) {
            this.gameScreen.destroy();
        }
        this.display.setCurrent(null);
    }

    protected void pauseApp() {
    }

    private void prepareAboutScreen(int idx) throws IOException {
        Vector vector = this.aboutScreens;
        synchronized (vector) {
            if (this.aboutScreens.size() > idx) {
                return;
            }
            Form screen = new Form("About Page " + (idx + 1) + "/" + 2);
            switch (idx) {
                case 0: {
                    screen.append((Item)new StringItem("Family: ", "ixiTainment"));
                    screen.append((Item)new StringItem("Product: ", this.getAppProperty("MIDlet-Name")));
                    screen.append((Item)new StringItem("Version: ", "v1.0-XA (Build " + this.getAppProperty("MIDlet-Version") + ")"));
                    screen.append((Item)new StringItem("Created-by: ", "ixisoft Ltd."));
                    break;
                }
                case 1: {
                    screen.append((Item)new StringItem("Email: ", "enq1@ixisoft.com"));
                    screen.append((Item)new StringItem("URL: ", "www.ixisoft.com/ixiTainment/CrisisForce/"));
                    screen.append((Item)new StringItem("URL: ", "www.ixisoft.com"));
                    break;
                }
            }
            if (idx < 1) {
                screen.addCommand(CMD_NEXT);
            }
            if (idx > 0) {
                screen.addCommand(CMD_PREV);
            }
            screen.addCommand(CMD_MAIN);
            screen.setCommandListener((CommandListener)this);
            this.aboutScreens.addElement(screen);
        }
    }

    private void prepareGameScreen() throws IOException {
        this.status.setValue("Loading, please wait...");
        this.status.repaintRegion();
        this.openScreen.serviceRepaints();
        CrisisCanvas screen = new CrisisCanvas();
        screen.addCommand(CMD_PLAY);
        screen.addCommand(CMD_RETURN);
        screen.setCommandListener(this);
        screen.init(this.context);
        this.gameScreen = screen;
        this.status.setValue(null);
    }

    private void prepareHelpScreen(int idx) throws IOException {
        Vector vector = this.helpScreens;
        synchronized (vector) {
            if (this.helpScreens.size() > idx) {
                return;
            }
            Form screen = new Form("Help Page " + (idx + 1) + "/" + 2);
            switch (idx) {
                case 0: {
                    screen.append((Item)new StringItem(null, "Criminals are all around !! Use your gun to shoot them once you saw them. If you let them stay too long, they will shoot you back !!! So kill them once they appear !! "));
                    break;
                }
                case 1: {
                    screen.append((Item)new StringItem(null, "But remember, your gun can only hold 5 bullets. Click RELOAD to refill it once your gun is out of bullet."));
                    break;
                }
            }
            if (idx < 1) {
                screen.addCommand(CMD_NEXT);
            }
            if (idx > 0) {
                screen.addCommand(CMD_PREV);
            }
            screen.addCommand(CMD_MAIN);
            screen.setCommandListener((CommandListener)this);
            this.helpScreens.addElement(screen);
        }
    }

    private void prepareOpenScreen() throws IOException {
        if (this.openScreen != null) {
            return;
        }
        Image logo = Image.createImage((String)"/cf/cf-logo.png");
        ContainerCanvas screen = new ContainerCanvas();
        int w = screen.getWidth();
        int h = screen.getHeight();
        StringRegion titleRegion = new StringRegion();
        titleRegion.setValue(this.getAppProperty("MIDlet-Name"));
        BorderRegion titleBorder = new BorderRegion(3);
        titleBorder.setBackground(0xAAAAAA);
        ImageRegion logoRegion = new ImageRegion(logo, 0, 0);
        logoRegion.setHorizontalCentered(true);
        logoRegion.setVerticalCentered(true);
        StringRegion copyright1 = new StringRegion();
        StringRegion copyright2 = new StringRegion();
        copyright1.setValue("(c)2001 ixisoft Ltd.");
        copyright2.setValue("All rights reserved.");
        copyright1.setFont(SMALL_FONT);
        copyright2.setFont(SMALL_FONT);
        BorderRegion statusBorder = new BorderRegion(3);
        screen.addRegion(titleBorder, 0, 0, w, 28);
        screen.addRegion(titleRegion, 2, 2, w - 4, 24);
        screen.addRegion(logoRegion, 0, 30, w, 120);
        screen.addRegion(copyright1, 2, 152, w - 4, 24);
        screen.addRegion(copyright2, 2, 176, w - 4, 24);
        screen.addRegion(statusBorder, 2, 202, w - 4, 28);
        screen.addRegion(this.status, 4, 204, w - 8, 24);
        screen.addCommand(CMD_GAME);
        screen.addCommand(CMD_QUIT);
        screen.addCommand(CMD_HELP);
        screen.addCommand(CMD_ABOUT);
        screen.setCommandListener(this);
        this.openScreen = screen;
    }

    private void showError(Exception e) {
        Form form = new Form("Error");
        form.append((Item)new StringItem(e.getClass().getName(), e.getMessage()));
        this.display.setCurrent((Displayable)form);
    }

    protected void startApp() {
        if (this.justCreated) {
            try {
                this.prepareOpenScreen();
                this.display.setCurrent((Displayable)this.openScreen);
            }
            catch (IOException e) {
                this.showError(e);
                return;
            }
        }
    }
}

