/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.cf;

import com.ixisoft.games.cf.CrisisCanvas;

public class GameModel {
    public static final int MAX_BULLETS = 5;
    public static final int MAX_LIFES = 3;
    private CrisisCanvas listener;
    private int remainBulletNo = 0;
    private int remainLife = 0;
    private int score = 0;

    public GameModel() {
        this.reset();
    }

    public synchronized void addScore(int s) {
        this.score += s;
    }

    public synchronized void fireBullet() {
        if (this.remainBulletNo > 0) {
            --this.remainBulletNo;
        }
    }

    public synchronized int getRemainBulletNo() {
        return this.remainBulletNo;
    }

    public synchronized int getRemainLife() {
        return this.remainLife;
    }

    public synchronized int getScore() {
        return this.score;
    }

    public synchronized boolean isFinished() {
        return this.remainLife <= 0;
    }

    public synchronized void reduceLife() {
        --this.remainLife;
    }

    public synchronized void reloadBullet() {
        this.remainBulletNo = 5;
    }

    public synchronized void reset() {
        this.reloadBullet();
        this.resetLife();
        this.resetScore();
    }

    public synchronized void resetLife() {
        this.remainLife = 3;
    }

    public synchronized void resetScore() {
        this.score = 0;
    }

    public void setCrisisListener(CrisisCanvas l) {
        this.listener = l;
    }

    public synchronized void setRemainBulletNo(int no) {
        this.remainBulletNo = no;
    }

    public synchronized void setRemainLift(int no) {
        this.remainLife = no;
    }

    public synchronized void setScore(int no) {
        this.score = no;
    }
}

