/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.midlet.imageloader;

import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class ImageLoader {
    private static ImageLoader instance;
    private Hashtable imageMap = new Hashtable();
    private Hashtable aliasMap = new Hashtable();

    private ImageLoader() {
    }

    private static synchronized void ensureInstanceCreated() {
        if (instance == null) {
            instance = new ImageLoader();
        }
    }

    public Image getImage(String locator) throws IOException {
        Image img;
        if (locator == null) {
            throw new NullPointerException();
        }
        String alias = (String)this.aliasMap.get(locator);
        if (alias == null) {
            alias = locator;
        }
        if ((img = (Image)this.imageMap.get(alias)) == null) {
            img = this.loadImage(alias);
        }
        return img;
    }

    public static ImageLoader getInstance() {
        if (instance == null) {
            ImageLoader.ensureInstanceCreated();
        }
        return instance;
    }

    private synchronized Image loadImage(String locator) throws IOException {
        Image img = (Image)this.imageMap.get(locator);
        if (img == null) {
            img = Image.createImage((String)locator);
        }
        return img;
    }

    public Image putImage(String locator, Image img) {
        if (locator == null || img == null) {
            throw new NullPointerException();
        }
        return this.imageMap.put(locator, img);
    }
}

