/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.midlet.region;

import com.ixisoft.midlet.util.Region;
import javax.microedition.lcdui.Graphics;

public class BorderRegion
extends Region {
    public static final int PLAIN = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int DARKER_RAISED = 3;
    public static final int DARKER_LOWERED = 4;
    public static final int DARK_GREY = 0x555555;
    public static final int LIGHT_GREY = 0xAAAAAA;
    public static final int BLACK = 0;
    public static final int WHITE = 0xFFFFFF;
    private int borderType;
    private int color1;
    private int color2;
    private int color3;
    private boolean transparent = true;
    private int bgColor = 0xFFFFFF;

    public BorderRegion() {
        this(1);
    }

    public BorderRegion(int borderType) {
        this.borderType = borderType;
        switch (borderType) {
            case 3: {
                this.color2 = 0xFFFFFF;
                this.color3 = 0;
                this.color1 = 0x555555;
                break;
            }
            case 4: {
                this.color2 = 0;
                this.color3 = 0xFFFFFF;
                this.color1 = 0x555555;
                break;
            }
            case 1: {
                this.color2 = 0xFFFFFF;
                this.color3 = 0x555555;
                this.color1 = 0xAAAAAA;
                break;
            }
            case 2: {
                this.color2 = 0x555555;
                this.color3 = 0xFFFFFF;
                this.color1 = 0xAAAAAA;
                break;
            }
            default: {
                this.color2 = 0xAAAAAA;
                this.color3 = 0xAAAAAA;
                this.color1 = 0xAAAAAA;
            }
        }
    }

    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (!this.transparent) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, w, h);
        }
        g.setColor(this.color1);
        g.drawRect(0, 0, w - 1, h - 1);
        g.drawRect(1, 1, w - 3, h - 3);
        if (this.borderType != 0) {
            g.setColor(this.color2);
            g.drawLine(1, 1, w - 3, 1);
            g.drawLine(1, 1, 1, h - 3);
            g.setColor(this.color3);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 1);
        }
    }

    public void setBackground(int color) {
        this.bgColor = color;
        this.setTransparent(false);
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }
}

