/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.midlet.region;

import com.ixisoft.midlet.imageloader.ImageLoader;
import com.ixisoft.midlet.util.Region;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageRegion
extends Region {
    private String locator;
    private Image image;
    private int xOffset;
    private int yOffset;
    private boolean vcenter;
    private boolean hcenter;

    public ImageRegion(String locator) {
        this(locator, null, 0, 0);
    }

    public ImageRegion(String locator, int xoff, int yoff) {
        this(locator, null, xoff, yoff);
    }

    public ImageRegion(String locator, Image image, int xoff, int yoff) {
        if (locator != null) {
            this.setImageLocator(locator);
        } else {
            this.setImage(image);
        }
        this.setImageOffset(xoff, yoff);
    }

    public ImageRegion(Image image, int xoff, int yoff) {
        this(null, image, xoff, yoff);
    }

    public Image getImage() throws IOException {
        if (this.image == null) {
            this.prefetchImage();
        }
        return this.image;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void paint(Graphics g) {
        Image img = null;
        try {
            img = this.getImage();
            if (img == null) {
                return;
            }
            if (this.hcenter && this.vcenter) {
                g.drawImage(img, this.getWidth() / 2, this.getHeight() / 2, 3);
            } else if (this.hcenter) {
                g.drawImage(img, this.getWidth() / 2, 0, 17);
            } else if (this.vcenter) {
                g.drawImage(img, 0, this.getHeight() / 2, 18);
            } else {
                g.drawImage(img, -this.xOffset, -this.yOffset, 20);
            }
        }
        catch (IOException iOException) {
            g.drawString("loading error", 0, 0, 20);
        }
    }

    public synchronized void prefetchImage() throws IOException {
        if (this.image == null && this.locator != null) {
            this.image = ImageLoader.getInstance().getImage(this.locator);
            this.locator = null;
        }
    }

    public void setHorizontalCentered(boolean hcenter) {
        this.hcenter = hcenter;
    }

    public void setImage(Image img) {
        this.setImage(img, 0, 0);
    }

    public void setImage(Image img, int xoff, int yoff) {
        this.image = img;
        this.locator = null;
        this.setImageOffset(xoff, yoff);
    }

    public void setImageLocator(String locator) {
        this.setImageLocator(locator, 0, 0);
    }

    public void setImageLocator(String locator, int xoff, int yoff) {
        this.locator = locator;
        this.image = null;
        this.setImageOffset(xoff, yoff);
    }

    public void setImageOffset(int xoff, int yoff) {
        this.xOffset = xoff;
        this.yOffset = yoff;
    }

    public void setVerticalCentered(boolean vcenter) {
        this.vcenter = vcenter;
    }
}

