/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.midlet.util;

import com.ixisoft.midlet.util.Container;
import com.ixisoft.midlet.util.ContainerCanvas;
import com.ixisoft.midlet.util.Region;
import java.util.Random;

public class MIDletUtils {
    private static final MIDletUtils instance = new MIDletUtils();
    private static final Random random = new Random();

    private MIDletUtils() {
    }

    public static boolean circleContains(int cx, int cy, int cr, int x, int y) {
        int dx = x - cx;
        int dy = y - cy;
        return dx * dx + dy * dy <= cr * cr;
    }

    public static boolean circleIntersects(int cx, int cy, int cr, int x, int y, int r) {
        int dx = x - cx;
        int dy = y - cy;
        int R = cr + r;
        return dx * dx + dy * dy <= R * R;
    }

    public static boolean circleIntersects(int cx, int cy, int cr, int x, int y, int w, int h) {
        return MIDletUtils.circleContains(cx, cy, cr, x, y) || MIDletUtils.circleContains(cx, cy, cr, x, y + h) || MIDletUtils.circleContains(cx, cy, cr, x + w, y) || MIDletUtils.circleContains(cx, cy, cr, x + w, y + h);
    }

    public static ContainerCanvas getContainerCanvas(Region r) {
        Container p;
        if (r == null) {
            return null;
        }
        while ((p = r.getContainer()) != null && !(p instanceof ContainerCanvas)) {
        }
        if (p == null) {
            return null;
        }
        return (ContainerCanvas)p;
    }

    public static MIDletUtils getInstance() {
        return instance;
    }

    public static int getRandomInt(int range) {
        int r;
        while ((r = random.nextInt()) < 0) {
        }
        return r % range;
    }

    public static boolean rectanglarCircleContains(int cx, int cy, int cd, int x, int y) {
        return MIDletUtils.circleContains(2 * cx + cd, 2 * cy + cd, cd, 2 * x, 2 * y);
    }

    public static boolean rectangleContains(int rx, int ry, int rw, int rh, int x, int y) {
        return x >= rx && x - rx < rw && y >= ry && y - ry < rh;
    }

    public static boolean rectangleContains(int rx, int ry, int rw, int rh, int x, int y, int w, int h) {
        if (rw <= 0 || rh <= 0 || w <= 0 || h <= 0) {
            return false;
        }
        return x >= rx && y >= ry && x + w <= rx + rw && y + h <= ry + rh;
    }

    public static boolean rectangleIntersects(int rx, int ry, int rw, int rh, int x, int y, int w, int h) {
        return (rx + rw <= x || ry + rh <= y || rx >= x + w || ry >= y + h) ^ true;
    }

    public static boolean rectangularCircleIntersects(int cx, int cy, int cd, int x, int y, int d) {
        return MIDletUtils.circleIntersects(2 * cx + cd, 2 * cy + cd, cd, 2 * x + d, 2 * y + d, d);
    }

    public static boolean rectangularCircleIntersects(int cx, int cy, int cd, int x, int y, int w, int h) {
        return MIDletUtils.circleIntersects(2 * cx + cd, 2 * cy + cd, cd, x, y, w, h);
    }
}

