/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.midlet.util;

import com.ixisoft.midlet.util.Container;
import com.ixisoft.midlet.util.MIDletUtils;
import com.ixisoft.midlet.util.Region;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class RegionContainer
extends Region
implements Container {
    private Vector children = null;
    private static Font font = Font.getFont((int)64, (int)0, (int)0);

    public void addRegion(int index, Region r) {
        if (this.children == null) {
            RegionContainer regionContainer = this;
            synchronized (regionContainer) {
                this.children = new Vector();
            }
        }
        int idx = Math.min(this.children.size(), index);
        this.children.insertElementAt(r, idx);
        r.setContainer(this);
    }

    public void addRegion(int index, Region r, int x, int y, int w, int h) {
        r.reshape(x, y, w, h);
        this.addRegion(index, r);
    }

    public void addRegion(Region r) {
        this.addRegion(this.children == null ? 0 : this.children.size(), r);
    }

    public void addRegion(Region r, int x, int y, int w, int h) {
        this.addRegion(this.children == null ? 0 : this.children.size(), r, x, y, w, h);
    }

    public void paint(Graphics g) {
        if (this.children != null) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                Region r = (Region)enumeration.nextElement();
                if (!r.isVisible()) continue;
                this.paintRegion(g, r);
            }
        }
    }

    protected void paintRegion(Graphics g, Region r) {
        int h;
        int w;
        int y;
        int x;
        int ch;
        int cw;
        int cy;
        int cx = g.getClipX();
        if (!MIDletUtils.rectangleIntersects(cx, cy = g.getClipY(), cw = g.getClipWidth(), ch = g.getClipHeight(), x = r.getX(), y = r.getY(), w = r.getWidth(), h = r.getHeight())) {
            return;
        }
        g.setColor(0);
        g.setFont(font);
        g.translate(x, y);
        g.clipRect(0, 0, w, h);
        r.paint(g);
        g.translate(-x, -y);
        g.setClip(cx, cy, cw, ch);
    }

    public void removeRegion(Region r) {
        if (this.children != null && this.children.removeElement(r)) {
            r.setContainer(null);
        }
    }

    void repaintRegion(Region r) {
        this.repaint(this.getX() + r.getX(), this.getY() + r.getY(), r.getWidth(), r.getHeight());
    }
}

