/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ChessGUI {
    public static final int MAX_COMMANDS = 2;
    private static final int LINE_CORR = 1;
    private static final int BACKGROUND = 12439485;
    private static final int STRINGHEIGHT = 24;
    private Canvas canvas;
    private Image chessimg;
    private Graphics chessgraph;
    private Image[] pieces;
    private String[] commands;

    public ChessGUI(Canvas canvas) {
        this.canvas = canvas;
        this.initializeImage("/xboard.png");
        this.commands = new String[3];
        int n = 1;
        while (n <= 2) {
            this.commands[n] = "";
            ++n;
        }
    }

    private void createSubImages(Image image) {
        this.pieces = new Image[28];
        int n = image.getWidth() / 8;
        int n2 = image.getHeight() / 8;
        int n3 = 0;
        while (n3 < 28) {
            int n4 = 11;
            switch (n3) {
                case 0: {
                    n4 = 26;
                    break;
                }
                case 1: {
                    n4 = 17;
                    break;
                }
                case 2: {
                    n4 = 88;
                    break;
                }
                case 3: {
                    n4 = 28;
                    break;
                }
                case 4: {
                    n4 = 68;
                    break;
                }
                case 5: {
                    n4 = 48;
                    break;
                }
                case 6: {
                    n4 = 55;
                    break;
                }
                case 7: {
                    n4 = 16;
                    break;
                }
                case 8: {
                    n4 = 27;
                    break;
                }
                case 9: {
                    n4 = 18;
                    break;
                }
                case 10: {
                    n4 = 78;
                    break;
                }
                case 11: {
                    n4 = 38;
                    break;
                }
                case 12: {
                    n4 = 45;
                    break;
                }
                case 13: {
                    n4 = 58;
                    break;
                }
                case 14: {
                    n4 = 13;
                    break;
                }
                case 15: {
                    n4 = 22;
                    break;
                }
                case 16: {
                    n4 = 11;
                    break;
                }
                case 17: {
                    n4 = 71;
                    break;
                }
                case 18: {
                    n4 = 31;
                    break;
                }
                case 19: {
                    n4 = 44;
                    break;
                }
                case 20: {
                    n4 = 51;
                    break;
                }
                case 21: {
                    n4 = 23;
                    break;
                }
                case 22: {
                    n4 = 12;
                    break;
                }
                case 23: {
                    n4 = 81;
                    break;
                }
                case 24: {
                    n4 = 21;
                    break;
                }
                case 25: {
                    n4 = 61;
                    break;
                }
                case 26: {
                    n4 = 41;
                    break;
                }
                case 27: {
                    n4 = 54;
                }
            }
            this.pieces[n3] = Image.createImage((int)(n - 2), (int)(n2 - 2));
            Graphics graphics = this.pieces[n3].getGraphics();
            graphics.drawImage(image, -1 - this.getXPos(n4), -1 - this.getYPos(n4), 20);
            ++n3;
        }
    }

    public void drawChessGraphics(Graphics graphics) {
        graphics.drawImage(this.chessimg, this.canvas.getWidth() - this.chessimg.getWidth(), 0, 20);
    }

    public void drawCommands(Graphics graphics) {
        int n = this.chessimg.getHeight() / 8;
        graphics.setColor(12439485);
        graphics.fillRect(0, 0, this.canvas.getWidth() - this.chessimg.getWidth(), this.chessimg.getHeight());
        graphics.setColor(0, 0, 0);
        int n2 = 0;
        while (n2 < 4) {
            if (this.commands[1].length() > n2) {
                graphics.drawChar(this.commands[1].charAt(n2), 5, n2 * n, 20);
            }
            ++n2;
        }
        graphics.drawLine(0, 4 * n - 2, this.canvas.getWidth() - this.chessimg.getWidth(), 4 * n - 2);
        graphics.drawLine(0, 4 * n - 1, this.canvas.getWidth() - this.chessimg.getWidth(), 4 * n - 1);
        int n3 = 0;
        while (n3 < 4) {
            if (this.commands[2].length() > n3) {
                graphics.drawChar(this.commands[2].charAt(n3), 5, (n3 + 4) * n, 20);
            }
            ++n3;
        }
        graphics.drawLine(0, this.chessimg.getHeight() - 2, this.canvas.getWidth() - this.chessimg.getWidth(), this.chessimg.getHeight() - 2);
        graphics.drawLine(0, this.chessimg.getHeight() - 1, this.canvas.getWidth() - this.chessimg.getWidth(), this.chessimg.getHeight() - 1);
    }

    public boolean drawInformation(Graphics graphics, int n, String string) {
        graphics.setColor(12439485);
        graphics.fillRect(0, (n - 1) * 24 + this.chessimg.getHeight(), this.canvas.getWidth(), 24);
        graphics.setColor(0, 0, 0);
        graphics.drawString(string, 5, (n - 1) * 24 + this.chessimg.getHeight(), 20);
        return true;
    }

    public void drawPiece(Graphics graphics, int n, int n2, int n3) {
        int n4 = n3 / 10 + n3 % 10;
        int n5 = n4 % 2 == 0 ? 0 : 1;
        n4 = n2 * 14 + n5 * 7 + n;
        graphics.drawImage(this.pieces[n4], this.getXPos(n3) + 1, this.getYPos(n3) + 1, 20);
    }

    public void drawPiece(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 * 14 + n3 * 7 + n;
        graphics.drawImage(this.pieces[n6], n4, n5, 20);
    }

    public Graphics getChessGraphics() {
        return this.chessgraph;
    }

    public int getCommand(int n, int n2) {
        int n3 = this.chessimg.getHeight() / 8;
        if (n < this.canvas.getWidth() - this.chessimg.getWidth()) {
            if (n2 < 4 * n3) {
                return 1;
            }
            if (n2 < 8 * n3) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public String getCommandName(int n) {
        return this.commands[n];
    }

    public int getFieldCode(int n, int n2) {
        int n3 = n - (this.canvas.getWidth() - this.chessimg.getWidth());
        int n4 = (n3 / (this.chessimg.getWidth() / 8) + 1) * 10;
        return n4 += (this.chessimg.getHeight() - n2) / (this.chessimg.getHeight() / 8) + 1;
    }

    private int getXPos(int n) {
        return (n / 10 - 1) * (this.chessimg.getWidth() / 8);
    }

    private int getYPos(int n) {
        return this.chessimg.getHeight() - n % 10 * this.chessimg.getHeight() / 8;
    }

    public boolean inChessBoard(int n, int n2) {
        return n > this.canvas.getWidth() - this.chessimg.getWidth() && n2 < this.chessimg.getHeight();
    }

    public boolean initializeImage(String string) {
        try {
            this.chessimg = Image.createImage((String)"/xboard.png");
            this.createSubImages(this.chessimg);
            Image image = this.chessimg;
            this.chessimg = Image.createImage((int)image.getWidth(), (int)image.getHeight());
            this.chessgraph = this.chessimg.getGraphics();
            this.chessgraph.drawImage(image, 0, 0, 20);
        }
        catch (IOException iOException) {
            CU.shout("initializeImage error" + iOException.toString());
            return false;
        }
        return true;
    }

    public boolean registerCommand(int n, String string) {
        if (n < 1 || n > 2) {
            return false;
        }
        this.commands[n] = string;
        return true;
    }

    public void selectField(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = graphics.getColor();
        graphics.setColor(n2, n3, n4);
        int n6 = this.getXPos(n);
        int n7 = this.getYPos(n);
        if (bl) {
            graphics.fillArc(n6 + 3, n7 + 1, this.chessimg.getWidth() / 8 - 5, this.chessimg.getHeight() / 8 - 4, 0, 360);
        } else {
            graphics.drawArc(n6 + 3, n7 + 1, this.chessimg.getWidth() / 8 - 5, this.chessimg.getHeight() / 8 - 4, 0, 360);
        }
        graphics.setColor(n5);
    }
}

