/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class ChessGame {
    private static final int POSTCOUNT_LIMIT = 25;
    private int postcount = 0;
    private boolean postactive = false;
    private boolean show = false;
    private boolean prevshow = false;
    private boolean loggedon = false;
    private boolean isplaying = false;
    private boolean matchissued = false;
    private boolean ischallenged = false;
    private boolean drawoffered = false;
    private String matchissue = "";
    private String challenge = "";
    private String matchreply = "";
    private ChessLogic chesslogic = null;
    private PostThread postthread = null;
    private ServletResponseReceiver servletresponsereceiver = null;
    private String status = "";

    public ChessGame(ChessLogic chessLogic, String string) {
        this.chesslogic = chessLogic;
        Random random = new Random();
        int n = random.nextInt();
        String string2 = CU.int2str(n);
        PostThread.setPostURL(string);
        PostThread.setSequenceNumber(0);
        PostThread.setMIDletID(string2);
    }

    private void adjustInternalState(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements()) {
            stringTokenizer.nextElement();
        }
        String string2 = "|";
        String string3 = "";
        if (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
        }
        while (!string2.equals("|")) {
            string3 = String.valueOf(string3) + string2 + " ";
            string2 = stringTokenizer.hasMoreElements() ? (String)stringTokenizer.nextElement() : "|";
        }
        boolean bl = false;
        while (!bl) {
            this.parseMessage(string3);
            this.show = false;
            string3 = "";
            if (stringTokenizer.hasMoreElements()) {
                string2 = (String)stringTokenizer.nextElement();
            }
            while (!string2.equals("|")) {
                string3 = String.valueOf(string3) + string2 + " ";
                string2 = stringTokenizer.hasMoreElements() ? (String)stringTokenizer.nextElement() : "|";
            }
            if (!string3.equals("") || stringTokenizer.hasMoreElements()) continue;
            bl = true;
        }
    }

    public boolean doPost(String string, boolean bl) {
        if (this.postactive) {
            return false;
        }
        ++this.postcount;
        if (this.postcount > 25 && !CU.firstToken(string).equals("logoff")) {
            this.chesslogic.alert("This is a demo-version of Fly_Chess and limited to " + CU.int2str(25) + " posts to the NotTheFly servlet. \n" + "Please 'Logoff' before exit.\nContact NotTheFly for more information." + "End of Fly_Chess demo");
            this.status = "End of Demo";
            return false;
        }
        this.postactive = true;
        this.prevshow = this.show;
        this.show = bl;
        if (this.postthread != null) {
            this.status = "Unable to send command";
            return false;
        }
        this.postthread = new PostThread(this, string);
        this.postthread.start();
        this.status = "Sending " + CU.firstToken(string) + "-command...";
        return true;
    }

    public boolean drawOffered() {
        return this.drawoffered;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isChallenged() {
        return this.ischallenged;
    }

    public boolean isPlaying() {
        return this.isplaying;
    }

    public boolean matchIssued() {
        return this.matchissued;
    }

    private void parseMessage(String string) {
        if (CU.containsExpr(string, "<12>")) {
            this.isplaying = true;
            this.chesslogic.receiveServletResponse(string);
        } else if (CU.containsExpr(string, "Style 12 set")) {
            this.loggedon = true;
        } else if (CU.containsExpr(string, "Issuing:")) {
            this.matchissued = true;
            this.matchissue = string;
            this.chesslogic.alert(string);
        } else if (CU.containsExpr(string, "Match request does not fit formula")) {
            this.matchissued = false;
            this.chesslogic.alert(string);
        } else if (CU.containsExpr(string, "Challenge:")) {
            this.ischallenged = true;
            this.challenge = string;
            if (!this.isplaying) {
                this.chesslogic.alert(string);
            }
        } else if (CU.containsExpr(string, "accepts your challenge")) {
            this.isplaying = true;
            this.matchissued = false;
            this.chesslogic.alert(string);
            this.chesslogic.getChessGame().doPost("refresh", false);
        } else if (CU.containsExpr(string, "declines the match offer")) {
            this.matchissued = false;
            this.chesslogic.alert(string);
        } else if (CU.containsExpr(string, "You accept the challenge")) {
            this.isplaying = true;
            this.ischallenged = false;
        } else if (CU.containsExpr(string, "You decline the match offer")) {
            this.isplaying = false;
            this.ischallenged = false;
        } else if (CU.containsExpr(string, "You are not playing a game") || CU.containsExpr(string, "You are neither playing, observing nor examining a game")) {
            this.isplaying = false;
            this.chesslogic.alert(string);
        } else if (CU.containsExpr(string, "Illegal move") || CU.containsExpr(string, "Not a legal move") || CU.containsExpr(string, "Your king is in check") || CU.containsExpr(string, "It isn\u2019t your turn") || CU.containsExpr(string, "It is not your move")) {
            this.chesslogic.alert(string);
        } else if (CU.containsExpr(string, "offers you a draw")) {
            this.drawoffered = true;
            this.chesslogic.alert(string);
        } else if (CU.containsExpr(string, "would like to abort")) {
            this.chesslogic.alert(string);
        } else if (CU.containsExpr(string, "{Game")) {
            this.chesslogic.reset();
            this.chesslogic.alert(string);
            this.isplaying = false;
            this.drawoffered = false;
            this.matchissued = false;
        } else if (CU.containsExpr(string, "telnet-failure")) {
            this.chesslogic.alert("telnet-failure, in case of multiple failures, please logoff and try logon again");
        } else if (CU.containsExpr(string, "Maximum number of refreshes exceeded")) {
            this.chesslogic.alert("Could not obtain new board situation, please choose 'nextstate' in MENU to try again");
        } else if (this.postactive) {
            if (this.prevshow) {
                this.chesslogic.alert(string);
            }
        } else if (this.show) {
            this.chesslogic.alert(string);
        }
    }

    public boolean postActive() {
        return this.postactive;
    }

    public synchronized void receiveServletResponse(String string) {
        this.postthread = null;
        this.postactive = false;
        this.status = "Response received...";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "|";
        String string3 = "";
        if (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
        }
        while (!string2.equals("|")) {
            string3 = String.valueOf(string3) + string2 + " ";
            string2 = stringTokenizer.hasMoreElements() ? (String)stringTokenizer.nextElement() : "|";
        }
        this.servletresponsereceiver.receiveServletResponse(string3);
        this.adjustInternalState(string);
        if (this.chesslogic.getCommandsForm().isActive() && !CU.firstToken(string).equals("who")) {
            this.chesslogic.getCommandsForm().makeCurrent(CU.getDisplay());
        }
    }

    public void setServletRedirection(ServletResponseReceiver servletResponseReceiver) {
        this.servletresponsereceiver = servletResponseReceiver;
    }

    public boolean stopPost() {
        this.status = "";
        if (this.postthread != null) {
            CU.shout("closing thread");
            try {
                this.postthread.join();
            }
            catch (Exception exception) {
                CU.shout(exception.getMessage());
                return false;
            }
            CU.shout("thread closed");
            this.postthread = null;
            return true;
        }
        return true;
    }

    public String viewChallenge() {
        return this.challenge;
    }

    public String viewMatchIssue() {
        return this.matchissue;
    }

    public String viewMatchReply() {
        return this.matchreply;
    }
}

