/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ChessLogic
implements ServletResponseReceiver {
    private boolean responsereceived = false;
    private String response = "";
    private ChessCanvas chesscanvas;
    private ChessGUI chessgui;
    private CommandsForm commandsform;
    private ChessGame chessgame = null;
    private Style12Parser currentboard = null;
    private int click = 0;
    private String movestring = "";
    private int selectfield1 = 0;
    private int selectfield2 = 0;

    public ChessLogic(ChessCanvas chessCanvas) {
        this.chesscanvas = chessCanvas;
        this.chessgui = new ChessGUI(chessCanvas);
        this.commandsform = new CommandsForm(this, chessCanvas);
        this.drawEmptyBoard();
        this.registerCommands();
    }

    public void alert(String string) {
        MessageForm messageForm = new MessageForm("Alert", string, this.commandsform);
        messageForm.makeCurrent(CU.getDisplay());
    }

    private void drawCurrentBoard() {
        if (this.currentboard == null) {
            this.drawEmptyBoard();
            return;
        }
        Graphics graphics = this.chessgui.getChessGraphics();
        int n = 8;
        while (n > 0) {
            int n2 = 1;
            while (n2 < 9) {
                int n3 = n2 * 10 + n;
                int n4 = this.currentboard.getPiecePos(n3);
                int n5 = this.currentboard.getColorPos(n3);
                this.chessgui.drawPiece(graphics, n4, n5, n3);
                ++n2;
            }
            --n;
        }
        if (this.selectfield1 != 0) {
            this.chessgui.selectField(graphics, this.selectfield1, 0, 0, 0, false);
        }
        if (this.selectfield2 != 0) {
            this.chessgui.selectField(graphics, this.selectfield2, 255, 255, 255, false);
        }
    }

    private void drawEmptyBoard() {
        Graphics graphics = this.chessgui.getChessGraphics();
        int n = 8;
        while (n > 0) {
            int n2 = 1;
            while (n2 < 9) {
                int n3 = n2 * 10 + n;
                this.chessgui.drawPiece(graphics, 0, 0, n3);
                ++n2;
            }
            --n;
        }
    }

    private void drawInformation(Graphics graphics) {
        String string = "No info";
        if (this.currentboard != null) {
            if (this.isYourMove() && this.responsereceived && !this.movestring.equals("")) {
                string = "Your move? " + this.movestring;
            }
            if (this.isYourMove() && !this.responsereceived) {
                string = "Sending move...";
            }
            if (!this.isYourMove()) {
                string = "Awaiting opponent move...";
            }
            if (this.isYourMove() && this.responsereceived && this.movestring.equals("")) {
                string = "Op. moved: " + this.currentboard.getPreviousMoveVerbose() + " your? ";
            }
        } else {
            string = "No game active";
        }
        this.chessgui.drawInformation(graphics, 1, string);
    }

    private void error(String string) {
        MessageForm messageForm = new MessageForm("Error", string, this.chesscanvas);
        messageForm.makeCurrent(CU.getDisplay());
    }

    private void executeCommand(int n) {
        if (this.chessgame == null && n == 2) {
            this.error("Please logon first");
            return;
        }
        switch (n) {
            case 1: {
                this.commandsform.makeCurrent(CU.getDisplay());
                break;
            }
            case 2: {
                this.move();
            }
        }
    }

    public ChessGame getChessGame() {
        return this.chessgame;
    }

    public CommandsForm getCommandsForm() {
        return this.commandsform;
    }

    public void handleBoardClick(int n, int n2) {
        int n3 = this.chessgui.getFieldCode(n, n2);
        switch (this.click) {
            case 0: {
                this.movestring = CU.int2alg(n3);
                this.selectfield1 = n3;
                this.selectfield2 = 0;
                ++this.click;
                break;
            }
            case 1: {
                this.movestring = String.valueOf(this.movestring) + "-" + CU.int2alg(n3);
                ++this.click;
                this.selectfield2 = n3;
                break;
            }
            case 2: {
                this.movestring = CU.int2alg(n3);
                this.click = 1;
                this.selectfield1 = n3;
                this.selectfield2 = 0;
            }
        }
    }

    public void handleClick(int n, int n2) {
        if (this.chessgui.inChessBoard(n, n2)) {
            this.handleBoardClick(n, n2);
        } else {
            this.handleCommandClick(n, n2);
        }
        this.chesscanvas.repaint();
        this.chesscanvas.serviceRepaints();
    }

    public void handleCommandClick(int n, int n2) {
        if (this.chessgui.getCommand(n, n2) != 0) {
            this.executeCommand(this.chessgui.getCommand(n, n2));
        }
    }

    private boolean isYourMove() {
        if (this.currentboard == null) {
            return false;
        }
        if (this.currentboard.getBoardOrientation() == 1 && this.currentboard.getColorToMove() == 0) {
            return true;
        }
        return this.currentboard.getBoardOrientation() == 0 && this.currentboard.getColorToMove() == 1;
    }

    private void move() {
        this.responsereceived = false;
        if (this.chessgame.postActive()) {
            this.alert("Unable to send command, still postthread active. \nStatus: " + this.chessgame.getStatus());
        } else {
            this.chessgame.doPost("move " + this.movestring, false);
            this.movestring = "";
            this.click = 0;
        }
    }

    public void paint(Graphics graphics) {
        this.drawCurrentBoard();
        graphics.setFont(null);
        Font font = graphics.getFont();
        this.chessgui.drawCommands(graphics);
        this.chessgui.drawChessGraphics(graphics);
        Font font2 = Font.getFont((int)font.getFace(), (int)0, (int)8);
        graphics.setFont(font2);
        this.drawInformation(graphics);
    }

    public void receiveServletResponse(String string) {
        this.response = string;
        this.responsereceived = true;
        Style12Parser style12Parser = new Style12Parser();
        if (style12Parser.parseStyle12(string)) {
            boolean bl = true;
            if (this.currentboard != null && this.currentboard.getPreviousMoveVerbose().equals(style12Parser.getPreviousMoveVerbose())) {
                bl = false;
            }
            this.currentboard = style12Parser;
            CU.setBoardOrientation(this.currentboard.getBoardOrientation());
            if (bl) {
                this.drawCurrentBoard();
            }
            if (this.chessgame != null && !this.isYourMove() && this.chessgame.isPlaying()) {
                this.responsereceived = false;
                this.selectfield1 = 0;
                this.selectfield2 = 0;
                this.chessgame.doPost("nextstate", false);
            }
        }
        this.chesscanvas.repaint();
        this.chesscanvas.serviceRepaints();
    }

    private void registerCommands() {
        this.chessgui.registerCommand(1, "MENU");
        this.chessgui.registerCommand(2, "MOVE");
    }

    public void reset() {
        this.currentboard = null;
        this.drawEmptyBoard();
        this.movestring = "";
        this.click = 0;
        this.selectfield1 = 0;
        this.selectfield2 = 0;
    }

    public void setChessGame(ChessGame chessGame) {
        this.chessgame = chessGame;
    }
}

