/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class CommandsForm
implements CommandListener,
ChessDisplayable,
ServletResponseReceiver {
    private boolean responsereceived = false;
    private String response = null;
    private ChessLogic chesslogic = null;
    private ChessDisplayable chessreturn = null;
    private List myScreen;
    private Command OKCommand;
    private Command backCommand;

    public CommandsForm(ChessLogic chessLogic, ChessDisplayable chessDisplayable) {
        this.chesslogic = chessLogic;
        this.chessreturn = chessDisplayable;
        this.initialize();
    }

    private void alert(String string) {
        MessageForm messageForm = new MessageForm("Alert", string, this.chessreturn);
        messageForm.makeCurrent(CU.getDisplay());
    }

    private boolean checkPostActive() {
        ChessGame chessGame = this.chesslogic.getChessGame();
        if (chessGame == null) {
            return false;
        }
        if (chessGame.postActive()) {
            this.alert("Unable to send command, still postthread active. \nStatus: " + chessGame.getStatus());
            return true;
        }
        return false;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.OKCommand || command == List.SELECT_COMMAND) {
            this.executeCommand(this.myScreen.getString(this.myScreen.getSelectedIndex()));
            return;
        }
        if (command == this.backCommand) {
            if (this.chesslogic.getChessGame() != null) {
                this.chesslogic.getChessGame().setServletRedirection(this.chesslogic);
            }
            this.chessreturn.makeCurrent(CU.getDisplay());
        }
    }

    private void executeCommand(String string) {
        ChessGame chessGame = this.chesslogic.getChessGame();
        if (chessGame != null) {
            chessGame.setServletRedirection(this);
        }
        if (string.equals("Logon")) {
            if (this.checkPostActive()) {
                return;
            }
            LogonForm logonForm = new LogonForm(this.chesslogic, this);
            logonForm.makeCurrent(CU.getDisplay());
        } else if (string.equals("Match player")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("who a", false);
        } else if (string.equals("Resign from game")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("resign", true);
        } else if (string.equals("Offer draw")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("draw", true);
        } else if (string.equals("Abort from game")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("abort", true);
        } else if (string.equals("Refresh board")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("refresh", false);
        } else if (string.equals("Nextstate")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("nextstate", false);
        } else if (string.equals("Accept draw-offer")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("accept", true);
        } else if (string.equals("Decline draw-offer")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("decline", true);
        } else if (string.equals("Review match-offer")) {
            MessageForm messageForm = new MessageForm("Match offered", chessGame.viewMatchIssue(), this);
            messageForm.makeCurrent(CU.getDisplay());
        } else if (string.equals("Accept challenge")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("accept", true);
        } else if (string.equals("Decline challenge")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("decline", true);
        } else if (string.equals("Review challenge")) {
            MessageForm messageForm = new MessageForm("Challenged by", chessGame.viewChallenge(), this);
            messageForm.makeCurrent(CU.getDisplay());
        } else if (string.equals("Poll")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("poll", false);
        } else if (string.equals("Logoff")) {
            if (this.checkPostActive()) {
                return;
            }
            chessGame.doPost("logoff", true);
            this.chesslogic.reset();
            this.chesslogic.setChessGame(null);
        } else if (string.equals("Exit")) {
            CU.exitMIDlet();
        } else if (string.equals("About")) {
            CU.displayChessMIDlet();
        } else if (string.equals("Setup Servlet URL")) {
            SetupServlet setupServlet = new SetupServlet(this.chesslogic, this);
            setupServlet.makeCurrent(CU.getDisplay());
        } else if (string.equals("Setup Chess Engine")) {
            SetupChess setupChess = new SetupChess(this.chesslogic, this);
            setupChess.makeCurrent(CU.getDisplay());
        } else if (string.equals("Post History")) {
            MessageForm messageForm = new MessageForm("Post History", PostThread.getPostHistory(), this);
            messageForm.makeCurrent(CU.getDisplay());
        }
        if (chessGame != null) {
            this.myScreen.setTitle(chessGame.getStatus());
        }
    }

    public void initialize() {
        ChessGame chessGame;
        this.myScreen = new List("Choose Command", 3);
        this.OKCommand = new Command("OK", 4, 1);
        this.backCommand = new Command("Chess", 2, 1);
        if (this.chesslogic.getChessGame() == null) {
            this.myScreen.append("Logon", null);
        } else {
            chessGame = this.chesslogic.getChessGame();
            if (!chessGame.isPlaying()) {
                this.myScreen.append("Match player", null);
            } else {
                this.myScreen.append("Resign from game", null);
                this.myScreen.append("Offer draw", null);
                this.myScreen.append("Abort from game", null);
                this.myScreen.append("Refresh board", null);
                this.myScreen.append("Nextstate", null);
                if (chessGame.drawOffered()) {
                    this.myScreen.append("Accept draw-offer", null);
                    this.myScreen.append("Decline draw-offer", null);
                }
            }
            if (chessGame.matchIssued()) {
                this.myScreen.append("Review match-offer", null);
            }
            if (chessGame.isChallenged()) {
                this.myScreen.append("Accept challenge", null);
                this.myScreen.append("Decline challenge", null);
                this.myScreen.append("Review challenge", null);
            }
            this.myScreen.append("Poll", null);
            this.myScreen.append("Logoff", null);
        }
        this.myScreen.append("Exit", null);
        this.myScreen.append("About", null);
        this.myScreen.append("Setup Servlet URL", null);
        this.myScreen.append("Setup Chess Engine", null);
        this.myScreen.append("Post History", null);
        this.myScreen.addCommand(this.OKCommand);
        this.myScreen.addCommand(this.backCommand);
        chessGame = this.chesslogic.getChessGame();
        if (chessGame != null && chessGame.postActive()) {
            this.myScreen.setTitle(chessGame.getStatus());
        }
    }

    public boolean isActive() {
        return CU.getDisplay().getCurrent() == this.myScreen;
    }

    public void makeCurrent(Display display) {
        this.initialize();
        display.setCurrent((Displayable)this.myScreen);
        this.myScreen.setCommandListener((CommandListener)this);
    }

    public void receiveServletResponse(String string) {
        this.response = string;
        if (CU.firstToken(string).equals("who")) {
            MatchForm matchForm = new MatchForm(CU.removeFirstTokens(string, 1), this.chesslogic, this);
            matchForm.makeCurrent(CU.getDisplay());
        } else if (CU.firstToken(string).equals("nextstate")) {
            if (this.chesslogic.getChessGame() != null) {
                this.chesslogic.getChessGame().setServletRedirection(this.chesslogic);
            }
            this.chessreturn.makeCurrent(CU.getDisplay());
        } else if (CU.firstToken(string).equals("refresh")) {
            if (this.chesslogic.getChessGame() != null) {
                this.chesslogic.getChessGame().setServletRedirection(this.chesslogic);
            }
            this.chessreturn.makeCurrent(CU.getDisplay());
        }
        this.responsereceived = true;
    }
}

