/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.RecordStore;

public class SetupChess
implements CommandListener,
ChessDisplayable {
    private TextField chessurl = null;
    private ChessLogic chesslogic = null;
    private ChessDisplayable chessreturn = null;
    private Form form;
    private Command OKCommand;
    private Command backCommand;

    public SetupChess(ChessLogic chessLogic, ChessDisplayable chessDisplayable) {
        this.chesslogic = chessLogic;
        this.chessreturn = chessDisplayable;
        this.initialize();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.OKCommand) {
            if (this.store()) {
                MessageForm messageForm = new MessageForm("Succes", "New URL stored", this.chessreturn);
                messageForm.makeCurrent(CU.getDisplay());
            } else {
                MessageForm messageForm = new MessageForm("Failure", "URL storage failed", this);
                messageForm.makeCurrent(CU.getDisplay());
            }
        } else {
            this.chessreturn.makeCurrent(CU.getDisplay());
        }
    }

    private void initialize() {
        this.form = new Form("Setup Chess Engine");
        String string = null;
        this.OKCommand = new Command("Store", 4, 1);
        this.backCommand = new Command("Back", 2, 1);
        this.form.append("Provide: \n");
        try {
            RecordStore recordStore = null;
            recordStore = RecordStore.openRecordStore((String)"Chess", (boolean)false);
            string = new String(recordStore.getRecord(2));
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            CU.shout("RS init: " + exception.getMessage());
            string = "";
        }
        this.chessurl = new TextField("Chess engine URL", string, 150, 4);
        this.form.append((Item)this.chessurl);
        this.form.addCommand(this.OKCommand);
        this.form.addCommand(this.backCommand);
        this.form.setCommandListener((CommandListener)this);
    }

    public void makeCurrent(Display display) {
        display.setCurrent((Displayable)this.form);
        this.form.setCommandListener((CommandListener)this);
    }

    private boolean store() {
        RecordStore recordStore = null;
        String string = this.chessurl.getString();
        try {
            recordStore = RecordStore.openRecordStore((String)"Chess", (boolean)false);
            recordStore.setRecord(2, string.getBytes(), 0, string.length());
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            CU.shout("Store exception: " + exception.getMessage());
            return false;
        }
        return true;
    }
}

