/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private char maxDelimChar;

    public StringTokenizer(String string) {
        this(string, " \t\n\r\f", false);
    }

    public StringTokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public StringTokenizer(String string, String string2, boolean bl) {
        this.str = string;
        this.maxPosition = string.length();
        this.delimiters = string2;
        this.retDelims = bl;
        this.setMaxDelimChar();
    }

    public int countTokens() {
        int n = 0;
        int n2 = this.currentPosition;
        while (n2 < this.maxPosition) {
            if ((n2 = this.skipDelimiters(n2)) >= this.maxPosition) break;
            n2 = this.scanToken(n2);
            ++n;
        }
        return n;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int n = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(n, this.currentPosition);
    }

    public String nextToken(String string) {
        this.delimiters = string;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        return this.nextToken();
    }

    private int scanToken(int n) {
        char c;
        int n2 = n;
        while (n2 < this.maxPosition) {
            c = this.str.charAt(n2);
            if (c <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0) break;
            ++n2;
        }
        if (this.retDelims && n == n2 && (c = this.str.charAt(n2)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0) {
            ++n2;
        }
        return n2;
    }

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char c = '\u0000';
        int n = 0;
        while (n < this.delimiters.length()) {
            char c2 = this.delimiters.charAt(n);
            if (c < c2) {
                c = c2;
            }
            ++n;
        }
        this.maxDelimChar = c;
    }

    private int skipDelimiters(int n) {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        while (!this.retDelims && n2 < this.maxPosition) {
            char c = this.str.charAt(n2);
            if (c > this.maxDelimChar || this.delimiters.indexOf(c) < 0) break;
            ++n2;
        }
        return n2;
    }
}

