/*
 * Decompiled with CFR 0.152.
 */
package com.mobilemedia.mmv;

import com.mobilemedia.mmv.MMVideo;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DisplayCanvas
extends Canvas
implements Runnable {
    private int FRAME_COUNT;
    private int FRAME_DELAY;
    static final int LAST_FRAME_DELAY = 3000;
    private Image movieImages = null;
    int frameWidth = 0;
    int frameHeight = 0;
    int frameIndex = 0;
    int drowX = 0;
    int drowY = 0;
    boolean running = false;
    private MMVideo parent;

    protected void showNotify() {
        if (this.movieImages != null) {
            this.frameWidth = this.movieImages.getWidth();
            this.frameHeight = this.movieImages.getHeight() / this.FRAME_COUNT;
            this.drowX = this.getWidth() / 2 - this.frameWidth / 2;
            this.drowY = this.getHeight() / 2 - this.frameHeight / 2;
        }
        this.running = true;
        this.frameIndex = 0;
        new Thread(this).start();
    }

    protected void hideNotify() {
        this.running = false;
    }

    public void run() {
        try {
            while (this.running) {
                Thread.sleep(this.frameIndex == this.FRAME_COUNT - 1 ? 3000L : (long)this.FRAME_DELAY);
                int n = this.frameIndex;
                this.frameIndex = (this.frameIndex + 1) % this.FRAME_COUNT;
                this.repaint(0, 0, this.frameWidth, this.frameHeight);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.frameWidth, this.frameHeight);
        graphics.translate(0, 0);
        graphics.clipRect(0, 0, this.frameWidth, this.frameHeight);
        graphics.drawImage(this.movieImages, 0, -(this.frameIndex * this.frameHeight), 20);
    }

    public void setFrameCount(int n) {
        this.FRAME_COUNT = n;
    }

    public void setFrameDelay(int n) {
        this.FRAME_DELAY = n;
    }

    public void setImage(Image image) {
        this.movieImages = image;
    }

    public void stop() {
        this.running = false;
    }
}

