/*
 * Decompiled with CFR 0.152.
 */
package com.mobilemedia.mmv.parser;

import com.mobilemedia.mmv.parser.DocumentValuator;
import com.mobilemedia.mmv.parser.MovieItem;
import com.mobilemedia.mmv.parser.XmlFileReader;
import com.mobilemedia.mmv.parser.XmlTagReader;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;

public class XmlParser {
    private String strStartTag;
    private String strEndTag;
    private String strData;
    private String strContent;
    private int iIndexStart = -1;
    private int iIndexEnd = -1;
    private int iStartTagLen = 0;
    private int iStartTagEndIdx = 0;
    private int iNoOfStories;
    private boolean bWellformed;
    private Vector vecNewsItems = new Vector();
    private DocumentValuator dvCheck = new DocumentValuator();
    private XmlFileReader xfrString = new XmlFileReader();

    public void runParser(InputStreamReader inputStreamReader) {
        this.xfrString.setStream(inputStreamReader);
        this.strData = this.xfrString.getDataFromStream();
        XmlTagReader xmlTagReader = new XmlTagReader();
        this.bWellformed = this.dvCheck.validate(xmlTagReader.getTags(this.strData));
        if (this.bWellformed) {
            this.iNoOfStories = this.dvCheck.getNoOfNewsItems();
            this.createNews();
        } else {
            System.out.println("Not a valid Xml Document !!!");
        }
    }

    public boolean getDocStatus() {
        return this.bWellformed;
    }

    public Vector getNews() {
        return this.vecNewsItems;
    }

    public Enumeration getAllNews() {
        return this.vecNewsItems.elements();
    }

    private void createNews() {
        int n = 0;
        while (n < this.iNoOfStories) {
            MovieItem movieItem = new MovieItem();
            movieItem.setMovieData(this.getContent("title"), this.getContent("image"), Integer.parseInt(this.getContent("frame")), Integer.parseInt(this.getContent("delay")), this.getContent("size"));
            this.vecNewsItems.addElement(movieItem);
            ++n;
        }
    }

    private String getContent(String string) {
        this.iStartTagLen = string.length() + 2;
        if (string == null) {
            System.out.println("Tag is null !");
            return null;
        }
        this.strStartTag = "<" + string + ">";
        this.strEndTag = "</" + string + ">";
        this.iIndexStart = this.strData.indexOf(this.strStartTag, this.iIndexStart);
        this.iStartTagEndIdx = this.iIndexStart + this.iStartTagLen;
        this.iIndexEnd = this.strData.indexOf(this.strEndTag, this.iStartTagEndIdx);
        if (!(this.iIndexStart != -1 & this.iIndexEnd != -1)) {
            System.out.println(" Malformed Xml Document ");
            return null;
        }
        this.strContent = this.strData.substring(this.iStartTagEndIdx, this.iIndexEnd);
        return this.strContent;
    }
}

