/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import monkey.Bird;
import monkey.Jaws;
import monkey.Monkey;
import monkey.MonkeyCanvas;
import monkey.MovingObject;
import monkey.Tree;
import monkey.Wall;

public class Matrix {
    public static final int HEIGHT = 8;
    public static final int WIDTH = 40;
    public static final int VIS_WIDTH = 12;
    public static final int VIS_HEIGHT = 8;
    public static final int CELL_EMPTY = 0;
    public static final int CELL_FILLED = 1;
    public static final int CELL_BONUS = 2;
    public static final int CELL_WALL = 4;
    public static final int CELL_KEY = 8;
    public static final int CELL_TREE = 16;
    public static final int COLUMN_EMPTY = 0;
    public static final int COLUMN_TOP_LIANA = 1;
    public static final int COLUMN_LOW_LIANA = 2;
    public static final int COLUMN_BIG_LIANA = 3;
    public static final int COLUMN_TWO_LIANAS = 4;
    public static final int COLUMN_TOP_WALL = 5;
    public static final int COLUMN_LOW_WALL = 6;
    public static final int COLUMN_TREE = 7;
    public static final int COLUMN_BANANA = 16;
    public static final int COLUMN_PLUM = 32;
    public static final int COLUMN_PEAR = 48;
    public static final int COLUMN_KEY = 64;
    public static final int COLUMN_LEVEL_0 = 256;
    public static final int COLUMN_LEVEL_1 = 512;
    public static final int COLUMN_LEVEL_2 = 1024;
    public static final int COLUMN_LEVEL_3 = 2048;
    public static final int COLUMN_LEVEL_4 = 4096;
    public static final int COLUMN_LEVEL_5 = 8192;
    public static final int COLUMN_LEVEL_6 = 16384;
    public static final int COLUMN_LEVEL_7 = 32768;
    public static final int PAINT_NONE = 0;
    public static final int PAINT_OBJECTS = 1;
    public static final int PAINT_MONKEY = 2;
    public static final int PAINT_MONKEY_AND_OBJECTS = 3;
    public static final int PAINT_SCORE = 4;
    public static final int PAINT_ALL = 8;
    private int[][] lv_matrix;
    private Image[][] lv_images;
    private Image[] lv_background;
    private Image[] lv_liana;
    private Image[] lv_bonus;
    private int lv_number_of_bonus;
    private Monkey lv_monkey;
    private int lv_step_x;
    private int lv_step_y;
    private int lv_origin_x;
    private int lv_origin_y;
    private int lv_width;
    private int lv_height;
    private int lv_paintType;
    private MonkeyCanvas lv_canvas;
    private MovingObject lv_jaws01;
    private MovingObject lv_jaws02;
    private MovingObject lv_jaws03;
    private MovingObject lv_bird01;
    private MovingObject lv_bird02;
    private Wall lv_wall;
    private Tree lv_tree;
    private Image lv_monkey_offscreen;
    private Graphics lv_monkey_offscreen_graphics;
    private Image lv_offscreen;
    private Graphics lv_offscreen_graphics;
    private Image lv_score_offscreen;
    private Graphics lv_score_offscreen_graphics;
    private int[][] lv_levels_data = new int[][]{{1, 6, 0, 3092, 1, 2611, 32801, 2098, 0, 34323, 32833, 0, 8755, 0, 2578, 40993, 0, 57875, 8209, 0}, {1, 6, 0, 0, 32785, 3090, 32817, 0, 35891, 0, 2066, 49201, 0, 2, 40993, 2578, 0, 1571, 32833, 7}, {1, 6, 0, 1, 2066, 0, 16915, 24625, 562, 32803, 0, 40977, 3122, 0, 33315, 0, 0, 3090, 32833, 7}};
    public String lv_label_score;
    public String lv_label_lifes;

    public Matrix(int n, int n2, MonkeyCanvas monkeyCanvas, String string, String string2) {
        this.lv_matrix = new int[40][8];
        this.lv_images = new Image[40][8];
        this.lv_width = n;
        this.lv_height = n2;
        this.lv_canvas = monkeyCanvas;
        this.lv_label_score = string;
        this.lv_label_lifes = string2;
        this.lv_monkey_offscreen = Image.createImage((int)40, (int)52);
        this.lv_monkey_offscreen_graphics = this.lv_monkey_offscreen.getGraphics();
        this.lv_monkey_offscreen_graphics.setColor(0xFFFFFF);
        this.lv_score_offscreen = Image.createImage((int)(this.lv_width >> 1), (int)(this.lv_height - 215));
        this.lv_score_offscreen_graphics = this.lv_score_offscreen.getGraphics();
        this.lv_offscreen = Image.createImage((int)this.lv_width, (int)this.lv_height);
        this.lv_offscreen_graphics = this.lv_offscreen.getGraphics();
        this.lv_step_x = n / 12;
        this.lv_step_y = 26;
        this.lv_monkey = new Monkey(this.lv_step_x, this.lv_step_y);
        this.loadImages();
    }

    public void newLevel(int n) {
        this.lv_origin_x = 0;
        this.lv_origin_y = 0;
        this.lv_number_of_bonus = 0;
        int n2 = 0;
        while (n2 < 40) {
            int n3 = 0;
            while (n3 < 8) {
                this.lv_matrix[n2][n3] = 0;
                this.lv_images[n2][n3] = null;
                ++n3;
            }
            ++n2;
        }
        this.lv_wall = null;
        this.lv_tree = null;
        this.lv_jaws01 = null;
        this.lv_jaws02 = null;
        this.lv_jaws03 = null;
        this.lv_bird01 = null;
        this.lv_bird02 = null;
        this.lv_monkey.resetState();
        switch (n) {
            case 0: {
                int[] nArray = new int[]{1, 25};
                this.lv_jaws01 = new Jaws(this.lv_step_x, this.lv_step_y, -1, 4, 9, -1, nArray, this, this.lv_monkey);
                int[] nArray2 = new int[]{1, 9};
                this.lv_bird01 = new Bird(this.lv_step_x, this.lv_step_y, -1, 6, 39, 19, nArray2, this, this.lv_monkey);
                int[] nArray3 = new int[]{15};
                this.lv_bird02 = new Bird(this.lv_step_x, this.lv_step_y, 1, 2, 3, 39, nArray3, this, this.lv_monkey);
                break;
            }
            case 1: {
                int[] nArray = new int[]{1, 3, 15};
                this.lv_jaws01 = new Jaws(this.lv_step_x, this.lv_step_y, -1, 4, 15, -1, nArray, this, this.lv_monkey);
                int[] nArray2 = new int[]{1, 7};
                this.lv_bird01 = new Bird(this.lv_step_x, this.lv_step_y, 1, 2, 12, 30, nArray2, this, this.lv_monkey);
                break;
            }
            case 2: {
                int[] nArray = new int[]{1, 3, 15};
                this.lv_jaws01 = new Jaws(this.lv_step_x, this.lv_step_y, -1, 4, 11, -1, nArray, this, this.lv_monkey);
                int[] nArray2 = new int[]{5, 17};
                this.lv_jaws02 = new Jaws(this.lv_step_x, this.lv_step_y, -1, 0, 37, 2, nArray2, this, this.lv_monkey);
                int[] nArray3 = new int[]{1, 9};
                this.lv_bird01 = new Bird(this.lv_step_x, this.lv_step_y, 1, 2, 14, 24, nArray3, this, this.lv_monkey);
            }
        }
        int n4 = 0;
        while (n4 < 20) {
            switch (this.lv_levels_data[n][n4] & 0xF) {
                case 0: {
                    this.createStandardBlock(n4);
                    break;
                }
                case 1: {
                    this.createStandardBlock(n4);
                    this.createTopLiana(n4);
                    break;
                }
                case 2: {
                    this.createStandardBlock(n4);
                    this.createBottomLiana(n4);
                    break;
                }
                case 3: {
                    this.createStandardBlock(n4);
                    this.createBigLiana(n4);
                    break;
                }
                case 4: {
                    this.createStandardBlock(n4);
                    this.createTopLiana(n4);
                    this.createBottomLiana(n4);
                    break;
                }
                case 5: {
                    this.createStandardBlock(n4);
                    this.createWall(n4 << 1, 4);
                    break;
                }
                case 6: {
                    this.createStandardBlock(n4);
                    this.createWall(n4 << 1, 0);
                    break;
                }
                case 7: {
                    this.createStandardBlock(n4);
                    this.createTree(n4 << 1);
                }
            }
            if ((this.lv_levels_data[n][n4] & 0xF0) != 0) {
                this.createBonus((n4 << 1) + 1, this.lv_levels_data[n][n4]);
            }
            ++n4;
        }
        if (this.lv_wall != null) {
            this.lv_wall.setNeedForOpen(this.lv_number_of_bonus);
        }
    }

    private void loadImages() {
        this.lv_background = new Image[2];
        this.lv_liana = new Image[3];
        this.lv_bonus = new Image[4];
        int n = 0;
        while (n < 2) {
            String string = "IBackground0" + (n + 1) + ".png";
            try {
                this.lv_background[n] = Image.createImage((String)("/" + string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 3) {
            String string = "ILiana0" + (n2 + 1) + ".png";
            try {
                this.lv_liana[n2] = Image.createImage((String)("/" + string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < 4) {
            String string = "IBonus0" + (n3 + 1) + ".png";
            try {
                this.lv_bonus[n3] = Image.createImage((String)("/" + string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n3;
        }
    }

    public boolean nextTick() {
        boolean bl = this.lv_jaws01 != null ? this.lv_jaws01.nextTick(this.lv_origin_x) : false;
        boolean bl2 = this.lv_jaws02 != null ? this.lv_jaws02.nextTick(this.lv_origin_x) : false;
        boolean bl3 = this.lv_jaws03 != null ? this.lv_jaws03.nextTick(this.lv_origin_x) : false;
        boolean bl4 = this.lv_bird01 != null ? this.lv_bird01.nextTick(this.lv_origin_x) : false;
        boolean bl5 = this.lv_bird02 != null ? this.lv_bird02.nextTick(this.lv_origin_x) : false;
        boolean bl6 = this.lv_wall != null ? this.lv_wall.nextTick(this.lv_origin_x) : false;
        boolean bl7 = this.lv_tree != null ? this.lv_tree.nextTick(this.lv_origin_x) : false;
        boolean bl8 = this.lv_monkey.nextTick();
        if (bl8) {
            this.lv_paintType |= 2;
        }
        if (this.lv_monkey.getState() == 12 && this.lv_tree != null) {
            this.lv_tree.strickeOnTree();
        }
        return bl || bl2 || bl3 || bl4 || bl5 || bl6 || bl7 || bl8;
    }

    public boolean isMonkeyKilled() {
        boolean bl;
        boolean bl2 = this.lv_jaws01 != null ? this.lv_jaws01.isMonkeyKilled() : false;
        boolean bl3 = this.lv_jaws02 != null ? this.lv_jaws02.isMonkeyKilled() : false;
        boolean bl4 = this.lv_jaws03 != null ? this.lv_jaws03.isMonkeyKilled() : false;
        boolean bl5 = this.lv_bird01 != null ? this.lv_bird01.isMonkeyKilled() : false;
        boolean bl6 = this.lv_bird02 != null ? this.lv_bird02.isMonkeyKilled() : false;
        boolean bl7 = this.lv_tree != null ? this.lv_tree.isMonkeyKilled() : false;
        boolean bl8 = bl = bl2 || bl3 || bl4 || bl5 || bl6 || bl7;
        if (bl) {
            this.lv_monkey.setState(8);
        }
        return bl;
    }

    public int getMonkeyX() {
        int n = (12 + this.lv_origin_x - this.lv_monkey.getX() - 1) * this.lv_step_x;
        return n;
    }

    public int getMonkeyY() {
        int n = (8 + this.lv_origin_y - this.lv_monkey.getY() - 1) * this.lv_step_y;
        return n;
    }

    private void getBonus(int n, int n2) {
        int n3 = 0;
        int n4 = n + 1;
        int n5 = n2 + 1;
        if ((this.lv_matrix[n][n2] & 2) == 2) {
            int[] nArray = this.lv_matrix[n];
            int n6 = n2;
            nArray[n6] = nArray[n6] ^ 2;
            this.lv_images[n][n2] = null;
            ++n3;
        }
        if ((this.lv_matrix[n4][n2] & 2) == 2) {
            int[] nArray = this.lv_matrix[n4];
            int n7 = n2;
            nArray[n7] = nArray[n7] ^ 2;
            this.lv_images[n4][n2] = null;
            ++n3;
        }
        if ((this.lv_matrix[n][n5] & 2) == 2) {
            int[] nArray = this.lv_matrix[n];
            int n8 = n5;
            nArray[n8] = nArray[n8] ^ 2;
            this.lv_images[n][n5] = null;
            ++n3;
        }
        if ((this.lv_matrix[n4][n5] & 2) == 2) {
            int[] nArray = this.lv_matrix[n4];
            int n9 = n5;
            nArray[n9] = nArray[n9] ^ 2;
            this.lv_images[n4][n5] = null;
            ++n3;
        }
        if (n3 != 0) {
            this.lv_canvas.incScore(n3);
            this.lv_paintType |= 4;
            if (this.lv_wall != null) {
                this.lv_wall.incForOpen(n3);
            }
        }
    }

    private void getKey(int n, int n2) {
        boolean bl = false;
        int n3 = n + 1;
        int n4 = n2 + 1;
        if ((this.lv_matrix[n][n2] & 8) == 8) {
            int[] nArray = this.lv_matrix[n];
            int n5 = n2;
            nArray[n5] = nArray[n5] ^ 8;
            this.lv_images[n][n2] = null;
            bl = true;
        } else if ((this.lv_matrix[n3][n2] & 8) == 8) {
            int[] nArray = this.lv_matrix[n3];
            int n6 = n2;
            nArray[n6] = nArray[n6] ^ 8;
            this.lv_images[n3][n2] = null;
            bl = true;
        } else if ((this.lv_matrix[n][n4] & 8) == 8) {
            int[] nArray = this.lv_matrix[n];
            int n7 = n4;
            nArray[n7] = nArray[n7] ^ 8;
            this.lv_images[n][n4] = null;
            bl = true;
        } else if ((this.lv_matrix[n3][n4] & 8) == 8) {
            int[] nArray = this.lv_matrix[n3];
            int n8 = n4;
            nArray[n8] = nArray[n8] ^ 8;
            this.lv_images[n3][n4] = null;
            bl = true;
        }
        if (bl) {
            this.lv_canvas.incScore(10);
            this.lv_paintType |= 4;
            if (this.lv_wall != null) {
                this.lv_wall.setKey(true);
            }
        }
    }

    private void createStandardBlock(int n) {
        int n2 = n << 1;
        int n3 = n2 + 1;
        this.lv_images[n2][3] = this.lv_background[0];
        this.lv_images[n3][3] = this.lv_background[0];
        this.lv_images[n2][7] = this.lv_background[0];
        this.lv_images[n3][7] = this.lv_background[0];
        this.lv_images[n2][4] = this.lv_background[1];
        this.lv_images[n3][4] = this.lv_background[1];
        this.lv_images[n2][0] = this.lv_background[1];
        this.lv_images[n3][0] = this.lv_background[1];
        this.lv_matrix[n2][0] = 0;
        this.lv_matrix[n3][0] = 0;
        this.lv_matrix[n2][4] = 0;
        this.lv_matrix[n3][4] = 0;
        this.lv_matrix[n2][1] = 1;
        this.lv_matrix[n3][1] = 1;
        this.lv_matrix[n2][2] = 1;
        this.lv_matrix[n3][2] = 1;
        this.lv_matrix[n2][3] = 1;
        this.lv_matrix[n3][3] = 1;
        this.lv_matrix[n2][5] = 1;
        this.lv_matrix[n3][5] = 1;
        this.lv_matrix[n2][6] = 1;
        this.lv_matrix[n3][6] = 1;
        this.lv_matrix[n2][7] = 1;
        this.lv_matrix[n3][7] = 1;
    }

    private void createTopLiana(int n) {
        int n2 = n << 1;
        int n3 = n2 + 1;
        this.lv_images[n2][7] = this.lv_liana[0];
        this.lv_images[n2][6] = this.lv_liana[1];
        this.lv_images[n2][5] = this.lv_liana[2];
        this.lv_images[n3][7] = null;
        this.lv_matrix[n2][5] = 0;
        this.lv_matrix[n2][6] = 0;
    }

    private void createBottomLiana(int n) {
        int n2 = n << 1;
        int n3 = n2 + 1;
        this.lv_images[n2][3] = this.lv_liana[0];
        this.lv_images[n2][2] = this.lv_liana[1];
        this.lv_images[n2][1] = this.lv_liana[2];
        this.lv_images[n3][3] = null;
        this.lv_matrix[n2][1] = 0;
        this.lv_matrix[n2][2] = 0;
    }

    private void createBigLiana(int n) {
        int n2 = n << 1;
        int n3 = n2 + 1;
        this.lv_images[n2][7] = this.lv_liana[0];
        this.lv_images[n2][6] = this.lv_liana[1];
        this.lv_images[n2][5] = this.lv_liana[1];
        this.lv_images[n2][4] = this.lv_liana[1];
        this.lv_images[n2][3] = this.lv_liana[1];
        this.lv_images[n2][2] = this.lv_liana[1];
        this.lv_images[n2][1] = this.lv_liana[2];
        this.lv_images[n3][3] = null;
        this.lv_images[n3][4] = null;
        this.lv_images[n3][7] = null;
        this.lv_matrix[n2][1] = 0;
        this.lv_matrix[n2][2] = 0;
        this.lv_matrix[n2][3] = 0;
        this.lv_matrix[n2][5] = 0;
        this.lv_matrix[n2][6] = 0;
    }

    private void createBonus(int n, int n2) {
        int n3 = ((n2 & 0xF0) >> 4) - 1;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = 0;
        while (n5 < 8) {
            if ((n4 & 1) == 1 && n3 != 3) {
                this.lv_images[n][n5] = this.lv_bonus[n3];
                int[] nArray = this.lv_matrix[n];
                int n6 = n5;
                nArray[n6] = nArray[n6] | 2;
                ++this.lv_number_of_bonus;
            }
            n4 >>= 1;
            ++n5;
        }
    }

    private void createWall(int n, int n2) {
        this.lv_wall = new Wall(this, this.lv_step_x, this.lv_step_y, n, n2, 0, 5);
        this.lv_images[n][n2] = null;
        this.lv_images[n][n2 + 1] = null;
        this.lv_images[n][n2 + 2] = null;
        this.lv_images[n][n2 + 3] = null;
    }

    private void createTree(int n) {
        this.lv_tree = new Tree(this, this.lv_monkey, this.lv_images, this.lv_step_x, this.lv_step_y, n, n, n - 14, 6);
        this.lv_matrix[n][0] = 0;
        int n2 = 0;
        while (n2 < 8) {
            this.lv_matrix[n + 1][n2] = 17;
            ++n2;
        }
        this.lv_matrix[n][4] = 1;
        this.lv_matrix[n][5] = 1;
    }

    public void createKeys() {
        int n = this.lv_canvas.getLevel();
        int n2 = 0;
        while (n2 < 20) {
            if ((this.lv_levels_data[n][n2] & 0x40) == 64) {
                int n3 = (n2 << 1) + 1;
                int n4 = this.lv_levels_data[n][n2] >> 8 & 0xFF;
                int n5 = 0;
                while (n5 < 8) {
                    if ((n4 & 1) == 1) {
                        this.lv_images[n3][n5] = this.lv_bonus[3];
                        int[] nArray = this.lv_matrix[n3];
                        int n6 = n5;
                        nArray[n6] = nArray[n6] | 8;
                    }
                    n4 >>= 1;
                    ++n5;
                }
            }
            ++n2;
        }
        this.lv_paintType |= 8;
    }

    public void left() {
        int n;
        int n2 = this.lv_monkey.getX();
        if ((this.getCell(n2 + 1, n = this.lv_monkey.getY()) & 1) != 1 && (this.getCell(n2 + 2, n) & 1) != 1) {
            int n3 = this.lv_origin_x;
            this.lv_monkey.setState(0);
            this.lv_monkey.setXY(++n2, n);
            if ((this.getCell(n2, n - 1) & 1) == 0) {
                this.lv_monkey.setState(6);
            }
            if ((this.getCell(n2 + 2, n) & 0x10) == 16) {
                this.lv_monkey.setState(9);
            }
            if (n2 - this.lv_origin_x >= 9) {
                this.lv_origin_x = n2 - 1;
                if (this.lv_origin_x > 28) {
                    this.lv_origin_x = 28;
                }
            }
            this.getBonus(n2, n);
            if (this.isMonkeyKilled()) {
                this.lv_canvas.setScreenType(7);
                this.lv_canvas.decLifes();
            } else {
                this.lv_canvas.setScreenType(2);
            }
            this.lv_paintType = n3 == this.lv_origin_x ? (this.lv_paintType |= 2) : (this.lv_paintType |= 8);
        } else if ((this.getCell(n2 + 2, n) & 4) == 4) {
            this.lv_wall.open();
        } else if ((this.getCell(n2 + 2, n) & 0x10) == 16) {
            this.lv_monkey.setState(10);
        }
    }

    public void right() {
        int n;
        int n2 = this.lv_monkey.getX();
        if ((this.getCell(n2 - 1, n = this.lv_monkey.getY()) & 1) != 1) {
            int n3 = this.lv_origin_x;
            this.lv_monkey.setState(3);
            this.lv_monkey.setXY(--n2, n);
            if ((this.getCell(n2, n - 1) & 1) == 0) {
                this.lv_monkey.setState(6);
            }
            if (n2 - this.lv_origin_x <= 1) {
                this.lv_origin_x = n2 - 12 + 3;
                if (this.lv_origin_x < 0) {
                    this.lv_origin_x = 0;
                }
            }
            this.getBonus(n2, n);
            if (this.isMonkeyKilled()) {
                this.lv_canvas.setScreenType(7);
                this.lv_canvas.decLifes();
            } else {
                if (n2 < 2 && n == 0) {
                    this.lv_canvas.winLevel();
                    return;
                }
                this.lv_canvas.setScreenType(2);
            }
            this.lv_paintType = n3 == this.lv_origin_x ? (this.lv_paintType |= 2) : (this.lv_paintType |= 8);
        } else if ((this.getCell(n2 - 1, n) & 4) == 4) {
            this.lv_wall.open();
        }
    }

    public void up() {
        int n;
        int n2 = this.lv_monkey.getX();
        if ((this.getCell(n2, (n = this.lv_monkey.getY()) + 1) & 1) != 1) {
            this.lv_monkey.setState(6);
            this.lv_monkey.setXY(n2, ++n);
            this.getBonus(n2, n);
            this.getKey(n2, n);
            if (this.isMonkeyKilled()) {
                this.lv_canvas.setScreenType(7);
                this.lv_canvas.decLifes();
            } else {
                this.lv_canvas.setScreenType(2);
            }
            this.lv_paintType |= 2;
        }
    }

    public void down() {
        int n;
        int n2 = this.lv_monkey.getX();
        if ((this.getCell(n2, (n = this.lv_monkey.getY()) - 1) & 1) != 1) {
            this.lv_monkey.setState(6);
            this.lv_monkey.setXY(n2, --n);
            if ((n == 0 || n == 4) && (this.getCell(n2, n - 1) & 1) != 0) {
                this.lv_monkey.restoreHorizState();
            }
            this.getBonus(n2, n);
            this.getKey(n2, n);
            if (this.isMonkeyKilled()) {
                this.lv_canvas.setScreenType(7);
                this.lv_canvas.decLifes();
            } else {
                this.lv_canvas.setScreenType(2);
            }
            this.lv_paintType |= 2;
        }
    }

    public int getCell(int n, int n2) {
        if (n < 0 || n > 39 || n2 < 0 || n2 > 7) {
            return 1;
        }
        return this.lv_matrix[n][n2];
    }

    public void setCell(int n, int n2, int n3) {
        this.lv_matrix[n2][n3] = n;
    }

    public void paintAll(Graphics graphics) {
        int n;
        boolean bl = true;
        Graphics graphics2 = bl ? this.lv_offscreen_graphics : graphics;
        graphics2.setColor(0xFFFFFF);
        if (MonkeyCanvas.lv_is_active) {
            graphics2.fillRect(0, 0, this.lv_width, this.lv_height);
        }
        int n2 = this.lv_origin_x == 0 ? 0 : this.lv_origin_x - 1;
        int n3 = this.lv_origin_y;
        int n4 = 12 + this.lv_origin_x;
        int n5 = 8 + this.lv_origin_y;
        int n6 = (n4 - n2 - 1) * this.lv_step_x;
        int n7 = (n5 - n3 - 1) * this.lv_step_y + 4;
        while (n2 < n4) {
            n = n3;
            int n8 = n7;
            while (n < n5) {
                if (MonkeyCanvas.lv_is_active) {
                    if (this.lv_images[n2][n] != null) {
                        graphics2.drawImage(this.lv_images[n2][n], n6, n8, 20);
                    } else {
                        graphics2.fillRect(n6, n8, 20, 26);
                    }
                }
                ++n;
                n8 -= this.lv_step_y;
            }
            ++n2;
            n6 -= this.lv_step_x;
        }
        this.lv_monkey.paint(graphics2, this.lv_origin_x, this.lv_origin_y);
        if (this.lv_wall != null) {
            this.lv_wall.paint(graphics2, this.lv_origin_x, this.lv_origin_y);
        }
        if (this.lv_jaws01 != null) {
            this.lv_jaws01.paint(graphics2, this.lv_origin_x, this.lv_origin_y);
        }
        if (this.lv_jaws02 != null) {
            this.lv_jaws02.paint(graphics2, this.lv_origin_x, this.lv_origin_y);
        }
        if (this.lv_jaws03 != null) {
            this.lv_jaws03.paint(graphics2, this.lv_origin_x, this.lv_origin_y);
        }
        if (this.lv_bird01 != null) {
            this.lv_bird01.paint(graphics2, this.lv_origin_x, this.lv_origin_y);
        }
        if (this.lv_bird02 != null) {
            this.lv_bird02.paint(graphics2, this.lv_origin_x, this.lv_origin_y);
        }
        if (this.lv_tree != null) {
            this.lv_tree.paint(graphics2, this.lv_origin_x, this.lv_origin_y);
        }
        graphics2.setColor(0);
        n = 12 * this.lv_step_x;
        if (MonkeyCanvas.lv_is_active) {
            graphics2.drawLine(0, 2, n, 2);
            graphics2.drawLine(0, 3, n, 3);
        }
        if (MonkeyCanvas.lv_is_active) {
            graphics2.drawString(this.lv_label_lifes + this.lv_canvas.getLifes(), 2, 215, 20);
            graphics2.drawString(this.lv_label_score + this.lv_canvas.getScore(), this.lv_width >> 1, 215, 20);
        }
        if (MonkeyCanvas.lv_is_active && bl) {
            graphics.drawImage(this.lv_offscreen, 0, 0, 20);
        }
    }

    public void paintObjectsAndMonkey(Graphics graphics, int n, boolean bl) {
        this.lv_paintType = 0;
        switch (n) {
            case 2: {
                this.left();
                break;
            }
            case 5: {
                this.right();
                break;
            }
            case 1: {
                this.up();
                break;
            }
            case 6: {
                this.down();
            }
        }
        if (bl && this.nextTick()) {
            if (this.isMonkeyKilled()) {
                this.lv_canvas.decLifes();
                this.lv_canvas.setScreenType(7);
                this.lv_paintType |= 3;
            } else {
                this.lv_paintType |= 1;
            }
        }
        if ((this.lv_paintType & 8) == 8) {
            this.paintAll(graphics);
        } else {
            if ((this.lv_paintType & 2) == 2) {
                graphics.setColor(0xFFFFFF);
                int n2 = this.lv_monkey.getOldX();
                int n3 = this.lv_monkey.getOldY();
                int n4 = this.lv_monkey.getX();
                int n5 = this.lv_monkey.getY();
                this.lv_monkey_offscreen_graphics.fillRect(0, 0, 40, 52);
                if (this.lv_images[n4][n5] != null) {
                    this.lv_monkey_offscreen_graphics.drawImage(this.lv_images[n4][n5], 20, 26, 20);
                }
                if (this.lv_images[n4 + 1][n5] != null) {
                    this.lv_monkey_offscreen_graphics.drawImage(this.lv_images[n4 + 1][n5], 0, 26, 20);
                }
                if (this.lv_images[n4][n5 + 1] != null) {
                    this.lv_monkey_offscreen_graphics.drawImage(this.lv_images[n4][n5 + 1], 20, 0, 20);
                }
                if (this.lv_images[n4 + 1][n5 + 1] != null) {
                    this.lv_monkey_offscreen_graphics.drawImage(this.lv_images[n4 + 1][n5 + 1], 0, 0, 20);
                }
                this.lv_monkey.paint(this.lv_monkey_offscreen_graphics);
                int n6 = -1;
                int n7 = -1;
                int n8 = -1;
                int n9 = -1;
                if (n4 > n2) {
                    n6 = n2;
                    n7 = n2;
                    n8 = n3;
                    n9 = n3 + 1;
                } else if (n4 < n2) {
                    n6 = n2 + 1;
                    n7 = n2 + 1;
                    n8 = n3;
                    n9 = n3 + 1;
                } else if (n5 > n3) {
                    n6 = n2;
                    n7 = n2 + 1;
                    n8 = n3;
                    n9 = n3;
                } else if (n5 < n3) {
                    n6 = n2;
                    n7 = n2 + 1;
                    n8 = n3 + 1;
                    n9 = n3 + 1;
                }
                if (MonkeyCanvas.lv_is_active) {
                    graphics.drawImage(this.lv_monkey_offscreen, (12 + this.lv_origin_x - n4 - 2) * this.lv_step_x, (8 + this.lv_origin_y - n5 - 2) * this.lv_step_y + 4, 20);
                }
                if (((this.lv_matrix[n4][n5] & 4) == 4 || (this.lv_matrix[n4 + 1][n5] & 4) == 4) && this.lv_wall != null) {
                    this.lv_wall.paintDoor(graphics, this.lv_origin_x, this.lv_origin_y);
                }
                if (n6 != -1) {
                    int n10 = (12 + this.lv_origin_x - n6 - 1) * this.lv_step_x;
                    int n11 = (8 + this.lv_origin_y - n8 - 1) * this.lv_step_y + 4;
                    if ((this.lv_matrix[n6][n8] & 4) == 4) {
                        if (this.lv_wall != null) {
                            this.lv_wall.paintDoor(graphics, n10, n11);
                        }
                    } else if (this.lv_images[n6][n8] != null) {
                        if (MonkeyCanvas.lv_is_active) {
                            graphics.drawImage(this.lv_images[n6][n8], n10, n11, 20);
                        }
                    } else if (MonkeyCanvas.lv_is_active) {
                        graphics.fillRect(n10, n11, 20, 26);
                    }
                    n10 = (12 + this.lv_origin_x - n7 - 1) * this.lv_step_x;
                    n11 = (8 + this.lv_origin_y - n9 - 1) * this.lv_step_y + 4;
                    if ((this.lv_matrix[n6][n8] & 4) != 4) {
                        if (this.lv_images[n7][n9] != null) {
                            if (MonkeyCanvas.lv_is_active) {
                                graphics.drawImage(this.lv_images[n7][n9], n10, n11, 20);
                            }
                        } else if (MonkeyCanvas.lv_is_active) {
                            graphics.fillRect(n10, n11, 20, 26);
                        }
                    }
                }
            }
            if ((this.lv_paintType & 1) == 1) {
                graphics.setColor(0xFFFFFF);
                if (this.lv_jaws01 != null) {
                    this.lv_jaws01.erase_and_paint(graphics, this.lv_images, this.lv_origin_x, this.lv_origin_y);
                }
                if (this.lv_jaws02 != null) {
                    this.lv_jaws02.erase_and_paint(graphics, this.lv_images, this.lv_origin_x, this.lv_origin_y);
                }
                if (this.lv_jaws03 != null) {
                    this.lv_jaws03.erase_and_paint(graphics, this.lv_images, this.lv_origin_x, this.lv_origin_y);
                }
                if (this.lv_bird01 != null) {
                    this.lv_bird01.erase_and_paint(graphics, this.lv_images, this.lv_origin_x, this.lv_origin_y);
                }
                if (this.lv_bird02 != null) {
                    this.lv_bird02.erase_and_paint(graphics, this.lv_images, this.lv_origin_x, this.lv_origin_y);
                }
                if (this.lv_tree != null) {
                    this.lv_tree.erase_and_paint(graphics, this.lv_images, this.lv_origin_x, this.lv_origin_y);
                }
                if (this.lv_wall != null) {
                    this.lv_wall.paintDoorWithCheck(graphics, this.lv_origin_x, this.lv_origin_y);
                }
            }
            if ((this.lv_paintType & 4) == 4) {
                this.lv_score_offscreen_graphics.setColor(0xFFFFFF);
                this.lv_score_offscreen_graphics.fillRect(0, 0, this.lv_width >> 1, this.lv_height - 215);
                this.lv_score_offscreen_graphics.setColor(0);
                this.lv_score_offscreen_graphics.drawString(this.lv_label_score + this.lv_canvas.getScore(), 0, 0, 20);
                graphics.drawImage(this.lv_score_offscreen, this.lv_width >> 1, 215, 20);
            }
        }
    }
}

