/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Monkey {
    public static final int LEFT_1 = 0;
    public static final int LEFT_2 = 1;
    public static final int LEFT_3 = 2;
    public static final int RIGHT_1 = 3;
    public static final int RIGHT_2 = 4;
    public static final int RIGHT_3 = 5;
    public static final int HANG_1 = 6;
    public static final int HANG_2 = 7;
    public static final int CROSS = 8;
    public static final int STRIKE_1 = 9;
    public static final int STRIKE_2 = 10;
    public static final int STRIKE_3 = 11;
    public static final int STRIKE_4 = 12;
    private int lv_state;
    private int lv_old_state;
    private int lv_last_horiz_state;
    private int lv_coord_x;
    private int lv_coord_y;
    private int lv_old_coord_x;
    private int lv_old_coord_y;
    private int lv_step_x;
    private int lv_step_y;
    private Image[] lv_images;

    public Monkey(int n, int n2) {
        this.lv_step_x = n;
        this.lv_step_y = n2;
        this.loadImages();
    }

    public void resetState() {
        this.lv_coord_x = 4;
        this.lv_coord_y = 4;
        this.lv_old_coord_x = 4;
        this.lv_old_coord_y = 4;
        this.lv_state = 0;
        this.lv_old_state = 0;
        this.lv_last_horiz_state = 0;
    }

    public int getState() {
        return this.lv_state;
    }

    public void setState(int n) {
        this.lv_old_state = this.lv_state;
        if (n == 0) {
            if (this.lv_state >= 0 && this.lv_state <= 2) {
                ++this.lv_state;
                if (this.lv_state > 2) {
                    this.lv_state = 0;
                }
            } else {
                this.lv_state = 0;
            }
            this.lv_last_horiz_state = this.lv_state;
        } else if (n == 3) {
            if (this.lv_state >= 3 && this.lv_state <= 5) {
                ++this.lv_state;
                if (this.lv_state > 5) {
                    this.lv_state = 3;
                }
            } else {
                this.lv_state = 3;
            }
            this.lv_last_horiz_state = this.lv_state;
        } else if (n == 6) {
            if (this.lv_state >= 6 && this.lv_state <= 7) {
                ++this.lv_state;
                if (this.lv_state > 7) {
                    this.lv_state = 6;
                }
            } else {
                this.lv_state = 6;
            }
        } else {
            this.lv_state = n;
        }
    }

    public boolean isStateChanged() {
        return this.lv_state != this.lv_old_state;
    }

    public void restoreHorizState() {
        this.lv_state = this.lv_last_horiz_state;
    }

    public int getX() {
        return this.lv_coord_x;
    }

    public int getY() {
        return this.lv_coord_y;
    }

    public int getOldX() {
        return this.lv_old_coord_x;
    }

    public int getOldY() {
        return this.lv_old_coord_y;
    }

    public void setXY(int n, int n2) {
        this.lv_old_coord_x = this.lv_coord_x;
        this.lv_old_coord_y = this.lv_coord_y;
        this.lv_coord_x = n;
        this.lv_coord_y = n2;
    }

    private void loadImages() {
        this.lv_images = new Image[12];
        int n = 0;
        while (n < 12) {
            String string = "IMonkey" + (n < 9 ? "0" : "") + (n + 1) + ".png";
            try {
                this.lv_images[n] = Image.createImage((String)("/" + string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
    }

    public boolean nextTick() {
        boolean bl = false;
        if (this.lv_state >= 10 && this.lv_state <= 12) {
            ++this.lv_state;
            if (this.lv_state > 12) {
                this.lv_state = 9;
            }
            bl = true;
        }
        return bl;
    }

    public void paint(Graphics graphics) {
        int n = this.lv_state <= 10 ? this.lv_state : this.lv_state - 1;
        graphics.drawImage(this.lv_images[n], 6, 8, 20);
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3;
        int n4 = this.lv_coord_x - n;
        int n5 = this.lv_coord_y - n2;
        int n6 = n3 = this.lv_state <= 10 ? this.lv_state : this.lv_state - 1;
        if (n4 >= 0 && n4 <= 10 && n5 >= 0 && n5 <= 6) {
            graphics.drawImage(this.lv_images[n3], (10 - n4) * this.lv_step_x + 6, (6 - n5) * this.lv_step_y + 12, 20);
        }
    }
}

