/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import monkey.Matrix;
import monkey.MonkeyMIDlet;
import monkey.ResourceBundle;

public class MonkeyCanvas
extends Canvas
implements Runnable {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_LOGO = 1;
    public static final int TYPE_GAME = 2;
    public static final int TYPE_GAME_FIRST = 3;
    public static final int TYPE_GAME_OVER = 4;
    public static final int TYPE_YOU_WON = 5;
    public static final int TYPE_NEW_LEVEL = 6;
    public static final int TYPE_MONKEY_KILLED = 7;
    private int lv_width;
    private int lv_height;
    private Display lv_display;
    private MonkeyMIDlet lv_parent;
    private Matrix lv_matrix;
    protected int lv_screenType;
    private Image lv_logoImage;
    private Thread lv_thread;
    protected boolean lv_isRunning;
    private boolean lv_canRestart;
    private int lv_key_pressed;
    private int lv_current_tick;
    protected int lv_level;
    private int lv_totalLevels;
    private int lv_lifes;
    private int lv_score;
    private boolean lv_paintAll;
    public static boolean lv_is_active = true;
    private ResourceBundle lv_bundle;
    private String lv_label_title;
    private String lv_label_level;
    private String lv_label_get_ready;
    private String lv_label_game_over;
    private String lv_label_you_won;
    private String lv_label_congratulations;

    public MonkeyCanvas(MonkeyMIDlet monkeyMIDlet, Display display, ResourceBundle resourceBundle) {
        this.lv_bundle = resourceBundle;
        this.lv_label_title = this.lv_bundle.getResource("label_title");
        this.lv_label_level = this.lv_bundle.getResource("label_level") + " ";
        this.lv_label_get_ready = this.lv_bundle.getResource("label_get_ready");
        this.lv_label_game_over = this.lv_bundle.getResource("label_game_over");
        this.lv_label_you_won = this.lv_bundle.getResource("label_you_won");
        this.lv_label_congratulations = this.lv_bundle.getResource("label_congratulations");
        this.lv_display = display;
        this.lv_parent = monkeyMIDlet;
        this.lv_width = this.getWidth();
        this.lv_height = this.getHeight();
        String string = this.lv_bundle.getResource("label_score") + ": ";
        String string2 = this.lv_bundle.getResource("label_lifes") + ": ";
        this.lv_matrix = new Matrix(this.lv_width, this.lv_height, this, string, string2);
        this.lv_totalLevels = 3;
        this.loadImages();
        this.lv_screenType = 1;
        this.repaint();
        this.lv_canRestart = true;
    }

    public void newGame() {
        if (this.lv_canRestart) {
            this.lv_canRestart = false;
            this.lv_isRunning = false;
            this.lv_paintAll = true;
            if (this.lv_thread != null) {
                try {
                    this.lv_thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lv_lifes = 3;
            this.lv_score = 0;
            this.newLevel();
            this.lv_isRunning = true;
            this.lv_thread = new Thread(this);
            this.lv_thread.start();
        }
    }

    public void setLevel(int n) {
        this.lv_level = n;
    }

    public void newLevel() {
        this.lv_matrix.newLevel(this.lv_level);
        this.lv_screenType = 6;
    }

    public void setScreenType(int n) {
        this.lv_screenType = n;
    }

    public int getScreenType() {
        return this.lv_screenType;
    }

    private void loadImages() {
        String string = "ILogo.png";
        try {
            this.lv_logoImage = Image.createImage((String)("/" + string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void decLifes() {
        --this.lv_lifes;
    }

    public void incScore(int n) {
        this.lv_score += n;
    }

    public void winLevel() {
        ++this.lv_level;
        if (this.lv_level == this.lv_totalLevels) {
            this.lv_screenType = 5;
        } else {
            this.newLevel();
        }
    }

    public int getLevel() {
        return this.lv_level;
    }

    public int getScore() {
        return this.lv_score;
    }

    public int getLifes() {
        return this.lv_lifes;
    }

    public void run() {
        while (Thread.currentThread() == this.lv_thread) {
            if (lv_is_active) {
                int n = this.lv_screenType;
                int n2 = 50;
                if (n == 3) {
                    if (lv_is_active) {
                        this.lv_paintAll = true;
                        this.repaint();
                        this.serviceRepaints();
                        this.lv_screenType = 2;
                    }
                    this.lv_current_tick = 0;
                } else if (n == 2) {
                    ++this.lv_current_tick;
                    if (this.lv_current_tick == 10) {
                        this.lv_current_tick = 0;
                    }
                    if ((this.lv_key_pressed != 0 || this.lv_current_tick == 0) && lv_is_active) {
                        this.lv_paintAll = false;
                        this.repaint();
                        this.serviceRepaints();
                    }
                } else if (n != 0) {
                    this.repaint();
                }
                switch (n) {
                    case 6: {
                        n2 = 2000;
                        break;
                    }
                    case 7: {
                        n2 = 2000;
                        break;
                    }
                    case 2: {
                        n2 = 50;
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        this.lv_isRunning = false;
                    }
                }
                if (!this.lv_isRunning) break;
                try {
                    Thread.sleep(n2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n == 0) continue;
                if (n == 6) {
                    this.lv_screenType = 3;
                    this.lv_canRestart = true;
                    continue;
                }
                if (n != 7) continue;
                if (this.lv_lifes == 0) {
                    this.lv_screenType = 4;
                    continue;
                }
                this.newLevel();
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (!lv_is_active) {
            return;
        }
        switch (this.lv_screenType) {
            case 1: {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, this.lv_width, this.lv_height);
                graphics.setColor(0);
                if (this.lv_logoImage != null) {
                    int n = this.lv_width - this.lv_logoImage.getWidth() >> 1;
                    int n2 = this.lv_height - this.lv_logoImage.getHeight() >> 1;
                    graphics.drawImage(this.lv_logoImage, n, n2, 20);
                    break;
                }
                Font font = Font.getFont((int)0, (int)1, (int)16);
                graphics.setFont(font);
                int n = this.lv_width - font.stringWidth(this.lv_label_title) >> 1;
                graphics.drawString(this.lv_label_title, n, this.lv_height - font.getHeight() >> 1, 20);
                font = Font.getFont((int)0, (int)0, (int)8);
                graphics.setFont(font);
                break;
            }
            case 6: {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, this.lv_width, this.lv_height);
                graphics.setColor(0);
                Font font = Font.getFont((int)0, (int)1, (int)16);
                graphics.setFont(font);
                String string = this.lv_label_level + (this.lv_level + 1);
                int n = this.lv_width - font.stringWidth(string) >> 1;
                int n3 = this.lv_width - font.stringWidth(this.lv_label_get_ready) >> 1;
                graphics.drawString(string, n, (this.lv_height >> 1) - 24, 20);
                graphics.drawString(this.lv_label_get_ready, n3, this.lv_height >> 1, 20);
                font = Font.getFont((int)0, (int)0, (int)8);
                graphics.setFont(font);
                this.drawScoreLifes(graphics);
                break;
            }
            case 4: {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, this.lv_width, this.lv_height);
                graphics.setColor(0);
                Font font = Font.getFont((int)0, (int)1, (int)16);
                graphics.setFont(font);
                int n = this.lv_width - font.stringWidth(this.lv_label_game_over) >> 1;
                graphics.drawString(this.lv_label_game_over, n, (this.lv_height >> 1) - 12, 20);
                font = Font.getFont((int)0, (int)0, (int)8);
                graphics.setFont(font);
                this.drawScoreLifes(graphics);
                break;
            }
            case 5: {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, this.lv_width, this.lv_height);
                graphics.setColor(0);
                Font font = Font.getFont((int)0, (int)1, (int)16);
                graphics.setFont(font);
                int n = this.lv_width - font.stringWidth(this.lv_label_congratulations) >> 1;
                int n4 = this.lv_width - font.stringWidth(this.lv_label_you_won) >> 1;
                graphics.drawString(this.lv_label_congratulations, n, (this.lv_height >> 1) - 24, 20);
                graphics.drawString(this.lv_label_you_won, n4, this.lv_height >> 1, 20);
                font = Font.getFont((int)0, (int)0, (int)8);
                graphics.setFont(font);
                this.drawScoreLifes(graphics);
                break;
            }
            case 2: 
            case 3: {
                if (this.lv_paintAll) {
                    this.lv_matrix.paintAll(graphics);
                } else {
                    this.lv_matrix.paintObjectsAndMonkey(graphics, this.lv_key_pressed, this.lv_current_tick == 0);
                }
                this.lv_key_pressed = 0;
            }
        }
    }

    private void drawScoreLifes(Graphics graphics) {
        graphics.drawString(this.lv_matrix.lv_label_lifes + this.getLifes(), 32, (this.lv_height >> 1) + 24, 20);
        graphics.drawString(this.lv_matrix.lv_label_score + this.getScore(), (this.lv_width >> 1) + 8, (this.lv_height >> 1) + 24, 20);
    }

    protected void showNotify() {
        lv_is_active = true;
        if (this.lv_screenType == 0) {
            this.lv_screenType = 3;
        }
    }

    protected void hideNotify() {
        lv_is_active = false;
        if (this.lv_screenType == 2 || this.lv_screenType == 3) {
            this.lv_screenType = 0;
        } else if (this.lv_screenType == 4 || this.lv_screenType == 5) {
            this.lv_screenType = 1;
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (this.lv_screenType == 2 && this.lv_key_pressed == 0) {
            int n3 = this.lv_matrix.getMonkeyX();
            int n4 = this.lv_matrix.getMonkeyY();
            this.lv_key_pressed = n2 > n4 + n3 - n ? (n2 > n + n4 - n3 ? 6 : 5) : (n2 > n + n4 - n3 ? 2 : 1);
        }
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (this.lv_screenType == 2 && this.lv_key_pressed == 0) {
            switch (n2) {
                case 2: {
                    this.lv_key_pressed = 2;
                    break;
                }
                case 5: {
                    this.lv_key_pressed = 5;
                    break;
                }
                case 1: {
                    this.lv_key_pressed = 1;
                    break;
                }
                case 6: {
                    this.lv_key_pressed = 6;
                }
            }
        }
    }
}

