/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import monkey.Matrix;
import monkey.Monkey;
import monkey.MonkeyCanvas;

public abstract class MovingObject {
    public static final int MAX_NUMBER = 10;
    public static final int LEFT = 1;
    public static final int RIGHT = -1;
    protected int lv_direction;
    private int lv_start_pos;
    private int lv_stop_pos;
    private int lv_pos_y;
    private int[][] lv_pos_x = new int[2][10];
    private int lv_cur_pos_x;
    private int[] lv_intervals;
    private int lv_current_interval;
    private int lv_current_tick;
    private int lv_number_of_jaws;
    private int lv_step_x;
    private int lv_step_y;
    private int[] lv_dx;
    private int lv_dy;
    protected Image[] lv_images;
    private Matrix lv_matrix;
    private Monkey lv_monkey;

    public MovingObject(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, Matrix matrix, Monkey monkey) {
        this.lv_step_x = n;
        this.lv_step_y = n2;
        this.lv_direction = n3;
        this.lv_pos_y = n4;
        this.lv_start_pos = n5;
        this.lv_stop_pos = n6;
        this.lv_intervals = nArray;
        this.lv_matrix = matrix;
        this.lv_monkey = monkey;
        this.lv_dx = new int[12];
        this.lv_dx[0] = 11 * this.lv_step_x;
        int n7 = 1;
        while (n7 < 12) {
            this.lv_dx[n7] = this.lv_dx[n7 - 1] - this.lv_step_x;
            ++n7;
        }
        this.lv_dy = (7 - this.lv_pos_y) * this.lv_step_y + 4;
        this.reset();
        this.loadImages();
    }

    public void reset() {
        this.lv_cur_pos_x = 0;
        this.lv_current_interval = 0;
        this.lv_current_tick = 0;
        this.lv_number_of_jaws = 0;
        int n = 0;
        while (n < 10) {
            this.lv_pos_x[0][n] = -1;
            this.lv_pos_x[1][n] = -1;
            ++n;
        }
    }

    public boolean nextTick(int n) {
        int n2;
        int n3;
        boolean bl = false;
        int n4 = this.lv_cur_pos_x;
        int n5 = 1 - this.lv_cur_pos_x;
        int n6 = 0;
        while (n6 < 10) {
            if (this.lv_pos_x[n4][n6] != -1) {
                this.lv_pos_x[n5][n6] = this.lv_pos_x[n4][n6] + this.lv_direction;
                n3 = this.lv_pos_x[n5][n6] - n;
                n2 = this.lv_pos_x[n4][n6] - n;
                if (n3 >= 0 && n3 <= 11 || n2 >= 0 && n2 <= 11) {
                    bl = true;
                }
                if (this.lv_pos_x[n5][n6] == this.lv_stop_pos) {
                    this.lv_pos_x[n5][n6] = -1;
                }
            } else if (this.lv_pos_x[n5][n6] != -1) {
                this.lv_pos_x[n5][n6] = -1;
                --this.lv_number_of_jaws;
            }
            ++n6;
        }
        if (!this.isStoppedByMonkey()) {
            ++this.lv_current_tick;
            if (this.lv_current_tick > this.lv_intervals[this.lv_current_interval]) {
                this.lv_current_tick = 0;
                ++this.lv_current_interval;
                if (this.lv_current_interval == this.lv_intervals.length) {
                    this.lv_current_interval = 0;
                }
                if (this.lv_number_of_jaws < 10) {
                    n3 = 0;
                    while (this.lv_pos_x[n5][n3] != -1) {
                        ++n3;
                    }
                    if (n3 < 10) {
                        ++this.lv_number_of_jaws;
                        this.lv_pos_x[n5][n3] = this.lv_start_pos;
                        n2 = this.lv_pos_x[n5][n3] - n;
                        if (n2 >= 0 && n2 <= 11) {
                            bl = true;
                        }
                    }
                }
            }
        }
        this.lv_cur_pos_x = n5;
        return bl;
    }

    private boolean isStoppedByMonkey() {
        int n = this.lv_monkey.getX();
        int n2 = this.lv_monkey.getY();
        return !(n != this.lv_start_pos && n + 1 != this.lv_start_pos || n2 != this.lv_pos_y && n2 + 1 != this.lv_pos_y);
    }

    public boolean isMonkeyKilled() {
        int n = this.lv_monkey.getX();
        int n2 = this.lv_monkey.getY();
        int n3 = 0;
        while (n3 < 10) {
            if (!(this.lv_pos_y != n2 && this.lv_pos_y != n2 + 1 || this.lv_pos_x[this.lv_cur_pos_x][n3] != n && this.lv_pos_x[this.lv_cur_pos_x][n3] != n + 1)) {
                this.lv_pos_x[this.lv_cur_pos_x][n3] = -1;
                return true;
            }
            ++n3;
        }
        return false;
    }

    protected abstract void loadImages();

    public void paint(Graphics graphics, int n, int n2) {
        int n3 = 0;
        while (n3 < 10) {
            int n4;
            if (this.lv_pos_x[this.lv_cur_pos_x][n3] != -1 && (n4 = this.lv_pos_x[this.lv_cur_pos_x][n3] - n) >= 0 && n4 <= 11) {
                int n5 = this.lv_pos_x[this.lv_cur_pos_x][n3] & 1;
                graphics.drawImage(this.lv_images[n5], this.lv_dx[n4], this.lv_dy, 20);
            }
            ++n3;
        }
    }

    public void erase_and_paint(Graphics graphics, Image[][] imageArray, int n, int n2) {
        graphics.setColor(0xFFFFFF);
        int n3 = 1 - this.lv_cur_pos_x;
        int n4 = 0;
        while (n4 < 10) {
            if (this.lv_pos_x[this.lv_cur_pos_x][n4] != this.lv_pos_x[n3][n4]) {
                int n5;
                if (this.lv_pos_x[n3][n4] != -1 && (n5 = this.lv_pos_x[n3][n4] - n) >= 0 && n5 <= 11) {
                    if (imageArray[this.lv_pos_x[n3][n4]][this.lv_pos_y] != null) {
                        if (MonkeyCanvas.lv_is_active) {
                            graphics.drawImage(imageArray[this.lv_pos_x[n3][n4]][this.lv_pos_y], this.lv_dx[n5], this.lv_dy, 20);
                        }
                    } else if (MonkeyCanvas.lv_is_active) {
                        graphics.fillRect(this.lv_dx[n5], this.lv_dy, 20, 20);
                    }
                }
                if (this.lv_pos_x[this.lv_cur_pos_x][n4] != -1 && (n5 = this.lv_pos_x[this.lv_cur_pos_x][n4] - n) >= 0 && n5 <= 11) {
                    int n6 = this.lv_pos_x[this.lv_cur_pos_x][n4] & 1;
                    if (MonkeyCanvas.lv_is_active) {
                        graphics.drawImage(this.lv_images[n6], this.lv_dx[n5], this.lv_dy, 20);
                    }
                }
            }
            ++n4;
        }
    }
}

