/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import monkey.Matrix;
import monkey.Monkey;
import monkey.MonkeyCanvas;

public class Tree {
    public static final int BIRD_IN_NEST = 1;
    public static final int BIRD_IS_FLYING = 2;
    public static final int BIRD_IS_RETURNING = 3;
    private int lv_state;
    private int lv_tree_x;
    private int lv_bird_x;
    private int lv_bird_old_x;
    private int lv_bird_y;
    private int lv_step_x;
    private int lv_step_y;
    private int lv_bird_start_x;
    private int lv_bird_stop_x;
    private Matrix lv_matrix;
    private Monkey lv_monkey;
    private static Image[] lv_tree;
    private static Image[] lv_nest;
    private static Image[] lv_bird;

    public Tree(Matrix matrix, Monkey monkey, Image[][] imageArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.lv_matrix = matrix;
        this.lv_monkey = monkey;
        this.lv_step_x = n;
        this.lv_step_y = n2;
        this.lv_tree_x = n3;
        this.lv_bird_x = -1;
        this.lv_bird_old_x = -1;
        this.lv_bird_y = n6;
        this.lv_bird_start_x = n4;
        this.lv_bird_stop_x = n5;
        this.lv_state = 1;
        int n7 = 0;
        while (n7 < 6) {
            imageArray[this.lv_tree_x][n7] = lv_tree[11 - n7];
            imageArray[this.lv_tree_x + 1][n7] = lv_tree[5 - n7];
            ++n7;
        }
    }

    private static void loadImages() {
        lv_tree = new Image[12];
        lv_nest = new Image[2];
        lv_bird = new Image[4];
        int n = 0;
        while (n < 12) {
            String string = "ITree" + (n < 9 ? "0" : "") + (n + 1) + ".png";
            try {
                Tree.lv_tree[n] = Image.createImage((String)("/" + string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 2) {
            String string = "INest0" + (n2 + 1) + ".png";
            try {
                Tree.lv_nest[n2] = Image.createImage((String)("/" + string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < 4) {
            String string = "IBird0" + (n3 + 1) + ".png";
            try {
                Tree.lv_bird[n3] = Image.createImage((String)("/" + string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n3;
        }
    }

    public boolean nextTick(int n) {
        boolean bl = false;
        this.lv_bird_old_x = this.lv_bird_x--;
        if (this.lv_state == 1) {
            int n2 = this.lv_monkey.getX();
            int n3 = this.lv_monkey.getY();
            if (n2 == this.lv_tree_x - 2 && (n3 == this.lv_bird_y - 1 || n3 == this.lv_bird_y)) {
                this.lv_state = 2;
                this.lv_bird_x = this.lv_bird_start_x;
                bl = true;
            }
        } else if (this.lv_state == 2) {
            int n4 = this.lv_bird_x - n;
            if (n4 >= -1 && n4 <= 11) {
                bl = true;
            }
            if (this.lv_bird_x == this.lv_bird_stop_x) {
                this.lv_state = 3;
            }
        } else if (this.lv_state == 3) {
            ++this.lv_bird_x;
            int n5 = this.lv_bird_x - n;
            if (n5 >= 0 && n5 <= 11) {
                bl = true;
            }
            if (this.lv_bird_x == this.lv_bird_start_x) {
                this.lv_bird_x = -1;
                this.lv_state = 1;
            }
        }
        return bl;
    }

    public boolean isMonkeyKilled() {
        int n = this.lv_monkey.getX();
        int n2 = this.lv_monkey.getY();
        if (!(this.lv_bird_y != n2 && this.lv_bird_y != n2 + 1 || this.lv_bird_x != n && this.lv_bird_x != n + 1)) {
            this.lv_bird_x = -1;
            return true;
        }
        return false;
    }

    public void strickeOnTree() {
        if (this.lv_state == 1) {
            this.lv_state = 2;
            this.lv_bird_x = this.lv_bird_start_x;
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        this.paintBird(graphics, n, n2);
    }

    public void paintBird(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5 = this.lv_tree_x - n;
        if (n5 >= 0 && n5 <= 11) {
            n4 = (10 - n5) * this.lv_step_x + 15;
            n3 = this.lv_step_y << 1;
            if (MonkeyCanvas.lv_is_active) {
                if (this.lv_state == 1) {
                    graphics.drawImage(lv_nest[0], n4, n3, 20);
                } else {
                    graphics.drawImage(lv_nest[1], n4, n3, 20);
                }
            }
        }
        if ((this.lv_state == 2 || this.lv_state == 3) && this.lv_bird_x != -1) {
            n4 = this.lv_bird_x - n;
            n3 = this.lv_bird_y - n2;
            if (n4 >= 0 && n4 <= 11) {
                int n6 = (11 - n4) * this.lv_step_x;
                int n7 = (7 - n3) * this.lv_step_y + 4;
                int n8 = (this.lv_state == 2 ? 2 : 0) + (this.lv_bird_x & 1);
                if (MonkeyCanvas.lv_is_active) {
                    graphics.drawImage(lv_bird[n8], n6, n7, 20);
                }
            }
        }
    }

    public void erase_and_paint(Graphics graphics, Image[][] imageArray, int n, int n2) {
        if (this.lv_bird_x == this.lv_bird_old_x) {
            return;
        }
        this.paintBird(graphics, n, n2);
        graphics.setColor(0xFFFFFF);
        int n3 = this.lv_bird_old_x - n;
        int n4 = this.lv_bird_y - n2;
        if (n3 >= 0 && n3 <= 11) {
            int n5 = (11 - n3) * this.lv_step_x;
            int n6 = (7 - n4) * this.lv_step_y + 4;
            if (MonkeyCanvas.lv_is_active) {
                if (imageArray[this.lv_bird_old_x][this.lv_bird_y] != null) {
                    graphics.drawImage(imageArray[this.lv_bird_old_x][this.lv_bird_y], n5, n6, 20);
                } else {
                    graphics.fillRect(n5, n6, 20, 20);
                }
            }
        }
    }

    static {
        Tree.loadImages();
    }
}

