/*
 * Decompiled with CFR 0.152.
 */
package monkey;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import monkey.Matrix;
import monkey.MonkeyCanvas;

public class Wall {
    public static final int CLOSED = 0;
    public static final int OPENED = 2;
    private int lv_old_state;
    private int lv_state;
    private boolean lv_is_opening;
    private boolean lv_is_closing;
    private int lv_pos_x;
    private int lv_pos_y;
    private int lv_step_x;
    private int lv_step_y;
    private int lv_need_for_open;
    private int lv_have_for_open;
    private boolean lv_has_key;
    private Matrix lv_matrix;
    private static Image lv_wall;
    private static Image[] lv_door;

    public Wall(Matrix matrix, int n, int n2, int n3, int n4, int n5, int n6) {
        this.lv_matrix = matrix;
        this.lv_step_x = n;
        this.lv_step_y = n2;
        this.lv_pos_x = n3;
        this.lv_pos_y = n4;
        this.lv_old_state = this.lv_state = n5;
        this.lv_has_key = false;
        this.lv_need_for_open = n6;
        this.lv_have_for_open = 0;
        this.lv_is_opening = false;
        this.lv_is_closing = false;
        if (this.lv_state == 0) {
            this.lv_matrix.setCell(5, this.lv_pos_x, this.lv_pos_y);
        } else {
            this.lv_matrix.setCell(4, this.lv_pos_x, this.lv_pos_y);
        }
    }

    private static void loadImages() {
        lv_door = new Image[3];
        String string = "IWall01.png";
        try {
            lv_wall = Image.createImage((String)("/" + string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n = 0;
        while (n < 3) {
            String string2 = "IDoor0" + (n + 1) + ".png";
            try {
                Wall.lv_door[n] = Image.createImage((String)("/" + string2));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
    }

    public boolean nextTick(int n) {
        int n2;
        boolean bl = false;
        this.lv_old_state = this.lv_state++;
        if (this.lv_is_opening) {
            if (this.lv_state == 2) {
                this.lv_is_opening = false;
                this.lv_matrix.setCell(4, this.lv_pos_x, this.lv_pos_y);
            }
            bl = true;
        } else if (this.lv_is_closing) {
            --this.lv_state;
            if (this.lv_state == 0) {
                this.lv_is_closing = false;
                this.lv_matrix.setCell(5, this.lv_pos_x, this.lv_pos_y);
            }
            bl = true;
        }
        if (bl && ((n2 = this.lv_pos_x - n) < 0 || n2 > 11)) {
            bl = false;
        }
        return bl;
    }

    public boolean hasKey() {
        return this.lv_has_key;
    }

    public void setKey(boolean bl) {
        this.lv_has_key = bl;
    }

    public void incForOpen(int n) {
        this.lv_have_for_open += n;
        if (this.lv_have_for_open >= this.lv_need_for_open) {
            this.lv_have_for_open = 0;
            this.lv_matrix.createKeys();
        }
    }

    public void setNeedForOpen(int n) {
        this.lv_need_for_open = n;
    }

    public void open() {
        if (this.lv_state == 0 && this.lv_has_key) {
            this.lv_is_opening = true;
        }
    }

    public void close() {
        if (this.lv_state == 2) {
            this.lv_is_closing = true;
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3 = this.lv_pos_x - n;
        int n4 = this.lv_pos_y - n2;
        if (n3 >= 0 && n3 <= 11 && n4 >= 0 && n4 <= 4) {
            int n5 = (11 - n3) * this.lv_step_x;
            int n6 = (4 - n4) * this.lv_step_y + 4;
            if (MonkeyCanvas.lv_is_active) {
                graphics.drawImage(lv_wall, n5, n6, 20);
                graphics.drawImage(lv_door[this.lv_state], n5, n6 + 52, 20);
            }
        }
    }

    public void paintDoorWithCheck(Graphics graphics, int n, int n2) {
        if (this.lv_state != this.lv_old_state) {
            this.paintDoor(graphics, n, n2);
            this.lv_old_state = this.lv_state;
        }
    }

    public void paintDoor(Graphics graphics, int n, int n2) {
        int n3 = this.lv_pos_x - n;
        int n4 = this.lv_pos_y - n2;
        if (n3 >= 0 && n3 <= 11 && n4 >= 0 && n4 <= 4) {
            int n5 = (11 - n3) * this.lv_step_x;
            int n6 = (4 - n4) * this.lv_step_y + 4;
            if (MonkeyCanvas.lv_is_active) {
                graphics.drawImage(lv_door[this.lv_state], n5, n6 + 52, 20);
            }
        }
    }

    public void paintDoor(Graphics graphics) {
        if (MonkeyCanvas.lv_is_active) {
            graphics.drawImage(lv_door[this.lv_state], 0, 0, 20);
        }
    }

    static {
        Wall.loadImages();
    }
}

