/*
 * Decompiled with CFR 0.152.
 */
package Game;

import java.io.IOException;
import java.io.InputStream;

public class Board {
    private int level;
    private byte[] array;
    private byte[] pathmap;
    private int width;
    private int height;
    private int pusher;
    private int packets = 0;
    private int stored = 0;
    private byte[] moves = new byte[200];
    private int nmoves;
    private int npushes;
    public static final int LEFT = 0;
    public static final int RIGHT = 3;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int MOVEPACKET = 4;
    public static final byte GROUND = 0;
    public static final byte STORE = 1;
    public static final byte PACKET = 2;
    public static final byte WALL = 4;
    public static final byte PUSHER = 8;

    public Board() {
        this.screen0();
    }

    public void screen0() {
        this.width = 9;
        this.height = 7;
        this.array = new byte[this.width * this.height];
        this.level = 0;
        this.nmoves = 0;
        this.npushes = 0;
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                byte t = x == 0 || y == 0 || x == this.width - 1 || y == this.height - 1 ? (byte)4 : 0;
                this.set(x, y, t);
                ++y;
            }
            ++x;
        }
        this.packets = 2;
        this.stored = 0;
        this.set(2, 2, (byte)2);
        this.set(4, 4, (byte)2);
        this.set(4, 2, (byte)1);
        this.set(6, 4, (byte)1);
        this.pusher = this.index(1, 1);
    }

    public int move(int move) {
        int obj = this.pusher + this.indexOffset(move);
        if ((this.array[obj] & 4) != 0) {
            return -1;
        }
        int m = this.movePacket(obj, move);
        if (m < 0) {
            return -1;
        }
        this.pusher = obj;
        this.saveMove(m);
        return m;
    }

    private int movePacket(int index, int move) {
        if ((this.array[index] & 2) == 0) {
            return move;
        }
        int dest = index + this.indexOffset(move);
        if (this.array[dest] > 1) {
            return -1;
        }
        int n = index;
        this.array[n] = (byte)(this.array[n] & 0xFFFFFFFD);
        if ((this.array[index] & 1) != 0) {
            --this.stored;
        }
        int n2 = dest;
        this.array[n2] = (byte)(this.array[n2] | 2);
        if ((this.array[dest] & 1) != 0) {
            ++this.stored;
        }
        ++this.npushes;
        return move + 4;
    }

    private void saveMove(int move) {
        if (this.nmoves >= this.moves.length) {
            byte[] n = new byte[this.moves.length + 50];
            System.arraycopy(this.moves, 0, n, 0, this.moves.length);
            this.moves = n;
        }
        this.moves[this.nmoves++] = (byte)move;
    }

    public int undoMove() {
        if (this.nmoves <= 0) {
            return -1;
        }
        byte move = this.moves[--this.nmoves];
        int rev = move & 3 ^ 3;
        int back = this.pusher + this.indexOffset(rev);
        if ((move & 4) != 0) {
            --this.npushes;
            this.movePacket(this.pusher + this.indexOffset(move), rev);
        }
        this.pusher = back;
        return move;
    }

    public boolean solved() {
        return this.packets == this.stored;
    }

    public int runTo(int x, int y, int max) {
        int target = this.index(x, y);
        if (target < 0 || target >= this.array.length) {
            return -1;
        }
        if (target == this.pusher) {
            return -1;
        }
        if (this.pathmap == null || this.pathmap.length != this.array.length) {
            this.pathmap = new byte[this.array.length];
        }
        int i = 0;
        while (i < this.pathmap.length) {
            this.pathmap[i] = 127;
            ++i;
        }
        this.findTarget(target, (byte)0);
        if (this.pathmap[this.pusher] == 127) {
            return -1;
        }
        int pathlen = this.pathmap[this.pusher];
        int pathmin = pathlen - max;
        int dir = -1;
        --pathlen;
        while (pathlen >= pathmin) {
            if (this.pathmap[this.pusher - 1] == pathlen) {
                dir = 0;
                this.saveMove(dir);
                --this.pusher;
            } else if (this.pathmap[this.pusher + 1] == pathlen) {
                dir = 3;
                this.saveMove(dir);
                ++this.pusher;
            } else if (this.pathmap[this.pusher - this.width] == pathlen) {
                dir = 1;
                this.saveMove(dir);
                this.pusher -= this.width;
            } else if (this.pathmap[this.pusher + this.width] == pathlen) {
                dir = 2;
                this.saveMove(dir);
                this.pusher += this.width;
            } else {
                throw new RuntimeException("runTo abort");
            }
            --pathlen;
        }
        return dir;
    }

    private void findTarget(int t, byte pathlen) {
        if (this.array[t] > 1) {
            return;
        }
        if (this.pathmap[t] <= pathlen) {
            return;
        }
        byte by = pathlen;
        pathlen = (byte)(pathlen + 1);
        this.pathmap[t] = by;
        if (t == this.pusher) {
            return;
        }
        this.findTarget(t - 1, pathlen);
        this.findTarget(t + 1, pathlen);
        this.findTarget(t - this.width, pathlen);
        this.findTarget(t + this.width, pathlen);
    }

    public byte get(int x, int y) {
        int offset = this.index(x, y);
        if (offset == this.pusher) {
            return (byte)(this.array[offset] | 8);
        }
        return this.array[offset];
    }

    private void set(int x, int y, byte value) {
        this.array[this.index((int)x, (int)y)] = value;
    }

    private int index(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return -1;
        }
        return y * this.width + x;
    }

    public int getPusherLocation() {
        int x = this.pusher % this.width;
        int y = this.pusher / this.width;
        return (y << 16) + x;
    }

    private int indexOffset(int move) {
        switch (move & 3) {
            case 0: {
                return -1;
            }
            case 3: {
                return 1;
            }
            case 1: {
                return -this.width;
            }
            case 2: {
                return this.width;
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void read(InputStream is, int l) {
        byte[] b = new byte[400];
        int w = 0;
        int x = 0;
        int y = 0;
        int xn = 0;
        int yn = 0;
        int npackets = 0;
        try {
            int c;
            while ((c = is.read()) != -1) {
                void var6_10;
                switch (var6_10) {
                    case 10: {
                        if (x > w) {
                            w = x;
                        }
                        ++y;
                        x = 0;
                        break;
                    }
                    case 36: {
                        b[y * 20 + x++] = 2;
                        ++npackets;
                        break;
                    }
                    case 35: {
                        b[y * 20 + x++] = 4;
                        break;
                    }
                    case 32: {
                        b[y * 20 + x++] = 0;
                        break;
                    }
                    case 46: {
                        b[y * 20 + x++] = 1;
                        break;
                    }
                    case 43: {
                        b[y * 20 + x++] = 1;
                    }
                    case 64: {
                        xn = x++;
                        yn = y;
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (y > 0) {
            this.array = new byte[w * y];
            if (y > w) {
                this.width = y;
                this.height = w;
                y = 0;
                while (y < this.width) {
                    x = 0;
                    while (x < w) {
                        this.array[this.index((int)y, (int)x)] = b[y * 20 + x];
                        ++x;
                    }
                    ++y;
                }
                this.pusher = this.index(yn, xn);
            } else {
                this.width = w;
                this.height = y;
                this.array = new byte[this.width * this.height];
                y = 0;
                while (y < this.height) {
                    x = 0;
                    while (x < this.width) {
                        this.array[this.index((int)x, (int)y)] = b[y * 20 + x];
                        ++x;
                    }
                    ++y;
                }
                this.pusher = this.index(xn, yn);
            }
            this.stored = 0;
            this.packets = npackets;
            this.level = l;
            this.nmoves = 0;
            this.npushes = 0;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMoves() {
        return this.nmoves;
    }

    public int getPushes() {
        return this.npushes;
    }

    private int dx(int dir) {
        if (dir == 0) {
            return -1;
        }
        if (dir == 3) {
            return 1;
        }
        return 0;
    }

    private int dy(int dir) {
        if (dir == 1) {
            return -1;
        }
        if (dir == 2) {
            return 1;
        }
        return 0;
    }
}

