/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.PushPuzzleCanvas;
import Game.Score;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.midlet.MIDlet;

public class PushPuzzle
extends MIDlet
implements CommandListener {
    Display display;
    private PushPuzzleCanvas canvas;
    private Score score;
    private Screen scoreScreen;
    private Screen levelScreen;
    private Alert alert;
    private Command undoCommand = new Command("Undo", 2, 1);
    private Command restartCommand = new Command("Start Over", 3, 21);
    private Command exitCommand = new Command("Exit", 7, 60);
    private Command scoresCommand = new Command("Show Scores", 1, 25);
    private Command okCommand = new Command("OK", 4, 30);
    private Command levelCommand = new Command("Change Level", 4, 24);
    private Command nextCommand = new Command("Next Level", 1, 22);
    private Command prevCommand = new Command("Previous Level", 1, 23);
    private Command aboutCommand = new Command("About", 5, 30);

    public PushPuzzle() {
        this.display = Display.getDisplay((MIDlet)this);
        this.score = new Score();
        this.canvas = new PushPuzzleCanvas(this, this.score);
        this.alert = new Alert("Warning");
    }

    public void startApp() {
        if (!this.score.open()) {
            System.out.println("Score open failed");
        }
        this.canvas.init();
        this.canvas.addCommand(this.undoCommand);
        this.canvas.addCommand(this.scoresCommand);
        this.canvas.addCommand(this.restartCommand);
        this.canvas.addCommand(this.levelCommand);
        this.canvas.addCommand(this.exitCommand);
        this.canvas.addCommand(this.nextCommand);
        this.canvas.addCommand(this.prevCommand);
        this.canvas.setCommandListener(this);
        this.display.setCurrent((Displayable)this.canvas);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.display.setCurrent(null);
        this.canvas.destroy();
        if (this.score != null) {
            this.score.close();
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.undoCommand) {
            this.canvas.undoMove();
        } else if (c == this.restartCommand) {
            this.canvas.restartLevel();
        } else if (c == this.levelCommand) {
            this.levelScreen = this.canvas.getLevelScreen();
            this.levelScreen.addCommand(this.okCommand);
            this.levelScreen.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.levelScreen);
        } else if (c == this.okCommand && s == this.levelScreen) {
            if (!this.canvas.gotoLevel()) {
                this.alert.setString("Could not load level");
                this.display.setCurrent(this.alert, (Displayable)this.canvas);
            } else {
                this.display.setCurrent((Displayable)this.canvas);
            }
        } else if (c == this.scoresCommand) {
            this.scoreScreen = this.canvas.getScoreScreen();
            this.scoreScreen.addCommand(this.okCommand);
            this.scoreScreen.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.scoreScreen);
        } else if (c == this.okCommand && s == this.scoreScreen) {
            this.display.setCurrent((Displayable)this.canvas);
        } else if (c == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (c == List.SELECT_COMMAND && s == this.canvas) {
            this.scoreScreen = this.canvas.getScoreScreen();
            this.scoreScreen.addCommand(this.okCommand);
            this.scoreScreen.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.scoreScreen);
            this.canvas.nextLevel(1);
        } else if (c == this.nextCommand) {
            if (!this.canvas.nextLevel(1)) {
                this.alert.setString("Could not load level " + (this.canvas.getLevel() + 1));
                this.display.setCurrent(this.alert, (Displayable)this.canvas);
            } else {
                this.display.setCurrent((Displayable)this.canvas);
            }
            if (s == this.canvas) {
                this.canvas.repaint();
            }
        } else if (c == this.prevCommand) {
            if (!this.canvas.nextLevel(-1)) {
                this.alert.setString("Could not load level " + (this.canvas.getLevel() - 1));
                this.display.setCurrent(this.alert, (Displayable)this.canvas);
            } else {
                this.display.setCurrent((Displayable)this.canvas);
            }
            if (s == this.canvas) {
                this.canvas.repaint();
            }
        } else {
            System.out.println("Unknown command issued " + c);
        }
    }
}

