/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.Board;
import Game.PushPuzzle;
import Game.PushPuzzleTimer;
import Game.Score;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

class PushPuzzleCanvas
extends Canvas {
    private int level = 1;
    private boolean solved;
    private int cell = 1;
    private int w;
    private int h;
    private int bwidth;
    private int bheight;
    private Board board;
    private Score score;
    private PushPuzzle pushpuzzle;
    private Display display;
    private Timer timer;
    private TimerTask timertask;
    private CommandListener listener;
    private Form scoreForm;
    private TextBox levelText;
    private static int wallColor = 0x7F7F7F;
    private static int groundColor = 0xFFFFFF;
    private static int packetColor = 0;
    private static int storeColor = 0;
    private static int pusherColor = 0;
    private static boolean useDottedLine = false;

    public PushPuzzleCanvas(PushPuzzle pushpuzzle, Score s) {
        this.pushpuzzle = pushpuzzle;
        this.display = Display.getDisplay((MIDlet)pushpuzzle);
        this.score = s;
        this.board = new Board();
        this.initColors();
    }

    public void init() {
        this.h = this.getHeight();
        this.w = this.getWidth();
        this.level = this.score.getLevel();
        if (!this.readScreen(this.level)) {
            this.level = 0;
            this.readScreen(this.level);
        }
        this.repaint();
    }

    public void destroy() {
        this.cancelTo();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void initColors() {
        boolean isColor = this.display.isColor();
        int numColors = this.display.numColors();
        if (isColor) {
            this.setColors(27989, 0xFFFFFF, 16739584, 11927637, 0x6D6DFF);
        } else if (numColors > 2) {
            this.setColors(0x999999, 0xFFFFFF, 0x666666, 0xBBBBBB, 0);
        } else {
            this.setColors(0x6A6A6A, 0xFFFFFF, 0x6A6A6A, 0, 0);
            useDottedLine = true;
        }
    }

    private void setColors(int w, int g, int pa, int s, int pu) {
        if (w != -1) {
            wallColor = w;
        }
        if (g != -1) {
            groundColor = g;
        }
        if (pa != -1) {
            packetColor = pa;
        }
        if (s != -1) {
            storeColor = s;
        }
        if (pu != -1) {
            pusherColor = pu;
        }
    }

    private int parseColor(String s) {
        if (s == null) {
            return -1;
        }
        return Integer.parseInt(s, 16);
    }

    public void undoMove() {
        int dir = this.board.undoMove();
        if (dir >= 0) {
            this.repaintNear(this.board.getPusherLocation(), dir);
        }
        this.solved = this.board.solved();
    }

    public void restartLevel() {
        this.readScreen(this.level);
        this.repaint();
        this.solved = false;
    }

    public boolean nextLevel(int offset) {
        this.updateScores();
        if (this.level + offset >= 0 && this.readScreen(this.level + offset)) {
            this.level += offset;
            this.score.setLevel(this.level);
            this.solved = false;
            return true;
        }
        return false;
    }

    public int getLevel() {
        return this.level;
    }

    public Screen getLevelScreen() {
        if (this.levelText == null) {
            this.levelText = new TextBox("Enter Level", Integer.toString(this.level), 4, 2);
        } else {
            this.levelText.setString(Integer.toString(this.level));
        }
        return this.levelText;
    }

    public boolean gotoLevel() {
        if (this.levelText != null) {
            String s = this.levelText.getString();
            int l = Integer.parseInt(s);
            this.updateScores();
            if (l >= 0 && this.readScreen(l)) {
                this.level = l;
                this.score.setLevel(this.level);
                this.solved = false;
                this.repaint();
                return true;
            }
        }
        return false;
    }

    private boolean readScreen(int lev) {
        if (lev <= 0) {
            this.board.screen0();
        } else {
            InputStream is = null;
            try {
                is = ((Object)((Object)this)).getClass().getResourceAsStream("/Game/data/screen." + lev);
                if (is == null) {
                    System.out.println("Could not find the game board for level " + lev);
                    return false;
                }
                this.board.read(is, lev);
                is.close();
            }
            catch (IOException ex) {
                return false;
            }
        }
        this.bwidth = this.board.getWidth();
        this.bheight = this.board.getHeight();
        this.cell = (this.h - 14) / this.bheight < this.w / this.bwidth ? (this.h - 14) / this.bheight : this.w / this.bwidth;
        return true;
    }

    public Screen getScoreScreen() {
        Form scoreForm = null;
        int currPushes = this.board.getPushes();
        int bestPushes = this.score.getPushes();
        int currMoves = this.board.getMoves();
        int bestMoves = this.score.getMoves();
        boolean newbest = this.solved && (bestPushes == 0 || currPushes < bestPushes);
        scoreForm = new Form(null);
        scoreForm.append((Item)new StringItem(newbest ? "New Best:\n" : "Current:\n", currPushes + " pushes\n" + currMoves + " moves"));
        scoreForm.append((Item)new StringItem(newbest ? "Old Best:\n" : "Best:\n", bestPushes + " pushes\n" + bestMoves + " moves"));
        String title = "Scores";
        if (newbest) {
            title = "Congratulations";
        }
        scoreForm.setTitle(title);
        return scoreForm;
    }

    protected void keyRepeated(int keyCode) {
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.keyPressed(keyCode);
                break;
            }
        }
    }

    protected void keyPressed(int keyCode) {
        boolean newlySolved = false;
        Board board = this.board;
        synchronized (board) {
            this.cancelTo();
            int action = this.getGameAction(keyCode);
            int move = 0;
            switch (action) {
                case 2: {
                    move = 0;
                    break;
                }
                case 5: {
                    move = 3;
                    break;
                }
                case 6: {
                    move = 2;
                    break;
                }
                case 1: {
                    move = 1;
                    break;
                }
                default: {
                    return;
                }
            }
            int pos = this.board.getPusherLocation();
            int dir = this.board.move(move);
            this.repaintNear(pos, dir);
            if (!this.solved && this.board.solved()) {
                this.solved = true;
                newlySolved = true;
            }
        }
        if (newlySolved && this.listener != null) {
            this.listener.commandAction(List.SELECT_COMMAND, (Displayable)this);
        }
    }

    private void updateScores() {
        if (!this.solved) {
            return;
        }
        int sp = this.score.getPushes();
        int bp = this.board.getPushes();
        int bm = this.board.getMoves();
        if (sp == 0 || bp < sp) {
            this.score.setLevelScore(bp, bm);
        }
    }

    private void animateTo(int x, int y) {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        if (this.timertask != null) {
            this.timertask.cancel();
            this.timertask = null;
        }
        this.timertask = new PushPuzzleTimer(this, this.board, x, y);
        this.timer.schedule(this.timertask, 100L, 100L);
    }

    private void cancelTo() {
        if (this.timertask != null) {
            this.timertask.cancel();
        }
    }

    protected void pointerPressed(int x, int y) {
        this.animateTo(x / this.cell, y / this.cell);
    }

    public void setCommandListener(CommandListener l) {
        super.setCommandListener(l);
        this.listener = l;
    }

    void repaintNear(int loc, int dir) {
        int x = loc & Short.MAX_VALUE;
        int y = loc >> 16 & Short.MAX_VALUE;
        int size = 1;
        if (dir >= 0) {
            ++size;
            if ((dir & 4) != 0) {
                ++size;
            }
        }
        int dx = 1;
        int dy = 1;
        switch (dir & 3) {
            case 1: {
                y -= size - 1;
                dy = size;
                break;
            }
            case 2: {
                dy = size;
                break;
            }
            case 3: {
                dx = size;
                break;
            }
            case 0: {
                x -= size - 1;
                dx = size;
            }
        }
        this.repaint(x * this.cell, y * this.cell, dx * this.cell, dy * this.cell);
    }

    protected void paint(Graphics g) {
        Board board = this.board;
        synchronized (board) {
            int x = 0;
            int y = 0;
            int x2 = this.bwidth;
            int y2 = this.bheight;
            int clipx = g.getClipX();
            int clipy = g.getClipY();
            int clipw = g.getClipWidth();
            int cliph = g.getClipHeight();
            x = clipx / this.cell;
            y = clipy / this.cell;
            x2 = (clipx + clipw + this.cell - 1) / this.cell;
            y2 = (clipy + cliph + this.cell - 1) / this.cell;
            if (x2 > this.bwidth) {
                x2 = this.bwidth;
            }
            if (y2 > this.bheight) {
                y2 = this.bheight;
            }
            g.setColor(groundColor);
            g.fillRect(0, 0, this.w, this.h);
            y = 0;
            while (y < y2) {
                x = 0;
                while (x < x2) {
                    byte v = this.board.get(x, y);
                    switch (v & 0xFFFFFFF7) {
                        case 4: {
                            g.setColor(wallColor);
                            g.fillRect(x * this.cell, y * this.cell, this.cell, this.cell);
                            break;
                        }
                        case 2: 
                        case 3: {
                            g.setColor(packetColor);
                            g.fillRect(x * this.cell + 1, y * this.cell + 1, this.cell - 2, this.cell - 2);
                            break;
                        }
                        case 1: {
                            g.setColor(storeColor);
                            if (useDottedLine) {
                                g.setStrokeStyle(1);
                            }
                            g.drawRect(x * this.cell + 1, y * this.cell + 1, this.cell - 2, this.cell - 2);
                            break;
                        }
                    }
                    if ((v & 8) != 0) {
                        g.setColor(pusherColor);
                        g.fillArc(x * this.cell, y * this.cell, this.cell, this.cell, 0, 360);
                    }
                    ++x;
                }
                ++y;
            }
            g.drawString("PushPuzzle Level " + this.level, 0, this.h - 31, 20);
        }
    }
}

