/*
 * Decompiled with CFR 0.152.
 */
package Game;

import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

class Score {
    private int levelId = 0;
    private byte[] levelRec = new byte[5];
    private static final int LEVEL_LEN = 5;
    private static final byte LEVEL_TAG = 1;
    private int scoreId;
    private byte[] scoreRec;
    private static final int SCORE_LEN = 13;
    private static final byte SCORE_TAG = 2;
    private RecordStore store = null;

    Score() {
        this.levelRec[0] = 1;
        this.putInt(this.levelRec, 1, 0);
        this.scoreId = 0;
        this.scoreRec = new byte[13];
        this.scoreRec[0] = 2;
        this.putInt(this.scoreRec, 1, 0);
    }

    boolean open() {
        try {
            this.store = RecordStore.openRecordStore((String)"PushPuzzleScores", (boolean)true);
        }
        catch (RecordStoreException ex) {
            // empty catch block
        }
        if (this.store == null) {
            return false;
        }
        try {
            this.levelId = 0;
            RecordEnumeration recordEnumeration = this.store.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int l;
                int ndx = recordEnumeration.nextRecordId();
                if (this.store.getRecordSize(ndx) != 5 || (l = this.store.getRecord(ndx, this.levelRec, 0)) != 5 || this.levelRec[0] != 1) continue;
                this.levelId = ndx;
                break;
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    int getLevel() {
        return this.getInt(this.levelRec, 1);
    }

    boolean setLevel(int level) {
        this.putInt(this.levelRec, 1, level);
        this.putInt(this.scoreRec, 1, level);
        if (this.store == null) {
            return false;
        }
        try {
            if (this.levelId == 0) {
                this.levelId = this.store.addRecord(this.levelRec, 0, this.levelRec.length);
            } else {
                this.store.setRecord(this.levelId, this.levelRec, 0, this.levelRec.length);
            }
        }
        catch (RecordStoreException ex) {
            System.out.println("RecordStoreException");
            ex.printStackTrace();
            return false;
        }
        this.readScore(level);
        return true;
    }

    int getPushes() {
        return this.getInt(this.scoreRec, 5);
    }

    int getMoves() {
        return this.getInt(this.scoreRec, 9);
    }

    boolean readScore(int level) {
        try {
            this.scoreId = 0;
            RecordEnumeration recordEnumeration = this.store.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int l;
                int ndx = recordEnumeration.nextRecordId();
                if (this.store.getRecordSize(ndx) != 13 || (l = this.store.getRecord(ndx, this.scoreRec, 0)) != 13 || this.scoreRec[0] != 2 || this.getInt(this.scoreRec, 1) != level) continue;
                this.scoreId = ndx;
                return true;
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
            return false;
        }
        this.scoreRec[0] = 2;
        this.putInt(this.scoreRec, 1, level);
        this.putInt(this.scoreRec, 5, 0);
        this.putInt(this.scoreRec, 9, 0);
        return true;
    }

    boolean setLevelScore(int pushes, int moves) {
        this.putInt(this.scoreRec, 5, pushes);
        this.putInt(this.scoreRec, 9, moves);
        try {
            if (this.scoreId == 0) {
                this.scoreId = this.store.addRecord(this.scoreRec, 0, this.scoreRec.length);
            } else {
                this.store.setRecord(this.scoreId, this.scoreRec, 0, this.scoreRec.length);
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private int getInt(byte[] buf, int offset) {
        return (buf[offset + 0] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    private void putInt(byte[] buf, int offset, int value) {
        buf[offset + 0] = (byte)(value >> 24 & 0xFF);
        buf[offset + 1] = (byte)(value >> 16 & 0xFF);
        buf[offset + 2] = (byte)(value >> 8 & 0xFF);
        buf[offset + 3] = (byte)(value >> 0 & 0xFF);
    }

    void close() {
        try {
            if (this.store != null) {
                this.store.closeRecordStore();
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }
}

