/*
 * Decompiled with CFR 0.152.
 */
package com.jsmart.midp.simon;

import com.jsmart.midp.simon.SimonSaysBoard;
import com.jsmart.midp.simon.Strings_he;
import com.jsmart.midp.util.ResourceBundle;
import com.jsmart.midp.util.SplashScreen;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class SimonSays
extends MIDlet
implements CommandListener {
    static ResourceBundle rb;
    private Display display;
    private SimonSaysBoard board;
    private Command startCommand;
    private Command soundOnCommand;
    private Command soundOffCommand;
    private Command helpCommand;
    private Command aboutCommand;
    private Command exitCommand;
    private Alert helpAlert;
    private Alert aboutAlert;
    private static String aboutString;
    private boolean showedSplash = false;

    public SimonSays() {
        ResourceBundle.putBundle("SimonSaysStrings", new Strings_he());
        rb = ResourceBundle.getBundle("SimonSaysStrings");
        this.startCommand = new Command(rb.getString("menu.start"), 1, 1);
        this.soundOnCommand = new Command(rb.getString("menu.soundOn"), 1, 2);
        this.soundOffCommand = new Command(rb.getString("menu.soundOff"), 1, 3);
        this.helpCommand = new Command(rb.getString("menu.help"), 5, 4);
        this.aboutCommand = new Command(rb.getString("menu.about"), 5, 30);
        this.exitCommand = new Command(rb.getString("menu.exit"), 7, 99);
        this.display = Display.getDisplay((MIDlet)this);
        this.board = new SimonSaysBoard(this.display);
        this.board.addCommand(this.startCommand);
        if (this.board.isSoundEnabled()) {
            this.board.addCommand(this.soundOffCommand);
        } else {
            this.board.addCommand(this.soundOnCommand);
        }
        this.board.addCommand(this.helpCommand);
        this.board.addCommand(this.aboutCommand);
        this.board.addCommand(this.exitCommand);
        this.board.setCommandListener(this);
        StringBuffer stringBuffer = new StringBuffer(rb.getString("title"));
        stringBuffer.append("\nversion ");
        stringBuffer.append(this.getAppProperty("SimonSays-Version"));
        stringBuffer.append("\nlocale ");
        stringBuffer.append(System.getProperty("microedition.locale"));
        stringBuffer.append("\nby JSmart Technologies");
        stringBuffer.append("\nwww.jsmart.com");
        aboutString = stringBuffer.toString();
    }

    public void startApp() {
        if (!this.showedSplash) {
            this.showedSplash = true;
            try {
                new SplashScreen(this.display, (Displayable)this.board, Image.createImage((String)"/simonsays_splash.png"), "by JSmart", 2500);
            }
            catch (Exception exception) {
                this.display.setCurrent((Displayable)this.board);
            }
        } else {
            this.display.setCurrent((Displayable)this.board);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.startCommand) {
            this.board.start();
        } else if (command == this.soundOnCommand) {
            this.board.setSoundEnabled(true);
            this.board.removeCommand(this.soundOnCommand);
            this.board.addCommand(this.soundOffCommand);
        } else if (command == this.soundOffCommand) {
            this.board.setSoundEnabled(false);
            this.board.removeCommand(this.soundOffCommand);
            this.board.addCommand(this.soundOnCommand);
        } else if (command == this.helpCommand) {
            this.showHelp();
        } else if (command == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.aboutCommand) {
            this.showAbout();
        }
    }

    private void showHelp() {
        if (this.helpAlert == null) {
            this.helpAlert = new Alert(rb.getString("help.title"));
            this.helpAlert.setTimeout(-2);
            this.helpAlert.setString(rb.getString("help.text"));
        }
        this.display.setCurrent((Displayable)this.helpAlert);
    }

    private void showAbout() {
        if (this.aboutAlert == null) {
            this.aboutAlert = new Alert(rb.getString("about.title"));
            this.aboutAlert.setTimeout(-2);
            this.aboutAlert.setString(aboutString);
        }
        this.display.setCurrent((Displayable)this.aboutAlert);
    }
}

