/*
 * Decompiled with CFR 0.152.
 */
package com.jsmart.midp.simon;

import com.jsmart.midp.simon.SimonSays;
import com.jsmart.midp.util.Utils;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public final class SimonSaysBoard
extends Canvas {
    private Display display;
    private boolean acceptUserInput = false;
    private Alert gameOverAlert;
    private byte filledPanel = 0;
    private Vector sequence = new Vector();
    private Vector userSequence = new Vector();
    private Random random = new Random();
    private int width;
    private int height;
    private boolean soundEnabled = false;

    public SimonSaysBoard(Display display) {
        this.display = display;
        this.width = this.getWidth() - 8;
        this.height = this.getHeight() - 10;
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    public void setSoundEnabled(boolean bl) {
        this.soundEnabled = bl;
    }

    public void start() {
        this.acceptUserInput = false;
        this.filledPanel = 0;
        this.sequence.removeAllElements();
        this.userSequence.removeAllElements();
        this.generateSequence();
        new SequenceAnimator().start();
    }

    private void generateSequence() {
        int n = this.sequence.size() + 1;
        this.sequence.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            int n3 = Math.abs(this.random.nextInt());
            n3 = n3 % 4 + 1;
            this.sequence.addElement(new Integer(n3));
            ++n2;
        }
    }

    public void paint(Graphics graphics) {
        this.clear(graphics);
        this.drawBoard(graphics);
    }

    private void clear(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void drawBoard(Graphics graphics) {
        int n = 2;
        int n2 = 2;
        if (this.filledPanel == 1) {
            graphics.setColor(245, 245, 0);
            graphics.fillArc(0 + n, 0 + n2, this.width, this.height, 45, 90);
            if (this.soundEnabled) {
                AlertType.CONFIRMATION.playSound(this.display);
            }
        } else if (this.filledPanel == 2) {
            graphics.setColor(0, 255, 50);
            graphics.fillArc(0 + n, 0 + n2, this.width, this.height, 315, 90);
            if (this.soundEnabled) {
                AlertType.ALARM.playSound(this.display);
            }
        } else if (this.filledPanel == 3) {
            graphics.setColor(255, 0, 50);
            graphics.fillArc(0 + n, 0 + n2, this.width, this.height, 225, 90);
            if (this.soundEnabled) {
                AlertType.INFO.playSound(this.display);
            }
        } else if (this.filledPanel == 4) {
            graphics.setColor(0, 50, 255);
            graphics.fillArc(0 + n, 0 + n2, this.width, this.height, 135, 90);
            if (this.soundEnabled) {
                AlertType.WARNING.playSound(this.display);
            }
        }
        graphics.setColor(64, 64, 64);
        graphics.drawArc(0 + n, 0 + n2, this.width, this.height, 0, 360);
        graphics.setColor(64, 64, 64);
        graphics.fillArc(0 + n, 0 + n2, this.width, this.height, 44, 2);
        graphics.fillArc(0 + n, 0 + n2, this.width, this.height, 314, 2);
        graphics.fillArc(0 + n, 0 + n2, this.width, this.height, 224, 2);
        graphics.fillArc(0 + n, 0 + n2, this.width, this.height, 134, 2);
        graphics.fillArc(this.width / 2 - 3 + n, this.height / 2 - 3 + n2, 6, 6, 0, 360);
    }

    protected void keyPressed(int n) {
        if (!this.acceptUserInput) {
            return;
        }
        this.acceptUserInput = false;
        int n2 = this.getGameAction(n);
        Integer n3 = null;
        switch (n2) {
            case 1: {
                n3 = new Integer(1);
                break;
            }
            case 5: {
                n3 = new Integer(2);
                break;
            }
            case 6: {
                n3 = new Integer(3);
                break;
            }
            case 2: {
                n3 = new Integer(4);
            }
        }
        this.userSequence.addElement(n3);
        this.filledPanel = n3.byteValue();
        new UserSequenceAnimator().start();
    }

    private boolean validateUserSequence() {
        boolean bl = true;
        int n = 0;
        while (n < this.userSequence.size()) {
            Integer n2;
            Integer n3 = (Integer)this.userSequence.elementAt(n);
            if (!n3.equals(n2 = (Integer)this.sequence.elementAt(n))) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            if (this.userSequence.size() == this.sequence.size()) {
                this.userSequence.removeAllElements();
                this.generateSequence();
                new SequenceAnimator().start();
            } else {
                this.acceptUserInput = true;
            }
        } else {
            this.showGameOver();
        }
        return bl;
    }

    private void showGameOver() {
        this.acceptUserInput = false;
        if (this.gameOverAlert == null) {
            this.gameOverAlert = new Alert(SimonSays.rb.getString("gameover.title"));
            this.gameOverAlert.setTimeout(-2);
        }
        StringBuffer stringBuffer = new StringBuffer(35);
        stringBuffer.append(SimonSays.rb.getString("gameover.title")).append('\n');
        String string = this.sequence.size() - 1 == 1 ? SimonSays.rb.getString("gameover.youSuccessfullyCompletedRound") : SimonSays.rb.getString("gameover.youSuccessfullyCompletedRounds");
        string = Utils.replace(string, "{0}", Integer.toString(this.sequence.size() - 1));
        stringBuffer.append(string);
        this.gameOverAlert.setString(stringBuffer.toString());
        this.display.setCurrent((Displayable)this.gameOverAlert);
        if (this.soundEnabled) {
            AlertType.WARNING.playSound(this.display);
        }
    }

    class UserSequenceAnimator
    extends Thread {
        UserSequenceAnimator() {
        }

        public synchronized void run() {
            SimonSaysBoard.this.repaint();
            try {
                Thread.currentThread();
                Thread.sleep(250L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            SimonSaysBoard.this.filledPanel = (byte)0;
            SimonSaysBoard.this.repaint();
            SimonSaysBoard.this.validateUserSequence();
        }
    }

    class SequenceAnimator
    extends Thread {
        SequenceAnimator() {
        }

        public synchronized void run() {
            int n = 0;
            while (n < SimonSaysBoard.this.sequence.size()) {
                int n2 = n == 0 ? 700 : 350;
                try {
                    Thread.currentThread();
                    Thread.sleep(n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Integer n3 = (Integer)SimonSaysBoard.this.sequence.elementAt(n);
                SimonSaysBoard.this.filledPanel = n3.byteValue();
                SimonSaysBoard.this.repaint();
                try {
                    Thread.currentThread();
                    Thread.sleep(750L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                SimonSaysBoard.this.filledPanel = (byte)0;
                SimonSaysBoard.this.repaint();
                ++n;
            }
            SimonSaysBoard.this.acceptUserInput = true;
        }
    }
}

