/*
 * Decompiled with CFR 0.152.
 */
package com.jsmart.midp.util;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class SplashScreen
extends Canvas {
    private Display display;
    private Displayable next;
    private Timer timer = new Timer();
    private Image image;
    private String text;
    private int dismissTime;

    public SplashScreen(Display display, Displayable displayable, Image image, String string, int n) {
        this.display = display;
        this.next = displayable;
        this.image = image;
        this.text = string;
        this.dismissTime = n;
        display.setCurrent((Displayable)this);
    }

    private void clear(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected void paint(Graphics graphics) {
        this.clear(graphics);
        graphics.setColor(0);
        if (this.image != null) {
            graphics.drawImage(this.image, this.getWidth() / 2, this.getHeight() / 2 - 5, 3);
            if (this.text != null) {
                graphics.drawString(this.text, this.getWidth() / 2, this.getHeight() / 2 + this.image.getHeight() / 2 - 3, 17);
            }
        } else if (this.text != null) {
            graphics.drawString(this.text, this.getWidth() / 2, this.getHeight() / 2, 33);
        }
    }

    private void dismiss() {
        this.timer.cancel();
        this.display.setCurrent(this.next);
    }

    protected void keyPressed(int n) {
        this.dismiss();
    }

    protected void pointerPressed(int n, int n2) {
        this.dismiss();
    }

    protected void showNotify() {
        if (this.dismissTime > 0) {
            this.timer.schedule((TimerTask)new CountDown(), this.dismissTime);
        }
    }

    private class CountDown
    extends TimerTask {
        private CountDown() {
        }

        public void run() {
            SplashScreen.this.dismiss();
        }
    }
}

