/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CartoonCanvas
extends Canvas {
    private static final int PAGES = 6;
    private static final String title = "\u6f2b\u753b";
    static int UP = -10;
    static int DOWN = -11;
    static int LEFT = -12;
    static int RIGHT = -13;
    Cartoon p;
    Image imageCopyright;
    Image[] image = new Image[6];
    int curPage = 0;
    int centerX;
    int centerY;
    int height;
    StringBuffer imgName = new StringBuffer("comic00.png");
    Font fontSmall = Font.getFont((int)64, (int)0, (int)8);

    public CartoonCanvas(Cartoon cartoon) {
        this.centerX = this.getWidth() / 2;
        this.height = this.getHeight();
        this.centerY = this.height / 2;
        this.p = cartoon;
        try {
            this.imageCopyright = Image.createImage((String)"c.png");
            int n = 0;
            while (n < 6) {
                this.imgName.setCharAt(6, (char)(49 + n));
                this.image[n] = Image.createImage((String)this.imgName.toString());
                ++n;
            }
        }
        catch (IOException iOException) {}
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0);
        if (this.curPage == 0) {
            graphics.drawString("\u6f2b\u753b\uff1a \u9493\u9c7c", this.centerX, 60, 17);
            graphics.drawImage(this.imageCopyright, 0, 166, 20);
            graphics.setFont(this.fontSmall);
            graphics.drawString("Copyright 2001 Motorola Inc.", 12, 160, 20);
            graphics.drawString("All rights reserved.", 12, 180, 20);
        } else {
            graphics.drawImage(this.image[this.curPage - 1], this.centerX, this.centerY, 3);
        }
    }

    protected void keyPressed(int n) {
        if (this.curPage == 0) {
            this.curPage = 1;
            this.repaint();
            return;
        }
        if (n == UP) {
            if (this.curPage > 1) {
                --this.curPage;
                this.repaint();
            }
        } else if (n == DOWN) {
            if (this.curPage < 6) {
                ++this.curPage;
                this.repaint();
            }
        } else if (n == LEFT) {
            if (this.curPage > 1) {
                this.curPage = 1;
                this.repaint();
            }
        } else if (n == RIGHT && this.curPage < 6) {
            this.curPage = 6;
            this.repaint();
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (n2 > this.height) {
            return;
        }
        if (this.curPage < 6) {
            ++this.curPage;
            this.repaint();
        }
    }
}

