/*
 * Decompiled with CFR 0.152.
 */
package example.photoalbum;

import example.About;
import example.photoalbum.PhotoFrame;
import example.photoalbum.TestChart;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class PhotoAlbum
extends MIDlet
implements CommandListener,
ItemStateListener,
Runnable {
    private Command aboutCommand;
    private Command exitCommand;
    private Command okCommand;
    private Command optionsCommand;
    private Command backCommand;
    private Command cancelCommand;
    private Form progressForm;
    private Gauge progressGauge;
    private Form optionsForm;
    private ChoiceGroup borderChoice;
    private ChoiceGroup speedChoice;
    private Display display = Display.getDisplay((MIDlet)this);
    private PhotoFrame frame;
    private Alert alert;
    private Vector imageNames;
    private List imageList;
    private String imageName;
    private Thread thread;
    private final String optionsName;
    private RecordStore optionsStore;
    private Image img;
    private int imgX;
    private int imgY;
    private int current;
    private int namebufferlen;
    private byte[] namebuffer;
    public InputStream _input;

    public PhotoAlbum() {
        this.optionsName = "PhotoAlbum";
        this.exitCommand = new Command("Exit", 7, 1);
        this.optionsCommand = new Command("Options", 1, 1);
        this.okCommand = new Command("Ok", 4, 3);
        this.backCommand = new Command("Back", 1, 3);
        this.cancelCommand = new Command("Cancel", 3, 1);
        this.aboutCommand = new Command("About", 5, 30);
        this.frame = new PhotoFrame();
        this.frame.setStyle(2);
        this.frame.setSpeed(2);
        this.frame.addCommand(this.optionsCommand);
        this.frame.addCommand(this.backCommand);
        this.frame.setCommandListener(this);
        this.alert = new Alert("Warning");
        this.setupImageList();
    }

    protected void startApp() {
        if (this.imageList.size() > 0) {
            this.display.setCurrent((Displayable)this.imageList);
            this.openOptions();
            this.restoreOptions();
        } else {
            this.alert.setString("No images configured.");
            this.display.setCurrent(this.alert, (Displayable)this.imageList);
        }
    }

    protected void pauseApp() {
        this.saveOptions();
        this.frame.reset();
    }

    protected void destroyApp(boolean bl) {
        this.saveOptions();
        this.frame.reset();
        this.saveOptions();
        this.closeOptions();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.optionsCommand) {
            this.display.setCurrent((Displayable)this.genOptions());
        } else if (command == this.okCommand && displayable == this.optionsForm) {
            this.display.setCurrent((Displayable)this.frame);
        } else if (command == List.SELECT_COMMAND) {
            int n = this.imageList.getSelectedIndex();
            this.imageName = (String)this.imageNames.elementAt(n);
            this.display.setCurrent((Displayable)this.genProgress(this.imageList.getString(n)));
            this.thread = new Thread(this);
            this.thread.start();
        } else if (command == this.backCommand) {
            this.display.setCurrent((Displayable)this.imageList);
        } else if (command == this.cancelCommand) {
            this.thread = null;
            this.alert.setString("Loading images cancelled.");
            this.display.setCurrent(this.alert, (Displayable)this.imageList);
        } else if (command == this.aboutCommand) {
            About.showAbout(this.display);
        }
    }

    public void itemStateChanged(Item item) {
        if (item == this.borderChoice) {
            this.frame.setStyle(this.borderChoice.getSelectedIndex());
        } else if (item == this.speedChoice) {
            this.frame.setSpeed(this.speedChoice.getSelectedIndex());
        }
    }

    private Screen genOptions() {
        if (this.optionsForm == null) {
            this.optionsForm = new Form("Options");
            this.optionsForm.addCommand(this.okCommand);
            this.optionsForm.setCommandListener((CommandListener)this);
            this.optionsForm.setItemStateListener((ItemStateListener)this);
            this.speedChoice = new ChoiceGroup("Speed", 1);
            this.speedChoice.append("Stop", null);
            this.speedChoice.append("Slow", null);
            this.speedChoice.append("Medium", null);
            this.speedChoice.append("Fast", null);
            this.speedChoice.setSelectedIndex(this.frame.getSpeed(), true);
            this.optionsForm.append((Item)this.speedChoice);
            this.borderChoice = new ChoiceGroup("Borders", 1);
            this.borderChoice.append("None", null);
            this.borderChoice.append("Plain", null);
            this.borderChoice.append("Fancy", null);
            this.borderChoice.setSelectedIndex(this.frame.getStyle(), true);
            this.optionsForm.append((Item)this.borderChoice);
        }
        return this.optionsForm;
    }

    private Screen genProgress(String string) {
        if (this.progressForm == null) {
            this.progressForm = new Form(string);
            this.progressForm.addCommand(this.cancelCommand);
            this.progressForm.setCommandListener((CommandListener)this);
            this.progressGauge = new Gauge("Loading images...", false, 9, 0);
            this.progressForm.append((Item)this.progressGauge);
        } else {
            this.progressGauge.setValue(0);
            this.progressForm.setTitle(string);
        }
        return this.progressForm;
    }

    private String getNextName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.namebufferlen != 0) {
            while (this.current < this.namebufferlen) {
                if (this.namebuffer[this.current] == 10) {
                    ++this.current;
                    return stringBuffer.toString();
                }
                stringBuffer.append((char)this.namebuffer[this.current]);
                ++this.current;
            }
        }
        return stringBuffer.toString();
    }

    private void getNames() throws IOException {
        this._input = this.getClass().getResourceAsStream("/Names.txt");
        if (this._input == null) {
            return;
        }
        this.namebuffer = new byte[10000];
        this.namebufferlen = this._input.read(this.namebuffer, 0, 10000);
        System.out.println(this.namebufferlen);
        this._input.close();
    }

    private boolean testFiles(String string) throws IOException {
        this._input = this.getClass().getResourceAsStream(string);
        if (this._input != null) {
            this._input.close();
            return false;
        }
        return true;
    }

    private void setupImageList() {
        this.imageNames = new Vector();
        this.imageList = new List("Images", 3);
        this.imageList.addCommand(this.exitCommand);
        this.imageList.addCommand(this.aboutCommand);
        this.imageList.setCommandListener((CommandListener)this);
        this.current = 0;
        String string = "PhotoImage";
        String string2 = "/photo";
        String string3 = "PhotoTitle";
        String string4 = "Images";
        if (string4 == null || string4.length() == 0) {
            string4 = string2;
        }
        this.imageNames.addElement(string2);
        this.imageList.append(string4, null);
    }

    public void run() {
        block19: {
            Thread thread = Thread.currentThread();
            Vector vector = new Vector(5);
            Vector<String> vector2 = new Vector<String>(5);
            this.frame.reset();
            this.namebufferlen = 0;
            try {
                this.getNames();
            }
            catch (IOException iOException) {
                System.out.println("error");
            }
            this.current = 0;
            System.out.println(this.namebufferlen);
            try {
                try {
                    if (this.imageName.startsWith("testchart:")) {
                        TestChart testChart = new TestChart(this.frame.getWidth(), this.frame.getHeight());
                        vector = testChart.generateImages();
                    } else {
                        vector.addElement(this.createImage(this.imageName));
                    }
                }
                catch (IOException iOException) {
                    try {
                        int n = this.imageName.length();
                        StringBuffer stringBuffer = new StringBuffer(n + 8);
                        stringBuffer.append(this.imageName);
                        Runtime runtime = Runtime.getRuntime();
                        int n2 = 0;
                        while (true) {
                            this.progressGauge.setValue(n2 % 10);
                            if (this.thread != thread) break;
                            stringBuffer.setLength(n);
                            stringBuffer.append(n2);
                            stringBuffer.append(".png");
                            String string = stringBuffer.toString();
                            if (n2 == 0) {
                                this.img = this.createImage(string);
                                this.imgX = this.img.getWidth();
                                this.imgY = this.img.getHeight();
                            } else if (this.testFiles(string)) {
                                System.out.println("not found");
                                break;
                            }
                            vector.addElement(string);
                            vector2.addElement(this.getNextName());
                            ++n2;
                        }
                        System.out.println("terminate");
                    }
                    catch (IOException iOException2) {
                        System.out.println("ioerr");
                    }
                }
                if (this.thread != thread) {
                    return;
                }
                if (vector.size() > 0) {
                    this.frame.setImages(vector, this.imgX, this.imgY, vector2);
                    this.display.setCurrent((Displayable)this.frame);
                    System.out.println(vector.size());
                    break block19;
                }
                this.alert.setString("Images could not be loaded.");
                this.display.setCurrent(this.alert, (Displayable)this.imageList);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                int n = vector.size();
                if (n > 0) {
                    vector.setSize(n - 1);
                }
                if (this.thread != thread) {
                    return;
                }
                this.alert.setString("Not enough memory for all images.");
                if (vector.size() <= 0) {
                    this.display.setCurrent(this.alert, (Displayable)this.imageList);
                    break block19;
                }
                this.frame.setImages(vector, this.imgX, this.imgY, vector2);
                this.display.setCurrent(this.alert, (Displayable)this.frame);
            }
        }
    }

    private Image createImage(String string) throws IOException {
        if (string.startsWith("/")) {
            return Image.createImage((String)string);
        }
        if (string.startsWith("http:")) {
            HttpConnection httpConnection = null;
            FilterInputStream filterInputStream = null;
            try {
                httpConnection = (HttpConnection)Connector.open((String)string);
                int n = httpConnection.getResponseCode();
                if (n != 200) {
                    throw new IOException("HTTP Response Code = " + n);
                }
                int n2 = (int)httpConnection.getLength();
                String string2 = httpConnection.getType();
                if (!string2.equals("image/png")) {
                    throw new IOException("Expecting image, received " + string2);
                }
                if (n2 > 0) {
                    filterInputStream = httpConnection.openDataInputStream();
                    byte[] byArray = new byte[n2];
                    ((DataInputStream)filterInputStream).readFully(byArray);
                    Image image = Image.createImage((byte[])byArray, (int)0, (int)n2);
                    return image;
                }
                throw new IOException("Content length is missing");
            }
            finally {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
        }
        throw new IOException("Unsupported media");
    }

    void openOptions() {
        try {
            this.optionsStore = RecordStore.openRecordStore((String)"PhotoAlbum", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            this.alert.setString("Could not access options storage");
            this.display.setCurrent((Displayable)this.alert);
            this.optionsStore = null;
        }
    }

    void saveOptions() {
        block5: {
            if (this.optionsStore == null) break block5;
            byte[] byArray = new byte[]{(byte)this.frame.getStyle(), (byte)this.frame.getSpeed()};
            try {
                this.optionsStore.setRecord(1, byArray, 0, byArray.length);
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                try {
                    int n = this.optionsStore.addRecord(byArray, 0, byArray.length);
                }
                catch (RecordStoreException recordStoreException) {
                    this.alert.setString("Could not add options record");
                    this.display.setCurrent((Displayable)this.alert);
                }
            }
            catch (RecordStoreException recordStoreException) {
                this.alert.setString("Could not save options");
                this.display.setCurrent((Displayable)this.alert);
            }
        }
    }

    void restoreOptions() {
        block4: {
            if (this.optionsStore == null) break block4;
            try {
                byte[] byArray = this.optionsStore.getRecord(1);
                if (byArray.length == 2) {
                    this.frame.setStyle(byArray[0]);
                    this.frame.setSpeed(byArray[1]);
                    if (this.optionsForm != null) {
                        this.borderChoice.setSelectedIndex((int)byArray[0], true);
                        this.speedChoice.setSelectedIndex((int)byArray[1], true);
                    }
                    return;
                }
            }
            catch (RecordStoreException recordStoreException) {}
        }
    }

    void closeOptions() {
        block2: {
            if (this.optionsStore == null) break block2;
            try {
                this.optionsStore.closeRecordStore();
                this.optionsStore = null;
            }
            catch (RecordStoreException recordStoreException) {
                this.alert.setString("Could not close options storage");
                this.display.setCurrent((Displayable)this.alert);
            }
        }
    }
}

