/*
 * Decompiled with CFR 0.152.
 */
package example.photoalbum;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class PhotoFrame
extends Canvas
implements Runnable {
    private int style;
    private int speed;
    private Vector names;
    private Vector images;
    private int index;
    private int imageX;
    private int imageY;
    private int imageWidth;
    private int imageHeight;
    private Thread thread;
    private Image image = Image.createImage((int)this.getWidth(), (int)this.getHeight());
    private Image bimage;
    private long paintTime;
    private Image img;
    private static final int[] speeds = new int[]{999999999, 500, 250, 100};

    PhotoFrame() {
        this.setStyle(0);
        this.setSpeed(0);
    }

    void setImages(Vector vector, int n, int n2, Vector vector2) {
        this.images = vector;
        this.names = vector2;
        if (vector.size() > 0) {
            this.imageWidth = n;
            this.imageHeight = n2;
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
        this.index = 0;
        this.imageX = (this.getWidth() - this.imageWidth) / 2;
        this.imageY = (this.getHeight() - this.imageHeight) / 2;
        this.genFrame(this.style, this.imageX, this.imageY, this.imageWidth, this.imageHeight);
    }

    void next() throws IOException {
        if (this.images == null || ++this.index >= this.images.size()) {
            this.index = 0;
        }
        try {
            this.img = Image.createImage((String)((String)this.images.elementAt(this.index)));
        }
        catch (IOException iOException) {}
    }

    void previous() throws IOException {
        this.index = this.images != null && --this.index < 0 ? this.images.size() - 1 : 0;
        this.img = Image.createImage((String)((String)this.images.elementAt(this.index)));
    }

    void reset() {
        this.images = null;
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        try {
            switch (n2) {
                case 5: {
                    if (this.thread != null) break;
                    this.next();
                    this.repaint();
                    break;
                }
                case 2: {
                    if (this.thread != null) break;
                    this.previous();
                    this.repaint();
                    break;
                }
                case 8: {
                    if (this.thread == null) {
                        this.thread = new Thread(this);
                        this.thread.start();
                        break;
                    }
                    PhotoFrame photoFrame = this;
                    synchronized (photoFrame) {
                        this.notify();
                        this.thread = null;
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {}
    }

    protected void keyRepeated(int n) {
        this.keyPressed(n);
    }

    void setSpeed(int n) {
        this.speed = n;
    }

    int getSpeed() {
        return this.speed;
    }

    void setStyle(int n) {
        this.style = n;
        this.genFrame(n, this.imageX, this.imageY, this.imageWidth, this.imageHeight);
    }

    int getStyle() {
        return this.style;
    }

    protected void showNotify() {
        if (this.images != null && this.images.size() > 1) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    protected void hideNotify() {
        this.thread = null;
    }

    boolean intersectsClip(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        if (n + n3 <= n5) {
            return false;
        }
        int n6 = graphics.getClipWidth();
        if (n > n5 + n6) {
            return false;
        }
        int n7 = graphics.getClipY();
        if (n2 + n4 <= n7) {
            return false;
        }
        int n8 = graphics.getClipHeight();
        return n2 <= n7 + n8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l;
        Thread thread = Thread.currentThread();
        this.paintTime = l = System.currentTimeMillis();
        while (this.thread == thread) {
            PhotoFrame photoFrame = this;
            synchronized (photoFrame) {
                try {
                    long l2 = (l += (long)speeds[this.speed]) - this.paintTime;
                    if (l2 > 0L) {
                        this.wait(l2);
                    }
                    try {
                        this.next();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.repaint(this.imageX, this.imageY, this.imageWidth, this.imageHeight);
                    this.serviceRepaints();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected void paint(Graphics graphics) {
        this.paintTime = System.currentTimeMillis();
        if (this.image != null) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            n = graphics.getClipX();
            if (n < this.imageX || (n2 = graphics.getClipY()) < this.imageY || n + (n3 = graphics.getClipWidth()) > this.imageX + this.imageWidth || n2 + (n4 = graphics.getClipHeight()) > this.imageY + this.imageHeight) {
                graphics.drawImage(this.image, 0, 0, 20);
            }
            if (this.images != null && this.index < this.images.size() && this.intersectsClip(graphics, this.imageX, this.imageY, this.imageWidth, this.imageHeight) && this.img != null) {
                graphics.drawImage(this.img, this.imageX, this.imageY, 20);
                graphics.setColor(0);
                graphics.setFont(Font.getFont((int)32, (int)1, (int)8));
                graphics.drawString((String)this.names.elementAt(this.index), this.imageX + graphics.getClipWidth() / 2, this.imageY, 17);
            }
        }
    }

    private void genFrame(int n, int n2, int n3, int n4, int n5) {
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.image.getWidth() + 1, this.image.getHeight() + 1);
        graphics.translate(n2, n3);
        this.paintBorder(graphics, n, n4, n5);
    }

    private void paintBorder(Graphics graphics, int n, int n2, int n3) {
        if (n == 1) {
            graphics.setGrayScale(128);
            graphics.drawRect(-1, -1, n2 + 1, n3 + 1);
            graphics.drawRect(-2, -2, n2 + 3, n3 + 3);
        }
        if (n == 2) {
            if (this.bimage == null) {
                this.bimage = this.genBorder();
            }
            int n4 = this.bimage.getWidth();
            int n5 = this.bimage.getHeight();
            graphics.setGrayScale(128);
            graphics.drawRect(-1, -1, n2 + 1, n3 + 1);
            graphics.drawRect(-n4 - 2, -n5 - 2, n2 + n4 * 2 + 3, n3 + n5 * 2 + 3);
            graphics.drawImage(this.bimage, -1, -1, 40);
            graphics.drawImage(this.bimage, -1, n3 + 1, 24);
            graphics.drawImage(this.bimage, n2 + 1, -1, 36);
            graphics.drawImage(this.bimage, n2 + 1, n3 + 1, 20);
            int n6 = n3 % n5 / 2;
            while (n6 < n3 - n5) {
                graphics.drawImage(this.bimage, -1, n6, 24);
                graphics.drawImage(this.bimage, n2 + 1, n6, 20);
                n6 += n5;
            }
            n6 = n2 % n4 / 2;
            while (n6 < n2 - n4) {
                graphics.drawImage(this.bimage, n6, -1, 36);
                graphics.drawImage(this.bimage, n6, n3 + 1, 20);
                n6 += n4;
            }
        }
    }

    private Image genBorder() {
        Image image = Image.createImage((int)5, (int)5);
        Graphics graphics = image.getGraphics();
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, 5, 5);
        graphics.setColor(128, 0, 255);
        graphics.drawLine(2, 1, 2, 3);
        graphics.drawLine(1, 2, 3, 2);
        return image;
    }
}

