/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.java.security;

import java.util.Random;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class SecureRandom
extends Random {
    private static SecureRandom rand = new SecureRandom();
    private byte[] seed;
    private long counter = 1L;
    private SHA1Digest digest = new SHA1Digest();
    private byte[] state = new byte[this.digest.getDigestSize()];
    private byte[] intBytes = new byte[4];
    private byte[] longBytes = new byte[8];

    public SecureRandom() {
        super(0L);
        this.setSeed(System.currentTimeMillis());
    }

    public SecureRandom(byte[] byArray) {
        this.setSeed(byArray);
    }

    public static SecureRandom getInstance(String string) {
        return new SecureRandom();
    }

    public static SecureRandom getInstance(String string, String string2) {
        return new SecureRandom();
    }

    public static byte[] getSeed(int n) {
        byte[] byArray = new byte[n];
        rand.setSeed(System.currentTimeMillis());
        rand.nextBytes(byArray);
        return byArray;
    }

    public byte[] generateSeed(int n) {
        byte[] byArray = new byte[n];
        this.nextBytes(byArray);
        return byArray;
    }

    public void setSeed(byte[] byArray) {
        this.digest.update(byArray, 0, byArray.length);
    }

    public void nextBytes(byte[] byArray) {
        byte[] byArray2;
        int n = 0;
        this.digest.doFinal(this.state, 0);
        int n2 = 0;
        while (n2 != byArray.length) {
            if (n == this.state.length) {
                byArray2 = this.longToBytes(this.counter++);
                this.digest.update(byArray2, 0, byArray2.length);
                this.digest.update(this.state, 0, this.state.length);
                this.digest.doFinal(this.state, 0);
                n = 0;
            }
            byArray[n2] = this.state[n++];
            ++n2;
        }
        byArray2 = this.longToBytes(this.counter++);
        this.digest.update(byArray2, 0, byArray2.length);
        this.digest.update(this.state, 0, this.state.length);
    }

    public void setSeed(long l) {
        if (l != 0L) {
            this.setSeed(this.longToBytes(l));
        }
    }

    public int nextInt() {
        this.nextBytes(this.intBytes);
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            n = (n << 8) + (this.intBytes[n2] & 0xFF);
            ++n2;
        }
        return n;
    }

    protected final int next(int n) {
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        this.nextBytes(byArray);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = (n3 << 8) + (byArray[n4] & 0xFF);
            ++n4;
        }
        return n3 & (1 << n) - 1;
    }

    private byte[] longToBytes(long l) {
        int n = 0;
        while (n != 8) {
            this.longBytes[n] = (byte)(l >>>= 8 * n);
            ++n;
        }
        return this.longBytes;
    }
}

