/*
 * Decompiled with CFR 0.152.
 */
package org.eaves.pocket;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.List;
import org.eaves.pocket.record.PocketRecord;
import org.eaves.pocket.record.PocketStore;
import org.eaves.pocket.record.PocketStoreException;

public class ItemList
extends List {
    private Command _new = new Command("New", 4, 1);
    private Command _open;
    private Command _delete;
    private Command _exit = new Command("Exit", 3, 1);
    private PocketStore _store;
    private int _storeSize;
    private Vector _records;

    public ItemList() {
        super("Pocket - List", 3);
        this._open = new Command("Open", 1, 2);
        this._delete = new Command("Delete", 1, 3);
        this.addCommand(this._exit);
        this.addCommand(this._new);
        this.addCommand(this._delete);
        this.addCommand(this._open);
    }

    public Command getDeleteCommand() {
        return this._delete;
    }

    public Command getNewCommand() {
        return this._new;
    }

    public Command getExitCommand() {
        return this._exit;
    }

    public Command getOpenCommand() {
        return this._open;
    }

    public void reload(PocketStore pocketStore) throws PocketStoreException {
        this._store = pocketStore;
        this._storeSize = this._store.count();
        this.display();
    }

    public int selected() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return n;
        }
        PocketRecord pocketRecord = (PocketRecord)this._records.elementAt(n);
        return pocketRecord.getRID();
    }

    private void display() throws PocketStoreException {
        int n = this._store.count();
        PocketRecord pocketRecord = null;
        if (n <= 0) {
            return;
        }
        this._records = this._store.getRecords();
        Enumeration enumeration = this._records.elements();
        while (enumeration.hasMoreElements()) {
            pocketRecord = (PocketRecord)enumeration.nextElement();
            this.append(pocketRecord.getName(), null);
        }
    }
}

