/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class Object3D {
    int[] x;
    int[] y;
    int[] z;
    int[] rx;
    int[] ry;
    int[] rz;
    int[] prx;
    int[] pry;
    int[] faceList;
    int[] faceColor;
    int nrPoints;
    int pa;
    int pb;
    int pc;
    int pd;
    int pe;
    int pf;
    int pg;
    int ph;
    int pi;

    public Object3D(int n, int n2) {
        this.nrPoints = n;
        this.x = new int[n];
        this.y = new int[n];
        this.z = new int[n];
        this.rx = new int[n];
        this.ry = new int[n];
        this.rz = new int[n];
        this.prx = new int[n];
        this.pry = new int[n];
        this.faceList = new int[n2];
    }

    void RotateMatrix(int n, int n2, int n3) {
        this.pa = (SdwUtil.cosTab[n2 &= 0x3FF] >> 1) * (SdwUtil.cosTab[n3 &= 0x3FF] >> 1) >> 14;
        this.pb = (SdwUtil.cosTab[n2] >> 1) * (SdwUtil.sinTab[n3] >> 1) >> 14;
        this.pc = -SdwUtil.sinTab[n2];
        this.pd = (SdwUtil.sinTab[n &= 0x3FF] >> 1) * (SdwUtil.sinTab[n2] >> 1) >> 14;
        this.pd = (this.pd >> 1) * (SdwUtil.cosTab[n3] >> 1) >> 14;
        this.pd -= (SdwUtil.cosTab[n] >> 1) * (SdwUtil.sinTab[n3] >> 1) >> 14;
        this.pe = (SdwUtil.sinTab[n] >> 1) * (SdwUtil.sinTab[n2] >> 1) >> 14;
        this.pe = (this.pe >> 1) * (SdwUtil.sinTab[n3] >> 1) >> 14;
        this.pe += (SdwUtil.cosTab[n] >> 1) * (SdwUtil.cosTab[n3] >> 1) >> 14;
        this.pf = (SdwUtil.sinTab[n] >> 1) * (SdwUtil.cosTab[n2] >> 1) >> 14;
        this.pg = (SdwUtil.cosTab[n] >> 1) * (SdwUtil.sinTab[n2] >> 1) >> 14;
        this.pg = (this.pg >> 1) * (SdwUtil.cosTab[n3] >> 1) >> 14;
        this.pg += (SdwUtil.sinTab[n] >> 1) * (SdwUtil.sinTab[n3] >> 1) >> 14;
        this.ph = (SdwUtil.cosTab[n] >> 1) * (SdwUtil.sinTab[n2] >> 1) >> 14;
        this.ph = (this.ph >> 1) * (SdwUtil.sinTab[n3] >> 1) >> 14;
        this.ph -= (SdwUtil.sinTab[n] >> 1) * (SdwUtil.cosTab[n3] >> 1) >> 14;
        this.pi = (SdwUtil.cosTab[n] >> 1) * (SdwUtil.cosTab[n2] >> 1) >> 14;
    }

    void RotateObject() {
        for (int i = 0; i < this.nrPoints; ++i) {
            int n = this.x[i];
            int n2 = this.y[i];
            int n3 = this.z[i];
            this.rx[i] = (n >> 8) * this.pa + (n2 >> 8) * this.pb + (n3 >> 8) * this.pc >> 8;
            this.ry[i] = (n >> 8) * this.pd + (n2 >> 8) * this.pe + (n3 >> 8) * this.pf >> 8;
            this.rz[i] = (n >> 8) * this.pg + (n2 >> 8) * this.ph + (n3 >> 8) * this.pi >> 8;
        }
    }

    void ProjectObject(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < this.nrPoints) {
            int n6 = this.rz[n5];
            n6 = n6 * n >> 16;
            this.prx[n5] = this.rx[n5] * n3 / (n6 += n2) >> 8;
            this.pry[n5] = this.ry[n5] * n4 / n6 >> 8;
            int n7 = n5;
            this.rx[n7] = this.rx[n7] >> 16;
            int n8 = n5;
            this.ry[n8] = this.ry[n8] >> 16;
            int n9 = n5++;
            this.rz[n9] = this.rz[n9] >> 16;
        }
    }

    boolean SurfaceHidden(int n, int n2, int n3) {
        int n4 = this.rx[n2] - this.rx[n];
        int n5 = this.ry[n3] - this.ry[n2];
        int n6 = this.ry[n2] - this.ry[n];
        int n7 = this.rx[n3] - this.rx[n2];
        return n4 * n5 - n6 * n7 > 0;
    }

    int mborg_sqrt(int n) {
        int n2 = 0;
        int n3 = 32768;
        do {
            if ((n2 ^= n3) * n2 <= n) continue;
            n2 ^= n3;
        } while ((n3 >>= 1) != 0);
        return n2;
    }

    int SurfaceNormal(int n, int n2, int n3) {
        int n4 = this.ry[n2] - this.ry[n];
        int n5 = this.rz[n3] - this.rz[n2];
        int n6 = this.rz[n2] - this.rz[n];
        int n7 = this.ry[n3] - this.ry[n2];
        int n8 = n4 * n5 - n6 * n7;
        int n9 = this.rx[n3] - this.rx[n2];
        int n10 = this.rx[n2] - this.rx[n];
        int n11 = n6 * n9 - n10 * n5;
        int n12 = n10 * n7 - n4 * n9;
        int n13 = this.mborg_sqrt(n8 * n8 + n11 * n11 + n12 * n12);
        if (n13 > 0) {
            n12 = 255 * n12 / n13;
            return n12;
        }
        return 0;
    }

    void DrawSolidShaded(Graphics graphics, int n, int n2) {
        int n3 = 0;
        while (this.faceList[n3] > 0) {
            int n4;
            int n5 = this.faceList[n3];
            if ((n4 = this.SurfaceNormal(this.faceList[++n3], this.faceList[n3 + 1], this.faceList[n3 + 2])) < 0) {
                n4 = -n4;
                graphics.setColor(n4 << 16 | n4 << 8 | n4);
                SdwUtil.DrawTriangle(graphics, n + this.prx[this.faceList[n3]], n2 + this.pry[this.faceList[n3]], n + this.prx[this.faceList[n3 + 1]], n2 + this.pry[this.faceList[n3 + 1]], n + this.prx[this.faceList[n3 + 2]], n2 + this.pry[this.faceList[n3 + 2]]);
            }
            n3 += n5;
        }
    }
}

