/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Random;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

class Profile
extends Form
implements CommandListener {
    OptionsScreen os;
    TextField h;
    TextField n;
    TextField c;
    TextField pass;
    ChoiceGroup codepage;
    ChoiceGroup phonepage;
    String name;
    Command ok = new Command("Ok", 4, 1);
    Command cancel = new Command("Cancel", 3, 2);
    String bh;
    String bn;
    String bc;
    String bpass;
    int bcodepage;
    int bphonepage;

    public Profile(String string, String string2, String string3, String string4, String string5, int n, int n2) {
        super("Profile \"" + string + "\"");
        this.name = string;
        this.h = new TextField("Host", string2, 40, 0);
        this.n = new TextField("Nick", string3, 16, 0);
        this.c = new TextField("Channels", string4, 96, 0);
        this.pass = new TextField("Password", string5, 32, 65536);
        this.codepage = new ChoiceGroup("Codepage", 1);
        this.codepage.append("None", null);
        this.codepage.append("Direct conversion", null);
        this.codepage.append("CP1251 Cyrillic", null);
        this.codepage.append("KOI8-R Russian", null);
        this.codepage.append("UTF-8", null);
        this.codepage.setSelectedIndex(n, true);
        this.phonepage = new ChoiceGroup("Phone Input", 1);
        this.phonepage.append("None", null);
        this.phonepage.append("S55-Russian", null);
        this.phonepage.append("C100-Russian", null);
        this.phonepage.setSelectedIndex(n2, true);
        this.append((Item)this.h);
        this.append((Item)this.n);
        this.append((Item)this.c);
        this.append((Item)this.pass);
        this.append((Item)this.codepage);
        this.append((Item)this.phonepage);
        this.addCommand(this.ok);
        this.addCommand(this.cancel);
        this.setCommandListener(this);
        this.set();
    }

    public static Profile decode(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.read();
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            String string3 = dataInputStream.readUTF();
            String string4 = dataInputStream.readUTF();
            String string5 = dataInputStream.readUTF();
            int n = dataInputStream.read();
            int n2 = dataInputStream.read();
            dataInputStream.close();
            return new Profile(string, string2, string3, string4, string5, n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Profile getDefault(String string) {
        Random random = new Random();
        return new Profile(string, "irc.freenode.net:6667", "Virca" + Math.abs(random.nextInt()) % 10000, "#virca", "", 4, 0);
    }

    public byte[] encode() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(0);
            dataOutputStream.writeUTF(this.getName());
            dataOutputStream.writeUTF(this.getHost());
            dataOutputStream.writeUTF(this.getNick());
            dataOutputStream.writeUTF(this.getChan());
            dataOutputStream.writeUTF(this.getPass());
            dataOutputStream.write(this.getCodepage());
            dataOutputStream.write(this.getPhonepage());
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String generateUser() {
        Random random = new Random();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('v');
        int n = 0;
        while (n < 5) {
            stringBuffer.append((char)(97 + Math.abs(random.nextInt()) % 26));
            ++n;
        }
        stringBuffer.append('a');
        System.err.println(stringBuffer);
        return stringBuffer.toString();
    }

    public void setOptionsScreen(OptionsScreen optionsScreen) {
        this.os = optionsScreen;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cancel) {
            this.reset();
            this.os.profCompleted();
            return;
        }
        if (this.h.getString().indexOf(":") == -1) {
            this.os.getVirca().displayError("Bad host", "Hostnames must be specified in the form \"hostname:port\"", (Displayable)this);
        } else if (this.n.getString().length() == 0) {
            this.os.getVirca().displayError("Bad nick", "Please type in a nickname.", (Displayable)this);
        } else {
            this.os.profCompleted();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.h.getString();
    }

    public String getNick() {
        return this.n.getString();
    }

    public String getChan() {
        return this.c.getString();
    }

    public String getPass() {
        return this.pass.getString();
    }

    public int getCodepage() {
        return this.codepage.getSelectedIndex();
    }

    public int getPhonepage() {
        return this.phonepage.getSelectedIndex();
    }

    public void set() {
        this.bh = this.getHost();
        this.bn = this.getNick();
        this.bc = this.getChan();
        this.bpass = this.getPass();
        this.bcodepage = this.getCodepage();
        this.bphonepage = this.getPhonepage();
    }

    public void reset() {
        this.h.setString(this.bh);
        this.n.setString(this.bn);
        this.c.setString(this.bc);
        this.pass.setString(this.bpass);
        this.codepage.setSelectedIndex(this.bcodepage, true);
        this.phonepage.setSelectedIndex(this.bphonepage, true);
    }
}

